/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity;

import betterwithmods.util.InvUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fluids.IFluidBlock;

public class EntityDynamite
extends Entity
implements IProjectile {
    private static final float pi = 3.141593f;
    public ItemStack stack;
    private int fuse;

    public EntityDynamite(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.4f);
        this.fuse = -1;
        this.field_70156_m = true;
        this.stack = null;
        this.field_70178_ae = true;
    }

    public EntityDynamite(World world, double xPos, double yPos, double zPos, ItemStack stack) {
        super(world);
        this.func_70107_b(xPos, yPos, zPos);
        this.stack = stack;
        this.fuse = 100;
    }

    public EntityDynamite(World world, EntityLivingBase owner, ItemStack stack, boolean isLit) {
        this(world);
        this.func_70012_b(owner.field_70165_t, owner.field_70163_u + (double)owner.func_70047_e(), owner.field_70161_v, owner.field_70177_z, owner.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.field_70163_u -= 0.1;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f)) * 0.4f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f)) * 0.4f;
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * 3.141593f)) * 0.4f;
        this.stack = stack;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 0.75f, 1.0f);
        if (isLit) {
            this.fuse = 100;
        }
    }

    public void func_70071_h_() {
        IFluidBlock fluid;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70163_u);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        Block block = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        if (block == Blocks.field_150356_k || block == Blocks.field_150353_l) {
            this.fuse = 1;
        } else if (block instanceof IFluidBlock && (fluid = (IFluidBlock)block).getFluid().getTemperature() > 1299) {
            this.fuse = 1;
        }
        if (this.fuse > 0) {
            if (!this.func_130014_f_().field_72995_K && this.fuse % 20 == 0) {
                this.func_130014_f_().func_184133_a(null, new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), SoundEvents.field_187904_gd, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
            --this.fuse;
            if (this.fuse == 0) {
                this.func_70106_y();
                if (!this.func_130014_f_().field_72995_K) {
                    this.explode();
                }
            }
            if (this.func_130014_f_().field_72995_K) {
                float smokeOffset = 0.25f;
                if (block instanceof BlockLiquid && this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151586_h || block instanceof IFluidBlock && this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151586_h) {
                    this.func_130014_f_().func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)smokeOffset, this.field_70163_u - this.field_70181_x * (double)smokeOffset, this.field_70161_v - this.field_70179_y * (double)smokeOffset, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                } else {
                    this.func_130014_f_().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t - this.field_70159_w * (double)smokeOffset, this.field_70163_u - this.field_70181_x * (double)smokeOffset, this.field_70161_v - this.field_70179_y * (double)smokeOffset, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
            }
        } else if (block instanceof BlockFire) {
            this.fuse = 100;
            this.func_130014_f_().func_184133_a(null, new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), SoundEvents.field_187904_gd, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        } else if (this.field_70122_E && Math.abs(this.field_70159_w) < 0.01 && Math.abs(this.field_70181_x) < 0.01 && Math.abs(this.field_70179_y) < 0.01 && !this.func_130014_f_().field_72995_K) {
            this.convertToItem();
            return;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70181_x -= 0.04;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= 0.98;
        this.field_70181_x *= 0.98;
        this.field_70179_y *= 0.98;
        if (this.field_70122_E) {
            this.field_70159_w *= 0.7;
            this.field_70179_y *= 0.7;
            this.field_70181_x *= -0.5;
        }
        this.func_70066_B();
    }

    public void func_70186_c(double dX, double dY, double dZ, float angle, float f) {
        float sqrt = MathHelper.func_76133_a((double)(dX * dX + dY * dY + dZ * dZ));
        dX /= (double)sqrt;
        dY /= (double)sqrt;
        dZ /= (double)sqrt;
        dX += this.field_70146_Z.nextGaussian() * 0.0075 * (double)f;
        dY += this.field_70146_Z.nextGaussian() * 0.0075 * (double)f;
        dZ += this.field_70146_Z.nextGaussian() * 0.0075 * (double)f;
        this.field_70159_w = dX *= (double)angle;
        this.field_70181_x = dY *= (double)angle;
        this.field_70179_y = dZ *= (double)angle;
        float pitch = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(dX, dZ) * 180.0 / (double)3.141593f);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(dY, pitch) * 180.0 / (double)3.141593f);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound tag) {
        if (tag.func_74764_b("Fuse")) {
            this.fuse = tag.func_74762_e("Fuse");
        }
    }

    protected void func_70014_b(NBTTagCompound tag) {
        if (this.fuse > 0) {
            tag.func_74768_a("Fuse", this.fuse);
        }
    }

    public void explode() {
        float intensity = 1.5f;
        this.func_130014_f_().func_72876_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, intensity, true);
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70163_u);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        Block block = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        if (block instanceof BlockLiquid && this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151586_h) {
            this.redneckFishing(x, y, z);
        }
    }

    private void redneckFishing(int x, int y, int z) {
        for (int i = x - 3; i < x + 4; ++i) {
            for (int j = y - 2; j < y + 4; ++j) {
                for (int k = z - 3; k < z + 4; ++k) {
                    if (!this.isWaterBlock(i, j, k) || this.field_70146_Z.nextInt(20) != 0) continue;
                    this.spawnDeadFish(i, j, k);
                }
            }
        }
    }

    private boolean isWaterBlock(int x, int y, int z) {
        Block block = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        return block instanceof BlockLiquid && this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151586_h;
    }

    private void spawnDeadFish(int x, int y, int z) {
        LootContext.Builder build = new LootContext.Builder((WorldServer)this.func_130014_f_());
        for (ItemStack stack : this.func_130014_f_().func_184146_ak().func_186521_a(LootTableList.field_186387_al).func_186462_a(this.func_130014_f_().field_73012_v, build.func_186471_a())) {
            EntityItem item = new EntityItem(this.func_130014_f_(), (double)x, (double)y, (double)z, stack.func_77946_l());
            this.func_130014_f_().func_72838_d((Entity)item);
        }
    }

    private void convertToItem() {
        if (!this.func_130014_f_().field_72995_K) {
            InvUtils.ejectStack(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.stack);
        }
        this.func_70106_y();
    }
}

