/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity.item;

import betterwithmods.module.hardcore.HCBuoy;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityItemBuoy
extends EntityItem {
    private static final byte BUOYANCY_MAX_ITERATIONS = 10;
    private EntityItem watchItem = null;

    public EntityItemBuoy(EntityItem orig) {
        super(orig.func_130014_f_(), orig.field_70165_t, orig.field_70163_u, orig.field_70161_v, orig.func_92059_d());
        NBTTagCompound originalData = new NBTTagCompound();
        orig.func_70014_b(originalData);
        this.func_70037_a(originalData);
        String thrower = orig.func_145800_j();
        EntityPlayer entity = thrower == null ? null : orig.func_130014_f_().func_72924_a(thrower);
        double tossSpeed = entity != null && entity.func_70051_ag() ? 2.0 : 1.0;
        this.field_70159_w = orig.field_70159_w * tossSpeed;
        this.field_70181_x = orig.field_70181_x * tossSpeed;
        this.field_70179_y = orig.field_70179_y * tossSpeed;
    }

    public EntityItemBuoy(World world) {
        super(world);
    }

    private void setAge(int age) {
        this.field_70292_b = age;
    }

    private int getAge0() {
        return this.field_70292_b;
    }

    private DataParameter<ItemStack> getITEM() {
        return field_184533_c;
    }

    private int getPickupDelay() {
        return this.field_145804_b;
    }

    public void func_70071_h_() {
        ItemStack stack;
        if (this.watchItem != null && !this.watchItem.field_70128_L) {
            if (this.isEntityItemFake(this.watchItem)) {
                this.func_70106_y();
            } else if (this.watchItem.field_70292_b > 2) {
                this.watchItem.func_70106_y();
                this.watchItem.func_174871_r();
            }
        }
        if (!(stack = (ItemStack)this.func_184212_Q().func_187225_a(this.getITEM())).func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b().onEntityItemUpdate((EntityItem)this)) {
            return;
        }
        if (this.func_92059_d().func_190926_b()) {
            this.func_70106_y();
        } else {
            boolean flag;
            if (!this.func_130014_f_().field_72995_K) {
                this.func_70052_a(6, this.func_184202_aL());
            }
            this.func_70030_z();
            if (this.getPickupDelay() > 0 && this.getPickupDelay() != Short.MAX_VALUE) {
                this.func_174867_a(this.getPickupDelay() - 1);
            }
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            if (!this.func_189652_ae()) {
                this.field_70181_x -= (double)0.04f;
            }
            this.updateBuoy();
            this.field_70145_X = this.func_145771_j(this.field_70165_t, (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.field_70161_v);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            boolean bl = flag = (int)this.field_70169_q != (int)this.field_70165_t || (int)this.field_70167_r != (int)this.field_70163_u || (int)this.field_70166_s != (int)this.field_70161_v;
            if (flag || this.field_70173_aa % 25 == 0) {
                if (this.func_130014_f_().func_180495_p(new BlockPos((Entity)this)).func_185904_a() == Material.field_151587_i) {
                    this.field_70181_x = 0.2f;
                    this.field_70159_w = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
                    this.field_70179_y = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
                    this.func_184185_a(SoundEvents.field_187658_bx, 0.4f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
                }
                if (!this.func_130014_f_().field_72995_K) {
                    this.func_85054_d();
                }
            }
            float f = 0.98f;
            if (this.field_70122_E) {
                f = this.func_130014_f_().func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.98f;
            }
            this.field_70159_w *= (double)f;
            this.field_70181_x *= (double)0.98f;
            this.field_70179_y *= (double)f;
            if (this.field_70122_E) {
                this.field_70181_x *= -0.5;
            }
            if (this.getAge0() != Short.MIN_VALUE) {
                this.setAge(this.getAge0() + 1);
            }
            ItemStack item = (ItemStack)this.func_184212_Q().func_187225_a(this.getITEM());
            if (!this.func_130014_f_().field_72995_K && this.getAge0() >= this.lifespan) {
                int hook = ForgeEventFactory.onItemExpire((EntityItem)this, (ItemStack)item);
                if (hook < 0) {
                    this.func_70106_y();
                } else {
                    this.lifespan += hook;
                }
            }
            if (item.func_190916_E() <= 0) {
                this.func_70106_y();
            }
        }
    }

    private void updateBuoy() {
        double waterAccumulator = 0.0;
        double offset = 0.1;
        for (int i = 0; i < 10; ++i) {
            double low = this.func_174813_aQ().field_72338_b + (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) * (double)i * 0.375 + 0.1;
            double high = this.func_174813_aQ().field_72338_b + (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) * (double)(i + 1) * 0.375 + 0.1;
            AxisAlignedBB boundingBox = new AxisAlignedBB(this.func_174813_aQ().field_72340_a, low, this.func_174813_aQ().field_72339_c, this.func_174813_aQ().field_72336_d, high, this.func_174813_aQ().field_72334_f);
            if (!this.isAABBInMaterial(this.func_130014_f_(), boundingBox, Material.field_151586_h)) break;
            waterAccumulator += 0.1;
        }
        if (waterAccumulator > 0.001) {
            if (!this.isDrifted()) {
                float buoyancy = HCBuoy.getBuoyancy(this.func_92059_d()) + 1.0f;
                this.field_70181_x += 0.04 * (double)buoyancy * waterAccumulator;
            }
            this.field_70159_w *= 0.9;
            this.field_70181_x *= 0.9;
            this.field_70179_y *= 0.9;
        }
    }

    private boolean isDrifted() {
        int minX = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72340_a);
        int maxX = MathHelper.func_76128_c((double)(this.func_174813_aQ().field_72336_d + 1.0));
        int minY = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int maxY = MathHelper.func_76128_c((double)(this.func_174813_aQ().field_72337_e + 1.0));
        int minZ = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72339_c);
        int maxZ = MathHelper.func_76128_c((double)(this.func_174813_aQ().field_72334_f + 1.0));
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    if (!this.checkBlockDrifting(x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean checkBlockDrifting(int x, int y, int z) {
        for (int height = y - 1; height <= y + 1; ++height) {
            int meta;
            IBlockState blockState = this.func_130014_f_().func_180495_p(new BlockPos(x, height, z));
            if (blockState.func_177230_c() != Blocks.field_150358_i && blockState.func_177230_c() != Blocks.field_150355_j || (meta = blockState.func_177230_c().func_176201_c(blockState)) < 8) continue;
            return true;
        }
        return false;
    }

    private boolean isAABBInMaterial(World world, AxisAlignedBB bb, Material materialIn) {
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76143_f((double)bb.field_72336_d);
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76143_f((double)bb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)bb.field_72334_f);
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    IBlockState iblockstate = world.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_181079_c(k1, l1, i2));
                    Boolean result = iblockstate.func_177230_c().isAABBInsideMaterial(world, (BlockPos)blockpos$pooledmutableblockpos, bb, materialIn);
                    if (result != null) {
                        return result;
                    }
                    if (iblockstate.func_185904_a() != materialIn) continue;
                    int j2 = (Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b);
                    double d0 = l1 + 1;
                    if (j2 < 8) {
                        d0 = (double)(l1 + 1) - (double)j2 / 8.0;
                    }
                    if (!(d0 >= bb.field_72338_b)) continue;
                    blockpos$pooledmutableblockpos.func_185344_t();
                    return true;
                }
            }
        }
        blockpos$pooledmutableblockpos.func_185344_t();
        return false;
    }

    public void setWatchItem(EntityItem item) {
        this.watchItem = item;
    }

    private boolean isEntityItemFake(EntityItem item) {
        return item.field_145804_b == Short.MAX_VALUE && item.field_70292_b == item.func_92059_d().func_77973_b().getEntityLifespan(item.func_92059_d(), item.func_130014_f_()) - 1;
    }
}

