/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.items;

import betterwithmods.api.IMultiLocations;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockAxle;
import betterwithmods.common.blocks.BlockMillGenerator;
import betterwithmods.common.blocks.BlockWaterwheel;
import betterwithmods.common.blocks.BlockWindmill;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMechanical
extends Item
implements IMultiLocations {
    private final String[] names = new String[]{"windmill", "waterwheel", "windmill_vertical"};

    public ItemMechanical() {
        this.func_77637_a(BWCreativeTabs.BWTAB);
        this.field_77777_bU = 1;
        this.func_77627_a(true);
    }

    @Override
    public String[] getLocations() {
        return this.names;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        if (this.names[stack.func_77960_j()].contains("windmill")) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.windmill.name", (Object[])new Object[0]));
        }
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == BWMBlocks.AXLE) {
            EnumFacing.Axis axis = (EnumFacing.Axis)world.func_180495_p(pos).func_177229_b(BlockAxle.AXIS);
            if (axis == EnumFacing.Axis.Y && stack.func_77952_i() == 2) {
                if (this.isVerticalWindmillValid(player, world, pos, hitY)) {
                    stack.func_190918_g(1);
                }
            } else if (axis != EnumFacing.Axis.Y && stack.func_77952_i() != 2 && this.isHorizontalDeviceValid(player, world, pos, stack.func_77952_i(), axis)) {
                stack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private boolean isHorizontalDeviceValid(EntityPlayer player, World world, BlockPos pos, int meta, EnumFacing.Axis axis) {
        boolean valid = false;
        if (meta == 1 && this.validateWaterwheel(world, pos, axis)) {
            if (axis != EnumFacing.Axis.Y) {
                world.func_175656_a(pos, ((BlockWaterwheel)BWMBlocks.WATERWHEEL).getAxisState(axis));
                valid = true;
            }
        } else if (meta == 1 && world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString("Not enough room to place the waterwheel. Need a 5x5 area to work."));
        }
        if (meta == 0 && this.validateWindmill(world, pos, axis)) {
            if (axis != EnumFacing.Axis.Y) {
                world.func_175656_a(pos, ((BlockWindmill)BWMBlocks.WINDMILL_BLOCK).getAxisState(axis));
                valid = true;
            }
        } else if (meta == 0 && world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString("Not enough room to place the windmill. Need a 13x13 area to work."));
        }
        return valid;
    }

    public boolean validateWaterwheel(World world, BlockPos pos, EnumFacing.Axis axis) {
        return this.validateHorizontal(world, pos, 2, axis, true);
    }

    public boolean validateWindmill(World world, BlockPos pos, EnumFacing.Axis axis) {
        return this.validateHorizontal(world, pos, 6, axis, false);
    }

    public boolean validateHorizontal(World world, BlockPos pos, int radius, EnumFacing.Axis axis, boolean isWheel) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        boolean valid = true;
        for (int vert = -radius; vert <= radius; ++vert) {
            for (int i = -radius; i <= radius; ++i) {
                int xP = axis == EnumFacing.Axis.Z ? i : 0;
                int zP = axis == EnumFacing.Axis.X ? i : 0;
                int xPos = x + xP;
                int yPos = y + vert;
                int zPos = z + zP;
                BlockPos checkPos = new BlockPos(xPos, yPos, zPos);
                if (yPos == y - radius && isWheel) {
                    valid = (world.func_175623_d(checkPos) || world.func_72875_a(new AxisAlignedBB((double)xPos, (double)yPos, (double)zPos, (double)(xPos + 1), (double)(yPos + 1), (double)(zPos + 1)), Material.field_151586_h)) && !this.isNearMechMachine(world, checkPos, axis);
                } else {
                    if (xP == 0 && yPos == y && zP == 0) continue;
                    if (isWheel && (xP == -radius || xP == radius || zP == -radius || zP == radius)) {
                        valid = (world.func_175623_d(checkPos) || world.func_72875_a(new AxisAlignedBB((double)xPos, (double)yPos, (double)zPos, (double)(xPos + 1), (double)(yPos + 1), (double)(zPos + 1)), Material.field_151586_h)) && !this.isNearMechMachine(world, checkPos, axis);
                    } else {
                        boolean bl = valid = world.func_175623_d(checkPos) && !this.isNearMechMachine(world, checkPos, axis);
                    }
                }
                if (!valid) break;
            }
            if (!valid) break;
        }
        return valid;
    }

    private boolean isNearMechMachine(World world, BlockPos pos, EnumFacing.Axis axis) {
        for (int i = -3; i < 4; ++i) {
            int zP;
            int xP = axis == EnumFacing.Axis.X ? i : 0;
            BlockPos check = pos.func_177982_a(xP, 0, zP = axis == EnumFacing.Axis.Z ? i : 0);
            if (!(world.func_180495_p(check).func_177230_c() instanceof BlockMillGenerator)) continue;
            return true;
        }
        return false;
    }

    private boolean isVerticalWindmillValid(EntityPlayer player, World world, BlockPos pos, float flY) {
        boolean valid = false;
        int yPos = 0;
        yPos = flY > 0.5f ? (yPos += 3) : (yPos -= 3);
        BlockPos target = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + yPos, pos.func_177952_p());
        if (this.checkForSupportingAxles(world, target)) {
            if (this.validateArea(player, world, target)) {
                world.func_175656_a(target, BWMBlocks.WINDMILL_BLOCK.func_176223_P().func_177226_a(BlockMillGenerator.AXIS, (Comparable)EnumFacing.Axis.Y));
                valid = true;
            } else if (world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString("Not enough room to place the windmill. Need a 9x9 area with a HEIGHT of seven to work."));
            }
        } else if (world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString("Too few vertical axles in column to place here. (Need seven)"));
        }
        return valid;
    }

    public boolean validateArea(EntityPlayer player, World world, BlockPos pos) {
        boolean clear = true;
        for (int yP = -4; yP < 5; ++yP) {
            for (int xP = -4; xP < 5; ++xP) {
                for (int zP = -4; zP < 5; ++zP) {
                    int x = pos.func_177958_n();
                    int y = pos.func_177956_o();
                    int z = pos.func_177952_p();
                    BlockPos target = new BlockPos(x + xP, y + yP, z + zP);
                    if (x + xP != x && z + zP != z && yP != -4 && yP != 4) {
                        clear = world.func_175623_d(target);
                    } else if ((Math.sqrt(xP * xP) == 4.0 || Math.sqrt(zP * zP) == 4.0) && Math.sqrt(yP * yP) != 4.0) {
                        boolean bl = clear = world.func_175623_d(target) && this.isVertClear(world, target, xP, zP);
                    }
                    if ((yP == -4 || yP == 4) && xP == 0 && zP == 0) {
                        boolean bl = clear = !(world.func_180495_p(target).func_177230_c() instanceof BlockWindmill);
                    }
                    if (clear) continue;
                    if (!world.field_72995_K) break;
                    player.func_145747_a((ITextComponent)new TextComponentString("Blockage at x:" + (x + xP) + " y:" + (y + yP) + " z:" + (z + zP)));
                    break;
                }
                if (!clear) break;
            }
            if (!clear) break;
        }
        for (int i = 5; i < 8 && clear; ++i) {
            int yMin = -i;
            BlockPos minPos = pos.func_177982_a(0, yMin, 0);
            BlockPos maxPos = pos.func_177982_a(0, i, 0);
            if (world.func_180495_p(minPos).func_177230_c() instanceof BlockWindmill) {
                clear = false;
            }
            if (!clear) break;
            if (world.func_180495_p(maxPos).func_177230_c() instanceof BlockWindmill) {
                clear = false;
            }
            if (!clear) break;
        }
        return clear;
    }

    private boolean isVertClear(World world, BlockPos pos, int xP, int zP) {
        if (!(xP != -4 && xP != 4 || this.vertCheck(world, pos, EnumFacing.Axis.X, xP < 0))) {
            return false;
        }
        return zP != -4 && zP != 4 || this.vertCheck(world, pos, EnumFacing.Axis.Z, zP < 0);
    }

    private boolean vertCheck(World world, BlockPos pos, EnumFacing.Axis axis, boolean negative) {
        for (int i = 0; i < 4; ++i) {
            BlockPos check;
            int zP;
            int xP = axis == EnumFacing.Axis.X ? i : 0;
            int n = zP = axis == EnumFacing.Axis.Z ? i : 0;
            if (negative) {
                xP *= -1;
                zP *= -1;
            }
            if (!(world.func_180495_p(check = pos.func_177982_a(xP, 0, zP)).func_177230_c() instanceof BlockMillGenerator)) continue;
            return false;
        }
        return true;
    }

    private boolean checkForSupportingAxles(World world, BlockPos pos) {
        for (int i = -3; i <= 3; ++i) {
            BlockPos target = pos.func_177982_a(0, i, 0);
            Block targetBlock = world.func_180495_p(target).func_177230_c();
            if (targetBlock != BWMBlocks.AXLE) {
                return false;
            }
            EnumFacing.Axis axis = (EnumFacing.Axis)world.func_180495_p(target).func_177229_b(BlockAxle.AXIS);
            if (axis == EnumFacing.Axis.Y) continue;
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < 3; ++i) {
            list.add((Object)new ItemStack(item, 1, i));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + this.names[stack.func_77952_i()];
    }
}

