/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry;

import betterwithmods.common.BWOreDictionary;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ChoppingRecipe
extends ShapelessOreRecipe {
    private final Object log;
    private final ItemStack bark;
    private final ItemStack sawdust;

    public ChoppingRecipe(ItemStack planks, ItemStack bark, ItemStack sawdust, Object log) {
        super(planks, new Object[]{new ItemStack(Items.field_151036_c, 1, Short.MAX_VALUE), log});
        this.log = log;
        this.bark = bark;
        this.sawdust = sawdust;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ChoppingRecipe(ItemStack planks, ItemStack sawdust, Object log) {
        this(planks, ItemStack.field_190927_a, sawdust, log);
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return this.isMatch((IInventory)inv);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMatch(IInventory inventory) {
        boolean hasAxe = false;
        boolean hasLog = false;
        for (int x = 0; x < inventory.func_70302_i_(); ++x) {
            boolean inRecipe = false;
            ItemStack slot = inventory.func_70301_a(x);
            if (slot.func_190926_b()) continue;
            if (this.isAxe(slot)) {
                if (hasAxe) return false;
                hasAxe = true;
                inRecipe = true;
            } else if (this.log instanceof ItemStack) {
                if (OreDictionary.itemMatches((ItemStack)slot, (ItemStack)((ItemStack)this.log), (boolean)true)) {
                    if (hasLog) return false;
                    hasLog = true;
                    inRecipe = true;
                }
            } else {
                if (!(this.log instanceof String)) return false;
                if (BWOreDictionary.listContains(slot, (List<ItemStack>)OreDictionary.getOres((String)((String)this.log)))) {
                    if (hasLog) return false;
                    hasLog = true;
                    inRecipe = true;
                }
            }
            if (inRecipe) continue;
            return false;
        }
        if (!hasAxe) return false;
        if (!hasLog) return false;
        return true;
    }

    private boolean isAxe(ItemStack stack) {
        if (stack != null && stack.func_77973_b().getToolClasses(stack).contains("axe")) {
            return !stack.func_77973_b().getRegistryName().func_110624_b().equals("tconstruct") || stack.func_77952_i() < stack.func_77958_k();
        }
        return false;
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList stacks = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !this.isAxe(stack)) continue;
            ItemStack copy = stack.func_77946_l();
            if (copy.func_77973_b().getHarvestLevel(copy, "axe", null, null) > 1) {
                stacks.set(i, (Object)copy.func_77946_l());
                continue;
            }
            if (!copy.func_96631_a(1, new Random())) {
                stacks.set(i, (Object)copy.func_77946_l());
                continue;
            }
            if (!copy.func_77973_b().getRegistryName().func_110624_b().equals("tconstruct")) continue;
            stacks.set(i, (Object)copy.func_77946_l());
        }
        return stacks;
    }

    @SubscribeEvent
    public void dropExtra(PlayerEvent.ItemCraftedEvent event) {
        if (event.player == null) {
            return;
        }
        if (this.isMatch(event.craftMatrix)) {
            if (!event.player.func_130014_f_().field_72995_K) {
                if (!this.sawdust.func_190926_b()) {
                    event.player.func_70099_a(this.sawdust.func_77946_l(), 0.0f);
                }
                if (!this.bark.func_190926_b()) {
                    event.player.func_70099_a(this.bark.func_77946_l(), 0.0f);
                }
            } else {
                event.player.func_184185_a(SoundEvents.field_187927_ha, 0.25f, 2.5f);
            }
        }
    }
}

