/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry;

import betterwithmods.BWMod;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class HopperFilters {
    public static final HashMap<Integer, Predicate<ItemStack>> filters = new HashMap();
    public static final HashMap<ItemStack, Integer> filterTypes = new HashMap();

    public static boolean containsStack(Set<ItemStack> set, ItemStack stack) {
        Optional<ItemStack> found = set.stream().filter(s -> s.func_77969_a(stack)).findFirst();
        return found.isPresent();
    }

    public static void addFilter(ItemStack stack, Set<ItemStack> allowedItems) {
        HopperFilters.addFilter(filters.size() + 1, stack, s -> HopperFilters.containsStack(allowedItems, s));
    }

    public static void addFilter(int type, Block block, int meta, Predicate<ItemStack> allowed) {
        HopperFilters.addFilter(type, new ItemStack(block, 1, meta), allowed);
    }

    public static void addFilter(int type, ItemStack filter, Predicate<ItemStack> allowed) {
        if (filterTypes.containsKey(filter)) {
            throw new IllegalArgumentException("Filter " + filter.func_82833_r() + "For Type " + type + " Already exists");
        }
        if (filters.containsKey(type)) {
            throw new IllegalArgumentException("Filter " + type + " Already exists");
        }
        BWMod.logger.info("Adding Filter " + filter.func_82833_r() + "," + type);
        filterTypes.put(filter, type);
        filters.put(type, allowed);
    }

    public static List<ItemStack> getFilter(int type) {
        return filterTypes.entrySet().stream().filter(entry -> (Integer)entry.getValue() == type).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static Predicate<ItemStack> getAllowedItems(int type) {
        return filters.get(type);
    }

    public static int getFilterType(ItemStack filter) {
        Optional<Integer> type = filterTypes.entrySet().stream().filter(e -> ((ItemStack)e.getKey()).func_77973_b() == filter.func_77973_b() && (((ItemStack)e.getKey()).func_77960_j() == filter.func_77960_j() || ((ItemStack)e.getKey()).func_77960_j() == Short.MAX_VALUE)).map(Map.Entry::getValue).findAny();
        return type.orElse(0);
    }
}

