/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.tile.SimpleStackHandler;
import betterwithmods.common.blocks.tile.TileEntityFilteredHopper;
import betterwithmods.util.InvUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class HopperInteractions {
    public static final ArrayList<HopperRecipe> RECIPES = new ArrayList();

    public static void addHopperRecipe(HopperRecipe recipe) {
        RECIPES.add(recipe);
    }

    public static boolean attemptToCraft(int filterType, World world, BlockPos pos, EntityItem input) {
        for (HopperRecipe recipe : RECIPES) {
            if (!recipe.isRecipe(filterType, input) || !recipe.canCraft(world, pos)) continue;
            recipe.craft(input, world, pos);
            return true;
        }
        return false;
    }

    public static abstract class HopperRecipe {
        public final ItemStack input;
        public final ItemStack output;
        public final List<ItemStack> secondaryOutput;
        private final int filterType;

        public HopperRecipe(int filterType, ItemStack input, ItemStack output, ItemStack ... secondaryOutput) {
            this.filterType = filterType;
            this.input = input;
            this.output = output;
            this.secondaryOutput = Lists.newArrayList((Object[])secondaryOutput);
        }

        public boolean isRecipe(int filterType, EntityItem inputStack) {
            if (filterType == this.filterType) {
                if (inputStack != null) {
                    ItemStack i = inputStack.func_92059_d();
                    return InvUtils.matches(i, this.input);
                }
                return false;
            }
            return false;
        }

        public void craft(EntityItem inputStack, World world, BlockPos pos) {
            InvUtils.ejectStackWithOffset(world, inputStack.func_180425_c(), this.output.func_77946_l());
            for (int i = 0; i < inputStack.func_92059_d().func_190916_E(); ++i) {
                InvUtils.ejectStackWithOffset(world, inputStack.func_180425_c(), this.secondaryOutput);
            }
            this.onCraft(world, pos, inputStack);
        }

        public void onCraft(World world, BlockPos pos, EntityItem item) {
            item.func_92059_d().func_190918_g(1);
            if (item.func_92059_d().func_190916_E() <= 0) {
                item.func_70106_y();
            }
        }

        public int getFilterType() {
            return this.filterType;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public List<ItemStack> getSecondaryOutput() {
            return this.secondaryOutput;
        }

        public boolean canCraft(World world, BlockPos pos) {
            TileEntityFilteredHopper tile = (TileEntityFilteredHopper)world.func_175625_s(pos);
            SimpleStackHandler inventory = tile.inventory;
            boolean flag = true;
            if (!this.secondaryOutput.isEmpty()) {
                for (ItemStack stack : this.secondaryOutput) {
                    if (InvUtils.insert((IItemHandler)inventory, stack, true).func_190926_b()) continue;
                    flag = false;
                    break;
                }
            }
            return flag;
        }
    }

    public static class SoulUrnRecipe
    extends HopperRecipe {
        public SoulUrnRecipe(ItemStack input, ItemStack output) {
            super(6, input, output, new ItemStack(BWMBlocks.URN, 1, 8));
        }

        @Override
        public void craft(EntityItem inputStack, World world, BlockPos pos) {
            InvUtils.ejectStackWithOffset(world, inputStack.func_180425_c(), this.output.func_77946_l());
            this.onCraft(world, pos, inputStack);
        }

        @Override
        public void onCraft(World world, BlockPos pos, EntityItem item) {
            ((TileEntityFilteredHopper)world.func_175625_s(pos)).increaseSoulCount(1);
            if (!world.field_72995_K) {
                world.func_184133_a(null, pos, SoundEvents.field_187551_bH, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.45f);
            }
            super.onCraft(world, pos, item);
        }

        @Override
        public boolean canCraft(World world, BlockPos pos) {
            return true;
        }
    }
}

