/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.tile.TileCamo;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class KilnStructureManager {
    public static Set<IBlockState> KILN_BLOCKS = new HashSet<IBlockState>();

    public static void registerKilnBlock(IBlockState state) {
        KILN_BLOCKS.add(state);
    }

    public static boolean isKilnBlock(IBlockState state) {
        return KILN_BLOCKS.contains(state);
    }

    public static void createKiln(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (KilnStructureManager.isKilnBlock(state) && KilnStructureManager.isValidKiln((IBlockAccess)world, pos)) {
            IBlockState kiln = BWMBlocks.KILN.func_176223_P();
            world.func_175656_a(pos, kiln);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileCamo) {
                ((TileCamo)tile).setCamoState(state);
                world.func_184138_a(pos, kiln, kiln, 8);
            }
        }
    }

    public static boolean isValidKiln(IBlockAccess world, BlockPos pos) {
        int numBrick = 0;
        BlockPos center = pos.func_177984_a();
        for (EnumFacing face : EnumFacing.field_82609_l) {
            IBlockState state;
            if (face == EnumFacing.DOWN || !KilnStructureManager.isKilnBlock(state = world.func_180495_p(center.func_177972_a(face)))) continue;
            ++numBrick;
        }
        return numBrick > 2;
    }

    public static void removeKilnBlock(IBlockState state) {
        KILN_BLOCKS.remove(state);
    }
}

