/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry;

import betterwithmods.util.InvUtils;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreStack {
    private final String oreName;
    private final List<ItemStack> oreStacks;
    private int stackSize;

    public OreStack(String name, int stack) {
        this.oreName = name;
        this.stackSize = stack;
        this.oreStacks = OreDictionary.getOres((String)this.oreName);
    }

    public OreStack copy() {
        return new OreStack(this.oreName, this.stackSize);
    }

    public String getOreName() {
        return this.oreName;
    }

    public List<ItemStack> getItems() {
        return this.setOreSize(this.oreStacks, this.getStackSize());
    }

    public List<ItemStack> getOres() {
        return this.oreStacks;
    }

    public List<ItemStack> setOreSize(List<ItemStack> list, int count) {
        return list.stream().map(i -> InvUtils.setCount(i, count)).collect(Collectors.toList());
    }

    public void addToStack(int amount) {
        this.stackSize += amount;
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public boolean isEmpty() {
        return this.oreStacks.isEmpty();
    }

    public String toString() {
        return String.format("%s: %s", this.oreName, this.oreStacks);
    }
}

