/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.blockmeta.managers;

import betterwithmods.BWMod;
import betterwithmods.common.registry.blockmeta.recipe.BlockMetaRecipe;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public abstract class BlockMetaManager<T extends BlockMetaRecipe> {
    private final ArrayList<T> recipes = Lists.newArrayList();

    public abstract T createRecipe(Block var1, int var2, List<ItemStack> var3);

    public void addRecipe(ItemStack input, ItemStack ... products) {
        if (!input.func_190926_b() && input.func_77973_b() instanceof ItemBlock) {
            this.addRecipe(((ItemBlock)input.func_77973_b()).func_179223_d(), input.func_77960_j(), products);
        } else {
            BWMod.logger.info("BlockMeta inputs: %s must be a block", new Object[]{input});
        }
    }

    public void addRecipe(Block block, int meta, ItemStack ... products) {
        this.addRecipe(this.createRecipe(block, meta, Arrays.asList(products)));
    }

    public void addRecipe(T recipe) {
        this.recipes.add(recipe);
    }

    public boolean contains(ItemStack stack) {
        return stack != null && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlock && this.contains(((ItemBlock)stack.func_77973_b()).func_179223_d(), stack.func_77960_j());
    }

    public boolean contains(Block block, int meta) {
        return this.recipes.stream().filter(r -> r.equals(block, meta)).findFirst().isPresent();
    }

    public ArrayList<T> getRecipes() {
        return this.recipes;
    }

    public T getRecipe(ItemStack stack) {
        assert (stack.func_77973_b() instanceof ItemBlock);
        return this.getRecipe(((ItemBlock)stack.func_77973_b()).func_179223_d(), stack.func_77960_j());
    }

    public T getRecipe(Block block, int meta) {
        Optional<BlockMetaRecipe> recipe = this.recipes.stream().filter(r -> r.equals(block, meta)).findFirst();
        return (T)((BlockMetaRecipe)recipe.orElse(null));
    }

    public NonNullList<ItemStack> getProducts(Block block, int meta) {
        T recipe = this.getRecipe(block, meta);
        if (recipe != null) {
            return ((BlockMetaRecipe)recipe).getOutputs();
        }
        return NonNullList.func_191196_a();
    }

    public List<T> removeRecipes(ItemStack input) {
        ArrayList removed = Lists.newArrayList();
        for (BlockMetaRecipe ir : this.recipes) {
            if (!ir.getStack().func_77969_a(input)) continue;
            removed.add(ir);
        }
        return removed;
    }
}

