/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.bulk.manager;

import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.registry.OreStack;
import betterwithmods.common.registry.bulk.recipes.BulkRecipe;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;

public abstract class CraftingManagerBulk<T extends BulkRecipe> {
    private List<T> recipes = new ArrayList<T>();

    protected CraftingManagerBulk() {
    }

    public T addRecipe(T recipe) {
        if (!((BulkRecipe)recipe).isEmpty()) {
            this.recipes.add(recipe);
        }
        return recipe;
    }

    public List<T> findRecipeForRemoval(@Nonnull ItemStack output) {
        return this.recipes.stream().filter(recipe -> recipe.matches(output)).collect(Collectors.toList());
    }

    public List<T> findRecipeForRemoval(@Nonnull ItemStack output, @Nonnull ItemStack secondary) {
        return this.recipes.stream().filter(recipe -> recipe.matches(output, secondary)).collect(Collectors.toList());
    }

    public List<T> findRecipeForRemoval(@Nonnull ItemStack output, @Nonnull ItemStack secondary, Object ... inputs) {
        ArrayList removed = Lists.newArrayList();
        if (inputs.length > 0) {
            List<T> found = this.findRecipeForRemoval(output, secondary);
            for (BulkRecipe recipe : found) {
                Object input;
                boolean match = true;
                Object[] objectArray = inputs;
                int n = objectArray.length;
                for (int i = 0; i < n && (match = this.hasMatch(input = objectArray[i], recipe.getRecipeInput())); ++i) {
                }
                if (!match) continue;
                removed.add(recipe);
            }
        }
        return removed;
    }

    public boolean removeRecipe(ItemStack output, ItemStack secondary) {
        Iterator<T> iterator = this.recipes.iterator();
        List<T> remove = this.findRecipeForRemoval(output, secondary);
        while (iterator.hasNext()) {
            BulkRecipe next = (BulkRecipe)iterator.next();
            if (!remove.contains(next)) continue;
            iterator.remove();
        }
        return remove.isEmpty();
    }

    public boolean removeRecipe(ItemStack output, ItemStack secondary, Object ... inputs) {
        Iterator<T> iterator = this.recipes.iterator();
        List<T> remove = this.findRecipeForRemoval(output, secondary, inputs);
        while (iterator.hasNext()) {
            BulkRecipe next = (BulkRecipe)iterator.next();
            if (!remove.contains(next)) continue;
            iterator.remove();
        }
        return remove.isEmpty();
    }

    private boolean hasMatch(Object input, List<Object> inputs) {
        block3: {
            block2: {
                System.out.println(input);
                if (!(input instanceof String)) break block2;
                for (Object in : inputs) {
                    if (!(in instanceof OreStack ? input.equals(((OreStack)in).getOreName()) : in instanceof ItemStack && BWOreDictionary.listContains((ItemStack)in, (List<ItemStack>)OreDictionary.getOres((String)((String)input))))) continue;
                    return true;
                }
                break block3;
            }
            if (!(input instanceof ItemStack)) break block3;
            for (Object in : inputs) {
                if (!(in instanceof ItemStack ? ((ItemStack)input).func_77969_a((ItemStack)in) : in instanceof OreStack && BWOreDictionary.listContains((ItemStack)input, ((OreStack)in).getItems()))) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack[] getCraftingResult(ItemStackHandler inv) {
        T recipe = this.getMostValidRecipe(inv);
        if (recipe != null && ((BulkRecipe)recipe).matches(inv)) {
            ItemStack[] ret = new ItemStack[1];
            if (((BulkRecipe)recipe).getSecondary() != null) {
                ret = new ItemStack[2];
                ret[1] = ((BulkRecipe)recipe).getSecondary();
            }
            ret[0] = ((BulkRecipe)recipe).getOutput();
            return ret;
        }
        return null;
    }

    public T getMostValidRecipe(ItemStackHandler inv) {
        TreeSet<T> recipes = this.getValidRecipes(inv);
        if (recipes.isEmpty()) {
            return null;
        }
        return (T)((BulkRecipe)recipes.first());
    }

    private TreeSet<T> getValidRecipes(ItemStackHandler inv) {
        TreeSet<BulkRecipe> recipes = new TreeSet<BulkRecipe>();
        for (BulkRecipe recipe : this.recipes) {
            if (!recipe.matches(inv)) continue;
            recipes.add(recipe);
        }
        return recipes;
    }

    private boolean containsIngredient(List<Object> list, ItemStack stack) {
        for (Object obj : list) {
            if (obj instanceof ItemStack) {
                if (!ItemStack.func_179545_c((ItemStack)((ItemStack)obj), (ItemStack)stack) && (((ItemStack)obj).func_77952_i() != Short.MAX_VALUE || stack.func_77973_b() != ((ItemStack)obj).func_77973_b())) continue;
                return !((ItemStack)obj).func_77942_o() || ItemStack.func_77970_a((ItemStack)stack, (ItemStack)((ItemStack)obj));
            }
            if (!(obj instanceof OreStack) || !BWOreDictionary.listContains(stack, ((OreStack)obj).getItems())) continue;
            return true;
        }
        return false;
    }

    public List<Object> getValidCraftingIngredients(ItemStackHandler inv) {
        T recipe = this.getMostValidRecipe(inv);
        if (recipe != null) {
            return ((BulkRecipe)recipe).getRecipeInput();
        }
        return Lists.newArrayList();
    }

    public NonNullList<ItemStack> craftItem(World world, TileEntity tile, ItemStackHandler inv) {
        T recipe = this.getMostValidRecipe(inv);
        if (recipe != null) {
            return ((BulkRecipe)recipe).onCraft(world, tile, inv);
        }
        return NonNullList.func_191196_a();
    }

    public List<T> getRecipes() {
        return this.recipes;
    }
}

