/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.bulk.recipes;

import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.registry.OreStack;
import betterwithmods.util.InvUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class BulkRecipe
implements Comparable<BulkRecipe> {
    @Nonnull
    protected ItemStack output = ItemStack.field_190927_a;
    @Nonnull
    protected ItemStack secondary = ItemStack.field_190927_a;
    @Nonnull
    protected ArrayList<Object> inputs = new ArrayList();
    @Nonnull
    protected ArrayList<List<ItemStack>> jeiInputs = new ArrayList();
    protected int priority = 0;

    protected BulkRecipe(ItemStack output, Object ... inputs) {
        this(output, ItemStack.field_190927_a, inputs);
    }

    public BulkRecipe(@Nonnull ItemStack output, @Nonnull ItemStack secondaryOutput, Object ... inputs) {
        this.output = output.func_77946_l();
        this.secondary = !secondaryOutput.func_190926_b() ? secondaryOutput.func_77946_l() : ItemStack.field_190927_a;
        int place = -1;
        ArrayList<Object> inputList = new ArrayList<Object>();
        for (Object in : inputs) {
            if (in instanceof Integer || in == null) continue;
            ++place;
            if (in instanceof ItemStack) {
                inputList.add(((ItemStack)in).func_77946_l());
                continue;
            }
            if (in instanceof Item) {
                inputList.add(new ItemStack((Item)in, 1, Short.MAX_VALUE));
                continue;
            }
            if (in instanceof Block) {
                inputList.add(new ItemStack((Block)in, 1, Short.MAX_VALUE));
                continue;
            }
            if (in instanceof String) {
                int count = place + 1 < inputs.length && inputs[place + 1] instanceof Integer ? (Integer)inputs[place + 1] : 1;
                OreStack stack = new OreStack((String)in, count);
                if (stack.isEmpty()) continue;
                inputList.add(stack);
                continue;
            }
            if (in instanceof OreStack) {
                inputList.add(((OreStack)in).copy());
                continue;
            }
            StringBuilder ret = new StringBuilder("Invalid " + this.getClass().getSimpleName() + " recipe: ");
            for (Object tmp : inputList) {
                ret.append(tmp).append(", ");
            }
            ret.append("Output: ").append(output);
            if (!secondaryOutput.func_190926_b()) {
                ret.append(", Secondary: ").append(secondaryOutput);
            }
            throw new RuntimeException(ret.toString());
        }
        this.condenseInputs(inputList);
    }

    public NonNullList<ItemStack> onCraft(World world, TileEntity tile, ItemStackHandler inv) {
        NonNullList list = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
        list.set(0, (Object)this.getOutput());
        list.set(1, (Object)this.getSecondary());
        this.consumeInvIngredients(inv);
        return list;
    }

    private void condenseInputs(ArrayList<Object> list) {
        for (Object obj : list) {
            int contain = BWOreDictionary.listContains(obj, this.inputs);
            if (contain > -1) {
                if (obj instanceof ItemStack) {
                    ((ItemStack)this.inputs.get(contain)).func_190917_f(((ItemStack)obj).func_190916_E());
                    continue;
                }
                if (!(obj instanceof OreStack)) continue;
                ((OreStack)this.inputs.get(contain)).addToStack(((OreStack)obj).getStackSize());
                continue;
            }
            this.inputs.add(obj);
        }
        for (Object obj : this.inputs) {
            ArrayList<ItemStack> in = new ArrayList<ItemStack>();
            if (obj instanceof ItemStack) {
                in.add((ItemStack)obj);
            } else if (obj instanceof OreStack) {
                in.addAll(((OreStack)obj).getItems());
            }
            this.jeiInputs.add(in);
        }
    }

    public List<ItemStack> getOutputs() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.output.func_77946_l(), this.secondary.func_77946_l()});
    }

    @Nonnull
    public ItemStack getOutput() {
        return this.output;
    }

    @Nonnull
    public ItemStack getSecondary() {
        return this.secondary;
    }

    @Nonnull
    public ArrayList<List<ItemStack>> getInputs() {
        return this.jeiInputs;
    }

    public ArrayList<Object> getRecipeInput() {
        return this.inputs;
    }

    public boolean matches(ItemStack output) {
        return this.output.func_77969_a(output);
    }

    public boolean matches(ItemStack output, ItemStack secondary) {
        return this.matches(output) && secondary.func_190926_b() || this.secondary.func_77969_a(secondary);
    }

    public boolean matches(ItemStackHandler inv) {
        ArrayList<Object> required = new ArrayList<Object>(this.inputs);
        if (required.size() > 0) {
            for (Object obj : required) {
                Object stack;
                if (!(obj instanceof ItemStack ? !(stack = (ItemStack)obj).func_190926_b() && InvUtils.countItemStacksInInventory((IItemHandler)inv, (ItemStack)stack) < stack.func_190916_E() : obj instanceof OreStack && InvUtils.countOresInInventory((IItemHandler)inv, ((OreStack)(stack = (OreStack)obj)).getItems()) < ((OreStack)stack).getStackSize())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean consumeInvIngredients(ItemStackHandler inv) {
        boolean success = true;
        ArrayList<Object> required = this.inputs;
        if (required != null && required.size() > 0) {
            for (Object obj : required) {
                Object stack;
                if (obj instanceof ItemStack) {
                    stack = (ItemStack)obj;
                    if (stack.func_190926_b() || InvUtils.consumeItemsInInventory((IItemHandler)inv, (ItemStack)stack, stack.func_190916_E(), false)) continue;
                    success = false;
                    continue;
                }
                if (!(obj instanceof OreStack) || (stack = (OreStack)obj) == null || InvUtils.consumeOresInInventory((IItemHandlerModifiable)inv, ((OreStack)stack).getItems(), ((OreStack)stack).getStackSize())) continue;
                success = false;
            }
        }
        return success;
    }

    public boolean isEmpty() {
        return this.inputs.isEmpty() || this.getOutputs().isEmpty();
    }

    public String toString() {
        return String.format("%s: %s -> %s,%s", this.getClass().getSimpleName(), this.inputs, this.output, this.secondary);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int compareTo(BulkRecipe other) {
        return this.getPriority() == other.getPriority() ? 0 : (this.getPriority() > other.getPriority() ? -1 : 1);
    }
}

