/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.steelanvil;

import betterwithmods.common.registry.steelanvil.SteelShapedOreRecipe;
import betterwithmods.common.registry.steelanvil.SteelShapedRecipe;
import betterwithmods.common.registry.steelanvil.SteelShapelessRecipe;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class SteelCraftingManager {
    private static final SteelCraftingManager instance = new SteelCraftingManager();
    private List<IRecipe> recipes = new ArrayList<IRecipe>();

    public static SteelCraftingManager getInstance() {
        return instance;
    }

    public List<IRecipe> remove(ItemStack result) {
        ArrayList removal = Lists.newArrayList();
        for (IRecipe recipe : this.recipes) {
            if (!recipe.func_77571_b().func_77969_a(result)) continue;
            removal.add(recipe);
        }
        return removal;
    }

    public SteelShapedRecipe addRecipe(ItemStack result, Object ... recipe) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        int width = 0;
        int height = 0;
        if (recipe[i] instanceof String[]) {
            String[] astring;
            for (String s1 : astring = (String[])recipe[i++]) {
                ++height;
                width = s1.length();
                s.append(s1);
            }
        } else {
            while (recipe[i] instanceof String) {
                String s2 = (String)recipe[i++];
                ++height;
                width = s2.length();
                s.append(s2);
            }
        }
        HashMap<Character, ItemStack> hashmap = new HashMap<Character, ItemStack>();
        while (i < recipe.length) {
            Character character = (Character)recipe[i];
            ItemStack itemstack1 = ItemStack.field_190927_a;
            if (recipe[i + 1] instanceof Item) {
                itemstack1 = new ItemStack((Item)recipe[i + 1]);
            } else if (recipe[i + 1] instanceof Block) {
                itemstack1 = new ItemStack((Block)recipe[i + 1], 1, Short.MAX_VALUE);
            } else if (recipe[i + 1] instanceof ItemStack) {
                itemstack1 = (ItemStack)recipe[i + 1];
            }
            hashmap.put(character, itemstack1);
            i += 2;
        }
        ItemStack[] ingredients = new ItemStack[width * height];
        for (int i1 = 0; i1 < width * height; ++i1) {
            char c0 = s.charAt(i1);
            ingredients[i1] = hashmap.containsKey(Character.valueOf(c0)) ? ((ItemStack)hashmap.get(Character.valueOf(c0))).func_77946_l() : ItemStack.field_190927_a;
        }
        SteelShapedRecipe shapedrecipes = new SteelShapedRecipe(width, height, ingredients, result);
        this.recipes.add(shapedrecipes);
        return shapedrecipes;
    }

    public SteelShapedOreRecipe addSteelShapedOreRecipe(ItemStack result, Object ... recipe) {
        SteelShapedOreRecipe craft = new SteelShapedOreRecipe(result, recipe);
        this.recipes.add(craft);
        return craft;
    }

    public SteelShapelessRecipe addShapelessRecipe(ItemStack result, Object ... ingredients) {
        ArrayList<ItemStack> arraylist = new ArrayList<ItemStack>();
        for (Object object1 : ingredients) {
            if (object1 instanceof ItemStack) {
                arraylist.add(((ItemStack)object1).func_77946_l());
                continue;
            }
            if (object1 instanceof Item) {
                arraylist.add(new ItemStack((Item)object1));
                continue;
            }
            if (!(object1 instanceof Block)) {
                throw new RuntimeException("Invalid shapeless recipy!");
            }
            arraylist.add(new ItemStack((Block)object1));
        }
        SteelShapelessRecipe recipe = new SteelShapelessRecipe(result, arraylist);
        this.recipes.add(recipe);
        return recipe;
    }

    public ShapelessOreRecipe addShapelessOreRecipe(ItemStack result, Object ... ingredients) {
        ShapelessOreRecipe recipe = new ShapelessOreRecipe(result, ingredients);
        this.recipes.add((IRecipe)recipe);
        return recipe;
    }

    public ItemStack findMatchingRecipe(InventoryCrafting matrix, World world) {
        int j;
        int i = 0;
        ItemStack itemstack = ItemStack.field_190927_a;
        ItemStack itemstack1 = ItemStack.field_190927_a;
        for (j = 0; j < matrix.func_70302_i_(); ++j) {
            ItemStack itemstack2 = matrix.func_70301_a(j);
            if (itemstack2.func_190926_b()) continue;
            if (i == 0) {
                itemstack = itemstack2;
            }
            if (i == 1) {
                itemstack1 = itemstack2;
            }
            ++i;
        }
        if (i == 2 && itemstack.func_77973_b() == itemstack1.func_77973_b() && itemstack.func_190916_E() == 1 && itemstack1.func_190916_E() == 1 && itemstack.func_77973_b().isRepairable()) {
            Item item = itemstack.func_77973_b();
            int j1 = item.getMaxDamage(itemstack) - itemstack.func_77952_i();
            int k = item.getMaxDamage(itemstack) - itemstack1.func_77952_i();
            int l = j1 + k + item.getMaxDamage(itemstack) * 5 / 100;
            int i1 = item.getMaxDamage(itemstack) - l;
            if (i1 < 0) {
                i1 = 0;
            }
            return new ItemStack(itemstack.func_77973_b(), 1, i1);
        }
        for (j = 0; j < this.recipes.size(); ++j) {
            IRecipe irecipe = this.recipes.get(j);
            if (!irecipe.func_77569_a(matrix, world)) continue;
            return irecipe.func_77572_b(matrix);
        }
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> getRemainingItems(InventoryCrafting craftMatrix, World worldIn) {
        for (IRecipe irecipe : this.recipes) {
            if (!irecipe.func_77569_a(craftMatrix, worldIn)) continue;
            return irecipe.func_179532_b(craftMatrix);
        }
        NonNullList nonnulllist = NonNullList.func_191197_a((int)craftMatrix.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            nonnulllist.set(i, (Object)craftMatrix.func_70301_a(i));
        }
        return nonnulllist;
    }

    public List<IRecipe> getRecipeList() {
        return this.recipes;
    }
}

