/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.steelanvil;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;

public class SteelShapedOreRecipe
implements IRecipe {
    private static final int MAX_CRAFT_GRID_WIDTH = 4;
    private static final int MAX_CRAFT_GRID_HEIGHT = 4;
    public int width = 0;
    public int height = 0;
    private ItemStack output = ItemStack.field_190927_a;
    private Object[] input = null;
    private boolean mirrored = true;

    public SteelShapedOreRecipe(Block result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public SteelShapedOreRecipe(Item result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public SteelShapedOreRecipe(ItemStack result, Object ... recipe) {
        this.output = result.func_77946_l();
        StringBuilder shape = new StringBuilder();
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            this.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                this.width = s.length();
                shape.append(s);
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape.append(s);
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            StringBuilder ret = new StringBuilder("Invalid shaped ore recipe: ");
            for (Object tmp : recipe) {
                ret.append(tmp).append(", ");
            }
            ret.append(this.output);
            throw new RuntimeException(ret.toString());
        }
        HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            if (in instanceof ItemStack) {
                itemMap.put(chr, ((ItemStack)in).func_77946_l());
            } else if (in instanceof Item) {
                itemMap.put(chr, new ItemStack((Item)in));
            } else if (in instanceof Block) {
                itemMap.put(chr, new ItemStack((Block)in, 1, Short.MAX_VALUE));
            } else if (in instanceof String) {
                itemMap.put(chr, OreDictionary.getOres((String)((String)in)));
            } else {
                StringBuilder ret = new StringBuilder("Invalid shaped ore recipe: ");
                for (Object tmp : recipe) {
                    ret.append(tmp).append(", ");
                }
                ret.append(this.output);
                throw new RuntimeException(ret.toString());
            }
            idx += 2;
        }
        this.input = new Object[this.width * this.height];
        int x = 0;
        for (char chr : shape.toString().toCharArray()) {
            this.input[x++] = itemMap.get(Character.valueOf(chr));
        }
    }

    SteelShapedOreRecipe(ShapedRecipes recipe, Map<ItemStack, String> replacements) {
        this.output = recipe.func_77571_b();
        this.width = recipe.field_77576_b;
        this.height = recipe.field_77577_c;
        this.input = new Object[recipe.field_77574_d.length];
        block0: for (int i = 0; i < this.input.length; ++i) {
            ItemStack ingred = recipe.field_77574_d[i];
            if (ingred.func_190926_b()) continue;
            this.input[i] = recipe.field_77574_d[i];
            for (Map.Entry<ItemStack, String> replace : replacements.entrySet()) {
                if (!OreDictionary.itemMatches((ItemStack)replace.getKey(), (ItemStack)ingred, (boolean)true)) continue;
                this.input[i] = OreDictionary.getOres((String)replace.getValue());
                continue block0;
            }
        }
    }

    public SteelShapedOreRecipe(ItemStack result, Object[] ingredients, int wid, int hei) {
        this.width = wid;
        this.height = hei;
        this.output = result;
        this.input = ingredients;
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    public int func_77570_a() {
        return this.input.length;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            nonnulllist.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return nonnulllist;
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        for (int x = 0; x <= 4 - this.width; ++x) {
            for (int y = 0; y <= 4 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                ItemStack slot = inv.func_70463_b(x, y);
                if (target instanceof ItemStack) {
                    if (OreDictionary.itemMatches((ItemStack)((ItemStack)target), (ItemStack)slot, (boolean)false)) continue;
                    return false;
                }
                if (target instanceof List) {
                    boolean matched = false;
                    Iterator itr = ((List)target).iterator();
                    while (itr.hasNext() && !matched) {
                        matched = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot.func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }

    public SteelShapedOreRecipe setMirrored(boolean mirror) {
        this.mirrored = mirror;
        return this;
    }

    public Object[] getInput() {
        return this.input;
    }

    public String toString() {
        return String.format("%s -> %s", Lists.newArrayList((Object[])this.input), this.output);
    }
}

