/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.world;

import betterwithmods.common.world.gen.village.AbandonedVillagePiece;
import betterwithmods.common.world.gen.village.Well;
import betterwithmods.common.world.gen.village.field.BWFieldBase;
import betterwithmods.module.GlobalConfig;
import betterwithmods.module.hardcore.HCVillages;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class BWMapGenVillage
extends MapGenVillage {
    public static List<StructureVillagePieces.PieceWeight> getPiecesAbandoned(Random random, int size) {
        ArrayList list = Lists.newArrayList();
        VillagerRegistry.addExtraVillageComponents((List)list, (Random)random, (int)size);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (((StructureVillagePieces.PieceWeight)iterator.next()).field_75087_d != 0) continue;
            iterator.remove();
        }
        return list.stream().filter(piece -> AbandonedVillagePiece.class.isAssignableFrom(piece.field_75090_a) || Well.class.isAssignableFrom(piece.field_75090_a)).collect(Collectors.toList());
    }

    public static List<StructureVillagePieces.PieceWeight> getPiecesSemi(Random random, int size) {
        ArrayList list = Lists.newArrayList();
        list.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.House4Garden.class, 4, MathHelper.func_76136_a((Random)random, (int)(2 + size), (int)(4 + size * 2))));
        list.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.Church.class, 20, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(1 + size))));
        list.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.House1.class, 20, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(2 + size))));
        list.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.WoodHut.class, 3, MathHelper.func_76136_a((Random)random, (int)(2 + size), (int)(5 + size * 3))));
        list.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.Hall.class, 15, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(2 + size))));
        list.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.House2.class, 15, MathHelper.func_76136_a((Random)random, (int)0, (int)(1 + size))));
        list.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.House3.class, 8, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(3 + size * 2))));
        VillagerRegistry.addExtraVillageComponents((List)list, (Random)random, (int)size);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (((StructureVillagePieces.PieceWeight)iterator.next()).field_75087_d != 0) continue;
            iterator.remove();
        }
        return list.stream().filter(piece -> BWFieldBase.class.isAssignableFrom(piece.field_75090_a)).collect(Collectors.toList());
    }

    public static List<StructureVillagePieces.PieceWeight> getPiecesNormal(Random random, int size) {
        ArrayList list = Lists.newArrayList();
        list.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.House4Garden.class, 4, MathHelper.func_76136_a((Random)random, (int)(2 + size), (int)(4 + size * 2))));
        list.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.Church.class, 20, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(1 + size))));
        list.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.House1.class, 20, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(2 + size))));
        list.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.WoodHut.class, 3, MathHelper.func_76136_a((Random)random, (int)(2 + size), (int)(5 + size * 3))));
        list.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.Hall.class, 15, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(2 + size))));
        list.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.Field1.class, 3, MathHelper.func_76136_a((Random)random, (int)(1 + size), (int)(4 + size))));
        list.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.Field2.class, 3, MathHelper.func_76136_a((Random)random, (int)(2 + size), (int)(4 + size * 2))));
        list.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.House2.class, 15, MathHelper.func_76136_a((Random)random, (int)0, (int)(1 + size))));
        list.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.House3.class, 8, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(3 + size * 2))));
        VillagerRegistry.addExtraVillageComponents((List)list, (Random)random, (int)size);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (((StructureVillagePieces.PieceWeight)iterator.next()).field_75087_d != 0) continue;
            iterator.remove();
        }
        return list.stream().filter(piece -> !AbandonedVillagePiece.class.isAssignableFrom(piece.field_75090_a) && !Well.class.isAssignableFrom(piece.field_75090_a)).collect(Collectors.toList());
    }

    public int getSize() {
        return (Integer)ObfuscationReflectionHelper.getPrivateValue(MapGenVillage.class, (Object)((Object)this), (int)1);
    }

    protected StructureStart func_75049_b(int x, int z) {
        VillageStatus status = VillageStatus.getStatus(x, z);
        if (!GlobalConfig.debug) {
            // empty if block
        }
        System.out.printf("%s <%s,%s> /tp %s ~ %s\n", status.name().toLowerCase(), x, z, x * 16, z * 16);
        return new AbandonedStart(this.field_75039_c, this.field_75038_b, x, z, this.getSize(), status);
    }

    public static class AbandonedStart
    extends StructureStart {
        private boolean hasMoreThanTwoComponents;
        private VillageStatus status;

        public AbandonedStart() {
        }

        public AbandonedStart(World worldIn, Random rand, int x, int z, int size, VillageStatus status) {
            super(x, z);
            List<StructureVillagePieces.PieceWeight> pieceWeights;
            this.status = status;
            switch (status) {
                case NORMAL: {
                    pieceWeights = BWMapGenVillage.getPiecesNormal(rand, size);
                    break;
                }
                case SEMIABANDONED: {
                    pieceWeights = BWMapGenVillage.getPiecesSemi(rand, size);
                    break;
                }
                default: {
                    pieceWeights = BWMapGenVillage.getPiecesAbandoned(rand, size);
                }
            }
            Well start = new Well(status, worldIn.func_72959_q(), 0, rand, (x << 4) + 2, (z << 4) + 2, pieceWeights, size);
            this.field_75075_a.add(start);
            start.func_74861_a((StructureComponent)start, this.field_75075_a, rand);
            List roads = start.field_74930_j;
            List houses = start.field_74932_i;
            while (!roads.isEmpty()) {
                int j = rand.nextInt(roads.size());
                StructureComponent road = (StructureComponent)roads.remove(j);
                road.func_74861_a((StructureComponent)start, this.field_75075_a, rand);
            }
            while (!houses.isEmpty()) {
                int i = rand.nextInt(houses.size());
                StructureComponent house = (StructureComponent)houses.remove(i);
                if (house instanceof StructureVillagePieces.Torch) continue;
                house.func_74861_a((StructureComponent)start, this.field_75075_a, rand);
            }
            this.func_75072_c();
            int k = 0;
            for (StructureComponent piece : this.field_75075_a) {
                if (piece instanceof StructureVillagePieces.Road) continue;
                ++k;
            }
            this.hasMoreThanTwoComponents = k > 2;
        }

        public boolean func_75069_d() {
            return this.hasMoreThanTwoComponents;
        }

        public void func_143022_a(NBTTagCompound tagCompound) {
            super.func_143022_a(tagCompound);
            tagCompound.func_74757_a("Valid", this.hasMoreThanTwoComponents);
            tagCompound.func_74768_a("Status", this.status.ordinal());
        }

        public void func_143017_b(NBTTagCompound tagCompound) {
            super.func_143017_b(tagCompound);
            this.hasMoreThanTwoComponents = tagCompound.func_74767_n("Valid");
            this.status = VillageStatus.VALUES[tagCompound.func_74762_e("Status")];
        }
    }

    public static enum VillageStatus {
        NORMAL(HCVillages.normalRadius.get() / 16),
        SEMIABANDONED(HCVillages.semiabandonedRadius.get() / 16),
        ABANDONED(0);

        public static final VillageStatus[] VALUES;
        private int radius;

        private VillageStatus(int radius) {
            this.radius = radius;
        }

        public static VillageStatus getStatus(int x, int z) {
            for (VillageStatus status : VALUES) {
                if (!status.inRadius(x, z)) continue;
                return status;
            }
            return NORMAL;
        }

        public boolean inRadius(int x, int z) {
            if (GlobalConfig.debug) {
                System.out.printf("Checking %s @a <%s,%s> r:%s\n", this.name(), x, z, this.radius);
            }
            return Math.abs(x) >= this.radius || Math.abs(z) >= this.radius;
        }

        static {
            VALUES = VillageStatus.values();
        }
    }
}

