/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.event;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWRegistry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PotionEventHandler {
    public static boolean canMobsSpawnHere(World world, BlockPos pos) {
        if (!world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
            return false;
        }
        if (!(world.func_175677_d(pos, false) || world.func_175677_d(pos.func_177984_a(), false) || world.func_180495_p(pos).func_185904_a().func_76224_d())) {
            IBlockState state = world.func_180495_p(pos);
            if (state == Blocks.field_150357_h.func_176223_P()) {
                return false;
            }
            if (world.func_72820_D() < 11615L && world.func_175642_b(EnumSkyBlock.SKY, pos) >= 15) {
                return false;
            }
            int lightLevel = world.func_175642_b(EnumSkyBlock.BLOCK, pos);
            return lightLevel < 8 && (world.func_175623_d(pos) || state.func_185890_d((IBlockAccess)world, pos) == null);
        }
        return false;
    }

    @SubscribeEvent
    public void onRenderFireOverlay(RenderBlockOverlayEvent e) {
        if (e.getOverlayType() == RenderBlockOverlayEvent.OverlayType.FIRE && e.getPlayer().func_130014_f_().func_180495_p(e.getBlockPos()).func_177230_c() == BWMBlocks.STOKED_FLAME) {
            this.renderFireInFirstPerson();
            e.setCanceled(true);
        }
    }

    private void renderFireInFirstPerson() {
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
        GlStateManager.func_179143_c((int)519);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        for (int i = 0; i < 2; ++i) {
            GlStateManager.func_179094_E();
            TextureAtlasSprite textureatlassprite = mc.func_147117_R().getTextureExtry("betterwithmods:blocks/stoked_fire_layer_0");
            if (textureatlassprite == null) {
                textureatlassprite = mc.func_147117_R().func_174944_f();
            }
            mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            float f1 = textureatlassprite.func_94209_e();
            float f2 = textureatlassprite.func_94212_f();
            float f3 = textureatlassprite.func_94206_g();
            float f4 = textureatlassprite.func_94210_h();
            GlStateManager.func_179109_b((float)((float)(-(i * 2 - 1)) * 0.24f), (float)-0.3f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)(i * 2 - 1) * 10.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a((double)f2, (double)f4).func_181675_d();
            vertexbuffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a((double)f1, (double)f4).func_181675_d();
            vertexbuffer.func_181662_b(0.5, 0.5, -0.5).func_187315_a((double)f1, (double)f3).func_181675_d();
            vertexbuffer.func_181662_b(-0.5, 0.5, -0.5).func_187315_a((double)f2, (double)f3).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179143_c((int)515);
    }

    @SubscribeEvent
    public void onPotionUpdate(LivingEvent.LivingUpdateEvent e) {
        if (e.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getEntity();
            World world = player.func_130014_f_();
            if (player.func_70644_a(BWRegistry.POTION_TRUESIGHT) && world.field_72995_K) {
                Minecraft mc = Minecraft.func_71410_x();
                int var3 = mc.field_71474_y.field_74362_aa;
                if (!(mc.func_147113_T() || world.field_73011_w.getDimension() != 0 && world.field_73011_w.getDimension() != 1)) {
                    int var4 = MathHelper.func_76128_c((double)player.field_70165_t);
                    int var5 = MathHelper.func_76128_c((double)player.field_70163_u);
                    int var6 = MathHelper.func_76128_c((double)player.field_70161_v);
                    int radius = 10;
                    for (int x = var4 - radius; x <= var4 + radius; ++x) {
                        for (int y = var5 - radius; y <= var5 + radius; ++y) {
                            for (int z = var6 - radius; z <= var6 + radius; ++z) {
                                if (!PotionEventHandler.canMobsSpawnHere(world, new BlockPos(x, y, z)) || var3 != 0 && world.field_73012_v.nextInt(12) > 2 - var3 << 1) continue;
                                double i = (double)x + world.field_73012_v.nextDouble();
                                double j = (double)y + world.field_73012_v.nextDouble() * 0.25;
                                double k = (double)z + world.field_73012_v.nextDouble();
                                world.func_175688_a(EnumParticleTypes.SPELL_MOB, i, j, k, 0.0, 0.0, 0.0, new int[0]);
                            }
                        }
                    }
                }
            }
        }
    }
}

