/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module;

import betterwithmods.common.items.ItemMaterial;
import betterwithmods.module.CompatFeature;
import betterwithmods.module.Module;
import betterwithmods.module.ModuleLoader;
import betterwithmods.module.gameplay.CrucibleRecipes;
import betterwithmods.module.hardcore.HCDiamond;
import betterwithmods.util.RecipeUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.commons.lang3.tuple.Pair;

public class CompatModule
extends Module {
    private HashMap<String, String> compatRegistry = Maps.newHashMap();
    private HashMap<Pair<LoaderState.ModState, String>, Runnable> quickCompat = Maps.newHashMap();

    public void registerCompatFeature(String modid, String clazz) {
        this.compatRegistry.put(modid, clazz);
    }

    public void registerQuickCompat(String modid, LoaderState.ModState state, Runnable runnable) {
        this.quickCompat.put((Pair<LoaderState.ModState, String>)Pair.of((Object)state, (Object)modid), runnable);
    }

    public void addCompatFeatures() {
        this.registerCompatFeature("biomesoplenty", "betterwithmods.module.compat.bop.BiomesOPlenty");
        this.registerCompatFeature("harvestcraft", "betterwithmods.module.compat.Harvestcraft");
        this.registerCompatFeature("crafttweaker", "betterwithmods.module.compat.minetweaker.MineTweaker");
        this.registerCompatFeature("quark", "betterwithmods.module.compat.Quark");
        this.registerCompatFeature("nethercore", "betterwithmods.module.compat.NetherCore");
        this.registerCompatFeature("actuallyadditions", "betterwithmods.module.compat.ActuallyAdditions");
        this.registerCompatFeature("immersiveengineering", "betterwithmods.module.compat.immersiveengineering.ImmersiveEngineering");
        this.registerCompatFeature("rustic", "betterwithmods.module.compat.Rustic");
        this.registerCompatFeature("tconstruct", "betterwithmods.module.compat.tcon.TConstruct");
        this.registerQuickCompat("chisel", LoaderState.ModState.INITIALIZED, () -> {
            if (ModuleLoader.isFeatureEnabled(HCDiamond.class)) {
                ItemStack chisel_diamond = this.getItem("chisel:chisel_diamond");
                RecipeUtils.removeRecipes(chisel_diamond);
                RecipeUtils.addOreRecipe(chisel_diamond, " D", "S ", Character.valueOf('D'), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.DIAMOND_INGOT), Character.valueOf('S'), "stickWood").setMirrored(true);
                CrucibleRecipes.addCrucibleRecipe(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.DIAMOND_INGOT), new Object[]{this.getItem("chisel:chisel_diamond", 1, Short.MAX_VALUE)});
            }
            CrucibleRecipes.addStokedCrucibleRecipe(new ItemStack(Items.field_151042_j), new Object[]{this.getItem("chisel:chisel_iron", 1, Short.MAX_VALUE)});
            CrucibleRecipes.addStokedCrucibleRecipe(new ItemStack(Items.field_151042_j), new Object[]{this.getItem("chisel:chisel_iron", 1, Short.MAX_VALUE)});
            CrucibleRecipes.addStokedCrucibleRecipe(new ItemStack(Items.field_151043_k), new Object[]{this.getItem("chisel:chisel_hitech", 1, Short.MAX_VALUE)});
        });
    }

    @Override
    public void addFeatures() {
        this.addCompatFeatures();
        this.load();
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        for (Map.Entry<Pair<LoaderState.ModState, String>, Runnable> entry : this.quickCompat.entrySet()) {
            if (!event.getModState().equals(entry.getKey().getKey()) || !this.isLoaded((String)entry.getKey().getValue())) continue;
            entry.getValue().run();
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        for (Map.Entry<Pair<LoaderState.ModState, String>, Runnable> entry : this.quickCompat.entrySet()) {
            if (!event.getModState().equals(entry.getKey().getKey()) || !this.isLoaded((String)entry.getKey().getValue())) continue;
            entry.getValue().run();
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        for (Map.Entry<Pair<LoaderState.ModState, String>, Runnable> entry : this.quickCompat.entrySet()) {
            if (!event.getModState().equals(entry.getKey().getKey()) || !this.isLoaded((String)entry.getKey().getValue())) continue;
            entry.getValue().run();
        }
    }

    public void load() {
        for (Map.Entry<String, String> feature : this.compatRegistry.entrySet()) {
            String modId = feature.getKey();
            String classPath = feature.getValue();
            if (!this.isLoaded(modId)) continue;
            try {
                this.registerFeature(Class.forName(classPath).asSubclass(CompatFeature.class).newInstance());
                FMLLog.info((String)(" [BWM] Successfully load compat for " + modId), (Object[])new Object[0]);
            }
            catch (ClassNotFoundException | ExceptionInInitializerError | IllegalAccessException | InstantiationException ignore) {
                FMLLog.info((String)(" [BWM] Compatibility class " + classPath + " could not be loaded. Report this!"), (Object[])new Object[0]);
            }
        }
    }

    private boolean isLoaded(String modId) {
        boolean loaded = Loader.isModLoaded((String)modId) && this.loadPropBool(modId.toLowerCase() + "_compat", "compatibility for ", true);
        return loaded;
    }

    public ItemStack getItem(String location) {
        return this.getItem(new ResourceLocation(location), 1, 0);
    }

    public ItemStack getItem(ResourceLocation location, int count, int meta) {
        return new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)location), count, meta);
    }

    public ItemStack getItem(String location, int count, int meta) {
        return this.getItem(new ResourceLocation(location), count, meta);
    }

    public ItemStack getBlock(ResourceLocation location, int count, int meta) {
        return new ItemStack((Block)Block.field_149771_c.func_82594_a((Object)location), count, meta);
    }

    public ItemStack getBlock(String location, int count, int meta) {
        return this.getBlock(new ResourceLocation(location), count, meta);
    }

    public ItemStack getBlock(String location) {
        return this.getBlock(new ResourceLocation(location), 1, 0);
    }
}

