/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module;

import betterwithmods.api.FeatureEnabledEvent;
import betterwithmods.module.ConfigHelper;
import betterwithmods.module.Feature;
import betterwithmods.module.ModuleLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Module {
    public final String name = this.makeName();
    public final Map<String, Feature> features = new HashMap<String, Feature>();
    public final List<Feature> enabledFeatures = new ArrayList<Feature>();
    public final List<Feature> disabledFeatures = new ArrayList<Feature>();
    public boolean enabled;
    protected int priority = 0;

    public void addFeatures() {
    }

    public void registerFeature(Feature feature) {
        this.registerFeature(feature, this.convertName(feature.getClass().getSimpleName()));
    }

    public void registerFeature(Feature feature, boolean enabledByDefault) {
        this.registerFeature(feature, this.convertName(feature.getClass().getSimpleName()), enabledByDefault);
    }

    public String convertName(String origName) {
        return origName;
    }

    public void registerFeature(Feature feature, String name) {
        this.registerFeature(feature, name, true);
    }

    public void registerFeature(Feature feature, String name, boolean enabledByDefault) {
        ModuleLoader.featureInstances.put(feature.getClass(), feature);
        this.features.put(name, feature);
        feature.enabledByDefault = enabledByDefault;
        feature.prevEnabled = false;
        feature.module = this;
        feature.configName = name;
        feature.configCategory = this.name + "." + name;
    }

    public void setupConfig() {
        if (this.features.isEmpty()) {
            this.addFeatures();
        }
        this.forEachFeature(feature -> {
            String[] incompatibilities;
            ConfigHelper.needsRestart = feature.requiresMinecraftRestartToEnable();
            if (feature.canDisable) {
                feature.enabled = this.loadPropBool(feature.configName, feature.getFeatureDescription(), feature.enabledByDefault) && this.enabled;
                feature.setupConstantConfig();
            } else {
                feature.enabled = true;
                feature.forceLoad = true;
            }
            if (!feature.forceLoad && (incompatibilities = feature.getIncompatibleMods()) != null) {
                ArrayList<String> failiures = new ArrayList<String>();
                for (String s : incompatibilities) {
                    if (!Loader.isModLoaded((String)s)) continue;
                    feature.enabled = false;
                    failiures.add(s);
                }
                if (!failiures.isEmpty()) {
                    FMLLog.info((String)("[BWM] '" + feature.configName + "' is forcefully disabled as it's incompatible with the following loaded mods: " + failiures), (Object[])new Object[0]);
                }
            }
            if (!feature.loadtimeDone) {
                feature.enabledAtLoadtime = feature.enabled;
                feature.loadtimeDone = true;
            }
            if (feature.enabled && !this.enabledFeatures.contains(feature)) {
                this.enabledFeatures.add((Feature)feature);
            } else if (!feature.enabled && this.enabledFeatures.contains(feature)) {
                this.enabledFeatures.remove(feature);
            }
            if (!feature.enabled) {
                this.disabledFeatures.add((Feature)feature);
            }
            feature.setupConfig();
            if (!feature.enabled && feature.prevEnabled) {
                if (feature.hasSubscriptions()) {
                    MinecraftForge.EVENT_BUS.unregister(feature);
                }
                if (feature.hasTerrainSubscriptions()) {
                    MinecraftForge.TERRAIN_GEN_BUS.unregister(feature);
                }
                if (feature.hasOreGenSubscriptions()) {
                    MinecraftForge.ORE_GEN_BUS.unregister(feature);
                }
            } else if (feature.enabled && (feature.enabledAtLoadtime || !feature.requiresMinecraftRestartToEnable()) && !feature.prevEnabled) {
                if (feature.hasSubscriptions()) {
                    MinecraftForge.EVENT_BUS.register(feature);
                }
                if (feature.hasTerrainSubscriptions()) {
                    MinecraftForge.TERRAIN_GEN_BUS.register(feature);
                }
                if (feature.hasOreGenSubscriptions()) {
                    MinecraftForge.ORE_GEN_BUS.register(feature);
                }
            }
            feature.prevEnabled = feature.enabled;
        });
    }

    public void preInit(FMLPreInitializationEvent event) {
        this.forEachEnabled(feature -> {
            FMLLog.info((String)("[BWM] Feature PreInit : " + feature.configName), (Object[])new Object[0]);
            feature.preInit(event);
        });
        this.forEachDisabled(feature -> feature.disabledPreInit(event));
    }

    public void init(FMLInitializationEvent event) {
        this.forEachEnabled(feature -> feature.init(event));
        this.forEachDisabled(feature -> feature.disabledInit(event));
    }

    public void postInit(FMLPostInitializationEvent event) {
        this.forEachEnabled(feature -> {
            feature.postInit(event);
            MinecraftForge.EVENT_BUS.post((Event)new FeatureEnabledEvent(this.name.toLowerCase(), feature.configName.toLowerCase(), feature.enabled));
        });
        this.forEachDisabled(feature -> feature.disabledPostInit(event));
    }

    public void finalInit(FMLPostInitializationEvent event) {
        this.forEachEnabled(feature -> feature.finalInit(event));
    }

    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        this.forEachEnabled(feature -> feature.preInitClient(event));
    }

    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        this.forEachEnabled(feature -> feature.initClient(event));
    }

    @SideOnly(value=Side.CLIENT)
    public void postInitClient(FMLPostInitializationEvent event) {
        this.forEachEnabled(feature -> feature.postInitClient(event));
    }

    public void serverStarting(FMLServerStartingEvent event) {
        this.forEachEnabled(feature -> feature.serverStarting(event));
    }

    public boolean canBeDisabled() {
        return true;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    String makeName() {
        return this.getClass().getSimpleName().toLowerCase();
    }

    public String getModuleDescription() {
        return "";
    }

    public final void forEachFeature(Consumer<Feature> consumer) {
        this.features.values().forEach(consumer);
    }

    public final void forEachEnabled(Consumer<Feature> consumer) {
        this.enabledFeatures.forEach(consumer);
    }

    public final void forEachDisabled(Consumer<Feature> consumer) {
        this.disabledFeatures.forEach(consumer);
    }

    public final int loadPropInt(String propName, String desc, int default_) {
        return ConfigHelper.loadPropInt(propName, this.name, desc, default_);
    }

    public final double loadPropDouble(String propName, String desc, double default_, double min, double max) {
        return ConfigHelper.loadPropDouble(propName, this.name, desc, default_, min, max);
    }

    public final double loadPropDouble(String propName, String desc, double default_) {
        return ConfigHelper.loadPropDouble(propName, this.name, desc, default_);
    }

    public final boolean loadPropBool(String propName, String desc, boolean default_) {
        return ConfigHelper.loadPropBool(propName, this.name, desc, default_);
    }

    public final String loadPropString(String propName, String desc, String default_) {
        return ConfigHelper.loadPropString(propName, this.name, desc, default_);
    }

    public int getPriority() {
        return this.priority;
    }
}

