/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.compat;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.blocks.mini.BlockCorner;
import betterwithmods.common.blocks.mini.BlockMini;
import betterwithmods.common.blocks.mini.BlockMoulding;
import betterwithmods.common.blocks.mini.BlockSiding;
import betterwithmods.common.blocks.mini.ItemBlockMini;
import betterwithmods.common.items.ItemBark;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.module.CompatFeature;
import betterwithmods.module.ModuleLoader;
import betterwithmods.module.gameplay.AnvilRecipes;
import betterwithmods.module.gameplay.SawRecipes;
import betterwithmods.module.hardcore.HCSaw;
import betterwithmods.module.tweaks.HighEfficiencyRecipes;
import betterwithmods.util.RecipeUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class Rustic
extends CompatFeature {
    public static final Block SIDING = (Block)new BlockSiding(Material.field_151576_e){

        @Override
        public int getUsedTypes() {
            return 3;
        }

        public Material func_149688_o(IBlockState state) {
            int type = (Integer)state.func_177229_b((IProperty)BlockMini.TYPE);
            return type < 2 ? BlockMini.MINI : Material.field_151576_e;
        }
    }.setRegistryName("rustic_compat_siding");
    public static final Block MOULDING = (Block)new BlockMoulding(Material.field_151576_e){

        @Override
        public int getUsedTypes() {
            return 3;
        }

        public Material func_149688_o(IBlockState state) {
            int type = (Integer)state.func_177229_b((IProperty)BlockMini.TYPE);
            return type < 2 ? BlockMini.MINI : Material.field_151576_e;
        }
    }.setRegistryName("rustic_compat_moulding");
    public static final Block CORNER = (Block)new BlockCorner(Material.field_151576_e){

        @Override
        public int getUsedTypes() {
            return 3;
        }

        public Material func_149688_o(IBlockState state) {
            int type = (Integer)state.func_177229_b((IProperty)BlockMini.TYPE);
            return type < 2 ? BlockMini.MINI : Material.field_151576_e;
        }
    }.setRegistryName("rustic_compat_corner");
    public String[] woods = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "big_oak", "olive", "ironwood"};

    public Rustic() {
        super("rustic");
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        BWMBlocks.registerBlock(SIDING, (Item)new ItemBlockMini(SIDING));
        BWMBlocks.registerBlock(MOULDING, (Item)new ItemBlockMini(MOULDING));
        BWMBlocks.registerBlock(CORNER, (Item)new ItemBlockMini(CORNER));
        ItemBark.barks.add("olive");
        ItemBark.barks.add("ironwood");
    }

    @Override
    public void preInitClient(FMLPreInitializationEvent event) {
        BWMBlocks.setInventoryModel(SIDING);
        BWMBlocks.setInventoryModel(MOULDING);
        BWMBlocks.setInventoryModel(CORNER);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        Block log = this.getBlock("rustic:log");
        Block planks = this.getBlock("rustic:planks");
        BWOreDictionary.registerWood(new ItemStack(log), new ItemStack(planks, 1, 0), ItemBark.getStack("olive", 1));
        BWOreDictionary.registerWood(new ItemStack(log, 1, 1), new ItemStack(planks, 1, 1), ItemBark.getStack("ironwood", 1));
        ItemStack rope = new ItemStack(this.getBlock(new ResourceLocation("rustic", "rope")));
        RecipeUtils.removeRecipes(rope);
        RecipeUtils.addOreRecipe(rope, "F", "F", "F", Character.valueOf('F'), "fiberHemp");
        RecipeUtils.addOreRecipe(new ItemStack(this.getBlock(new ResourceLocation("rustic", "candle")), 6), "S", "T", "I", Character.valueOf('S'), "string", Character.valueOf('T'), "tallow", Character.valueOf('I'), "ingotIron");
        for (int i = 0; i < 2; ++i) {
            SawRecipes.addSawRecipe(log, i, new ItemStack(planks, 4, i), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SAWDUST, 2), ItemBark.getStack(this.woods[i + 6], 1));
            SawRecipes.addSawRecipe(planks, i, new ItemStack(SIDING, 2, i));
            SawRecipes.addSawRecipe(SIDING, i, new ItemStack(MOULDING, 2, i));
            SawRecipes.addSawRecipe(MOULDING, i, new ItemStack(CORNER, 2, i));
            SawRecipes.addSawRecipe(CORNER, i, ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GEAR, 2));
            RecipeUtils.addOreRecipe(new ItemStack(planks, 1, i), "MM", Character.valueOf('M'), new ItemStack(SIDING, 1, i));
            RecipeUtils.addOreRecipe(new ItemStack(SIDING, 1, i), "MM", Character.valueOf('M'), new ItemStack(MOULDING, 1, i));
            RecipeUtils.addOreRecipe(new ItemStack(MOULDING, 1, i), "MM", Character.valueOf('M'), new ItemStack(CORNER, 1, i));
        }
        boolean isHCSawEnabled = ModuleLoader.isFeatureEnabled(HCSaw.class);
        Block wooden_stake = this.getBlock("rustic:crop_stake");
        if (isHCSawEnabled) {
            RecipeUtils.removeRecipes(wooden_stake);
        }
        RecipeUtils.addOreRecipe(new ItemStack(wooden_stake, 3), "M", "M", "M", Character.valueOf('M'), "mouldingWood");
        if (ModuleLoader.isFeatureEnabled(HighEfficiencyRecipes.class)) {
            for (int i = 0; i < this.woods.length; ++i) {
                ItemStack moulding = i >= 6 ? new ItemStack(MOULDING, 1, i - 6) : new ItemStack(BWMBlocks.WOOD_MOULDING, 1, i);
                ItemStack siding = i >= 6 ? new ItemStack(SIDING, 1, i - 6) : new ItemStack(BWMBlocks.WOOD_SIDING, 1, i);
                ItemStack chair = new ItemStack(this.getBlock("rustic:chair_" + this.woods[i]), 4);
                ItemStack table = new ItemStack(this.getBlock("rustic:table_" + this.woods[i]), 2);
                if (isHCSawEnabled) {
                    RecipeUtils.removeRecipes(chair);
                    RecipeUtils.removeRecipes(table);
                }
                RecipeUtils.addOreRecipe(chair, "S  ", "SSS", "M M", Character.valueOf('S'), siding, Character.valueOf('M'), moulding);
                RecipeUtils.addOreRecipe(table, "SSS", "M M", Character.valueOf('S'), siding, Character.valueOf('M'), moulding);
                if (i < 6) continue;
                ItemStack fencegate = new ItemStack(this.getBlock("rustic:fence_gate_" + this.woods[i]));
                ItemStack fence = new ItemStack(this.getBlock("rustic:fence_" + this.woods[i]), 3);
                if (isHCSawEnabled) {
                    RecipeUtils.removeRecipes(fencegate);
                    RecipeUtils.removeRecipes(fence);
                }
                RecipeUtils.addOreRecipe(fencegate, "MSM", Character.valueOf('S'), siding, Character.valueOf('M'), moulding);
                RecipeUtils.addOreRecipe(fence, "MMM", Character.valueOf('M'), moulding);
            }
        }
        AnvilRecipes.addSteelShapedRecipe(new ItemStack(SIDING, 8, 2), "SSSS", Character.valueOf('S'), this.getBlock("rustic:slate"));
        AnvilRecipes.addSteelShapedRecipe(new ItemStack(MOULDING, 8, 2), "SSSS", Character.valueOf('S'), new ItemStack(SIDING, 1, 2));
        AnvilRecipes.addSteelShapedRecipe(new ItemStack(CORNER, 8, 2), "SSSS", Character.valueOf('S'), new ItemStack(MOULDING, 1, 2));
        BWOreDictionary.registerOre("sidingWood", new ItemStack(SIDING, 1, 0), new ItemStack(SIDING, 1, 1));
        BWOreDictionary.registerOre("mouldingWood", new ItemStack(MOULDING, 1, 0), new ItemStack(MOULDING, 1, 1));
        BWOreDictionary.registerOre("cornerWood", new ItemStack(CORNER, 1, 0), new ItemStack(CORNER, 1, 1));
    }
}

