/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.compat.immersiveengineering;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.blocks.mini.BlockCorner;
import betterwithmods.common.blocks.mini.BlockMoulding;
import betterwithmods.common.blocks.mini.BlockSiding;
import betterwithmods.common.blocks.mini.ItemBlockMini;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.module.CompatFeature;
import betterwithmods.module.ModuleLoader;
import betterwithmods.module.compat.immersiveengineering.BlockImmersiveAxle;
import betterwithmods.module.compat.immersiveengineering.TileEntityImmersiveAxle;
import betterwithmods.module.gameplay.SawRecipes;
import betterwithmods.module.hardcore.HCSaw;
import betterwithmods.module.tweaks.HighEfficiencyRecipes;
import betterwithmods.util.RecipeUtils;
import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.api.energy.ThermoelectricHandler;
import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.IERecipes;
import blusunrize.immersiveengineering.common.blocks.plant.BlockIECrop;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ImmersiveEngineering
extends CompatFeature {
    public static final Block TREATED_AXLE = (Block)new BlockImmersiveAxle().setRegistryName("immersive_axle");
    public static boolean overrideIndustrialHempDrops;
    public static Block SIDING;
    public static Block MOULDING;
    public static Block CORNER;
    BelljarHandler.DefaultPlantHandler bwmHempHandler = new BelljarHandler.DefaultPlantHandler(){
        private HashSet<ComparableItemStack> validSeeds = new HashSet();

        protected HashSet<ComparableItemStack> getSeedSet() {
            return this.validSeeds;
        }

        @SideOnly(value=Side.CLIENT)
        public IBlockState[] getRenderedPlant(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
            int age = Math.min(7, Math.round(growth * 7.0f));
            if (age > 6) {
                return new IBlockState[]{BWMBlocks.HEMP.func_176203_a(age), BWMBlocks.HEMP.func_176203_a(8)};
            }
            return new IBlockState[]{BWMBlocks.HEMP.func_176203_a(age)};
        }

        @SideOnly(value=Side.CLIENT)
        public float getRenderSize(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
            return 0.7875f;
        }
    };

    public ImmersiveEngineering() {
        super("immersiveengineering");
    }

    @Override
    public void setupConfig() {
        overrideIndustrialHempDrops = this.loadPropBool("Override Industrial Hemp Drops", "Replaces Hemp Fiber with BWM Hemp, making it require a Millstone", true);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        BWMBlocks.registerBlock(SIDING, (Item)new ItemBlockMini(SIDING));
        BWMBlocks.registerBlock(MOULDING, (Item)new ItemBlockMini(MOULDING));
        BWMBlocks.registerBlock(CORNER, (Item)new ItemBlockMini(CORNER));
        BWMBlocks.registerBlock(TREATED_AXLE);
        GameRegistry.registerTileEntity(TileEntityImmersiveAxle.class, (String)"bwm.immersive_axle");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        BWMBlocks.setInventoryModel(SIDING);
        BWMBlocks.setInventoryModel(MOULDING);
        BWMBlocks.setInventoryModel(CORNER);
        BWMBlocks.setInventoryModel(TREATED_AXLE);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        BelljarHandler.DefaultPlantHandler ieHempHandler;
        ItemStack conveyorStack = ConveyorHandler.getConveyorStack((String)"immersiveengineering:conveyor");
        IERecipes.addOredictRecipe((ItemStack)Utils.copyStackWithAmount((ItemStack)conveyorStack, (int)8), (Object[])new Object[]{"LLL", "IRI", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone", Character.valueOf('L'), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.LEATHER_CUT)});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TREATED_AXLE), new Object[]{"W", "R", "W", Character.valueOf('W'), "plankTreatedWood", Character.valueOf('R'), BWMBlocks.ROPE}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TREATED_AXLE), new Object[]{"W", "R", "W", Character.valueOf('W'), "mouldingTreatedWood", Character.valueOf('R'), BWMBlocks.ROPE}));
        Fluid seedOil = FluidRegistry.getFluid((String)"plantoil");
        SqueezerRecipe.addRecipe((FluidStack)new FluidStack(seedOil, 120), null, (Object)new ItemStack(BWMBlocks.HEMP, 1, 0), (int)6400);
        BelljarHandler.registerHandler((BelljarHandler.IPlantHandler)this.bwmHempHandler);
        this.bwmHempHandler.register(new ItemStack(BWMBlocks.HEMP), new ItemStack[]{ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HEMP), new ItemStack(BWMBlocks.HEMP)}, (Object)new ItemStack(Blocks.field_150346_d), new IBlockState[]{BWMBlocks.HEMP.func_176223_P()});
        if (overrideIndustrialHempDrops && (ieHempHandler = (BelljarHandler.DefaultPlantHandler)BelljarHandler.getHandler((ItemStack)new ItemStack((Item)IEContent.itemSeeds))) != null) {
            ieHempHandler.register(new ItemStack((Item)IEContent.itemSeeds), new ItemStack[]{ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HEMP), new ItemStack((Item)IEContent.itemSeeds)}, (Object)new ItemStack(Blocks.field_150346_d), new IBlockState[]{IEContent.blockCrop.func_176223_P()});
        }
        ThermoelectricHandler.registerSourceInKelvin((String)"blockHellfire", (int)4000);
        Block treated_wood = this.getBlock(this.modid + ":treated_wood");
        Block treated_slab = this.getBlock(this.modid + ":treated_wood_slab");
        Item material = this.getItem(this.modid + ":material");
        for (int i = 0; i < 3; ++i) {
            SawRecipes.addSawRecipe(treated_wood, i, new ItemStack(SIDING, 2, i));
            SawRecipes.addSawRecipe(SIDING, i, new ItemStack(MOULDING, 2, i));
            SawRecipes.addSawRecipe(MOULDING, i, new ItemStack(CORNER, 2, i));
            SawRecipes.addSawRecipe(CORNER, i, ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GEAR, 2));
            SawRecipes.addSawRecipe(treated_slab, i, new ItemStack(MOULDING, 2, i));
            GameRegistry.addRecipe((ItemStack)new ItemStack(treated_wood, 1, i), (Object[])new Object[]{"MM", Character.valueOf('M'), new ItemStack(SIDING, 1, i)});
            GameRegistry.addRecipe((ItemStack)new ItemStack(SIDING, 1, i), (Object[])new Object[]{"MM", Character.valueOf('M'), new ItemStack(MOULDING, 1, i)});
            GameRegistry.addRecipe((ItemStack)new ItemStack(MOULDING, 1, i), (Object[])new Object[]{"MM", Character.valueOf('M'), new ItemStack(CORNER, 1, i)});
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(this.getBlock(this.modid + ":treated_wood_stairs" + i), 1), new Object[]{"M ", "MM", Character.valueOf('M'), new ItemStack(MOULDING, 1, i)}).setMirrored(true));
        }
        BWOreDictionary.registerOre("sidingTreatedWood", new ItemStack(SIDING, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("slabTreatedWood", new ItemStack(SIDING, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("mouldingTreatedWood", new ItemStack(MOULDING, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("cornerTreatedWood", new ItemStack(CORNER, 1, Short.MAX_VALUE));
        if (ModuleLoader.isFeatureEnabled(HighEfficiencyRecipes.class)) {
            Block wood_dec = this.getBlock("immersiveengineering:wooden_decoration");
            if (ModuleLoader.isFeatureEnabled(HCSaw.class)) {
                RecipeUtils.removeRecipes(wood_dec);
            }
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(wood_dec, 3, 0), new Object[]{"MMM", Character.valueOf('M'), "mouldingTreatedWood"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(wood_dec, 6, 1), new Object[]{"SSS", " M ", "M M", Character.valueOf('M'), "mouldingTreatedWood", Character.valueOf('S'), "sidingTreatedWood"}).setMirrored(true));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(material, 1, 0), new Object[]{"mouldingTreatedWood"}));
        }
    }

    @SubscribeEvent
    public void overrideHempDrops(BlockEvent.HarvestDropsEvent e) {
        if (!overrideIndustrialHempDrops) {
            return;
        }
        IBlockState state = e.getState();
        if (state.func_177230_c() instanceof BlockIECrop) {
            e.getDrops().clear();
            int meta = state.func_177230_c().func_176201_c(state);
            if (meta >= 4) {
                e.getDrops().add(new ItemStack((Item)IEContent.itemSeeds));
                e.getDrops().add(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HEMP));
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    static {
        SIDING = (Block)new BlockSiding(Material.field_151575_d){

            @Override
            public int getUsedTypes() {
                return 3;
            }
        }.setRegistryName("ie_siding");
        MOULDING = (Block)new BlockMoulding(Material.field_151575_d){

            @Override
            public int getUsedTypes() {
                return 3;
            }
        }.setRegistryName("ie_moulding");
        CORNER = (Block)new BlockCorner(Material.field_151575_d){

            @Override
            public int getUsedTypes() {
                return 3;
            }
        }.setRegistryName("ie_corner");
    }
}

