/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.compat.minetweaker;

import betterwithmods.common.registry.KilnStructureManager;
import betterwithmods.common.registry.blockmeta.managers.KilnManager;
import betterwithmods.common.registry.blockmeta.recipe.KilnRecipe;
import betterwithmods.module.compat.minetweaker.BMAdd;
import betterwithmods.module.compat.minetweaker.BMRemove;
import betterwithmods.util.RecipeUtils;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.utils.BaseUndoable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.NotNull;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.betterwithmods.Kiln")
public class Kiln {
    public static final String clazz = "mods.betterwithmods.Kiln";

    @ZenMethod
    public static void add(IItemStack[] output, @NotNull IIngredient input) {
        List stacks = input.getItems().stream().map(InputHelper::toStack).collect(Collectors.toList());
        MineTweakerAPI.logInfo((String)String.valueOf(stacks));
        ArrayList<KilnRecipe> recipes = new ArrayList<KilnRecipe>();
        for (ItemStack stack : stacks) {
            if (!InputHelper.isABlock((ItemStack)stack)) {
                MineTweakerAPI.getLogger().logWarning(stack.func_82833_r() + " is not a Block, will not be registered");
                return;
            }
            Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            MineTweakerAPI.logInfo((String)block.func_149739_a());
            ItemStack[] outputs = InputHelper.toStacks((IItemStack[])output);
            if (output == null) {
                MineTweakerAPI.getLogger().logError("Could not add mods.betterwithmods.Kiln recipe for " + stack.func_82833_r() + ", outputs were null");
            }
            KilnRecipe r = new KilnRecipe(block, stack.func_77960_j(), Arrays.asList(outputs));
            recipes.add(r);
        }
        MineTweakerAPI.apply(new BMAdd<KilnRecipe>("bwm.kiln", KilnManager.INSTANCE, recipes));
    }

    @ZenMethod
    public static void remove(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new BMRemove("bwm.kiln", KilnManager.INSTANCE, InputHelper.toStack((IItemStack)output)));
    }

    @ZenMethod
    public static void registerBlock(IItemStack block) {
        MineTweakerAPI.apply((IUndoableAction)new KilnBlock(RecipeUtils.getStateFromStack(InputHelper.toStack((IItemStack)block))));
    }

    public static class KilnBlock
    extends BaseUndoable {
        private IBlockState state;

        protected KilnBlock(IBlockState state) {
            super("kiln_block");
            this.state = state;
        }

        public void apply() {
            KilnStructureManager.registerKilnBlock(this.state);
        }

        public void undo() {
            KilnStructureManager.removeKilnBlock(this.state);
        }
    }
}

