/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.blocks.BlockBWMPane;
import betterwithmods.common.blocks.BlockRope;
import betterwithmods.common.blocks.tile.SimpleStackHandler;
import betterwithmods.common.blocks.tile.TileEntityFilteredHopper;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.common.registry.HopperFilters;
import betterwithmods.common.registry.HopperInteractions;
import betterwithmods.module.Feature;
import betterwithmods.util.InvUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockTorch;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class HopperRecipes
extends Feature {
    public HopperRecipes() {
        this.canDisable = false;
    }

    @Override
    public void init(FMLInitializationEvent event) {
        HopperFilters.addFilter(1, Blocks.field_150468_ap, 0, HopperRecipes::isItem);
        HopperFilters.addFilter(2, Blocks.field_150415_aT, 0, stack -> !HopperRecipes.isItem(stack));
        HopperFilters.addFilter(4, BWMBlocks.SLATS, Short.MAX_VALUE, HopperRecipes::isFlat);
        HopperFilters.addFilter(5, new ItemStack(BWMBlocks.PANE, 1, BlockBWMPane.EnumPaneType.WICKER.getMeta()), HopperRecipes::isDust);
        HopperFilters.addFilter(3, BWMBlocks.GRATE, Short.MAX_VALUE, stack -> stack.func_77976_d() == 1);
        HopperFilters.addFilter(7, Blocks.field_150411_aY, 0, stack -> stack.func_77976_d() > 1);
        HopperFilters.addFilter(6, Blocks.field_150425_aM, 0, stack -> stack.func_77969_a(new ItemStack(Blocks.field_150425_aM)));
        HopperInteractions.addHopperRecipe(new HopperInteractions.SoulUrnRecipe(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GROUND_NETHERRACK), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HELLFIRE_DUST)));
        HopperInteractions.addHopperRecipe(new HopperInteractions.SoulUrnRecipe(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SOUL_DUST), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SAWDUST)));
        HopperInteractions.addHopperRecipe(new HopperInteractions.HopperRecipe(5, new ItemStack(Blocks.field_150351_n), new ItemStack(Items.field_151145_ak), new ItemStack[]{new ItemStack((Block)Blocks.field_150354_m), new ItemStack((Block)Blocks.field_150354_m, 1, 1)}){

            @Override
            public void craft(EntityItem inputStack, World world, BlockPos pos) {
                InvUtils.ejectStackWithOffset(world, inputStack.func_180425_c(), this.output.func_77946_l());
                TileEntityFilteredHopper tile = (TileEntityFilteredHopper)world.func_175625_s(pos);
                SimpleStackHandler inventory = tile.inventory;
                ItemStack sand = ((ItemStack)this.secondaryOutput.get(world.field_73012_v.nextInt(this.secondaryOutput.size()))).func_77946_l();
                if (!InvUtils.insert((IItemHandler)inventory, sand, false).func_190926_b()) {
                    InvUtils.ejectStackWithOffset(world, inputStack.func_180425_c(), sand);
                }
                this.onCraft(world, pos, inputStack);
            }
        });
        HopperInteractions.addHopperRecipe(new HopperInteractions.HopperRecipe(6, new ItemStack((Block)Blocks.field_150354_m, 1, Short.MAX_VALUE), ItemStack.field_190927_a, new ItemStack[0]){

            @Override
            public boolean canCraft(World world, BlockPos pos) {
                TileEntityFilteredHopper hopper = (TileEntityFilteredHopper)world.func_175625_s(pos);
                return super.canCraft(world, pos) && hopper.soulsRetained > 0;
            }

            @Override
            public ItemStack getOutput() {
                return new ItemStack(Blocks.field_150425_aM);
            }

            @Override
            public void craft(EntityItem inputStack, World world, BlockPos pos) {
                this.onCraft(world, pos, inputStack);
            }

            @Override
            public void onCraft(World world, BlockPos pos, EntityItem item) {
                TileEntityFilteredHopper hopper = (TileEntityFilteredHopper)world.func_175625_s(pos);
                int stackSize = hopper.soulsRetained;
                if (stackSize > item.func_92059_d().func_190916_E()) {
                    stackSize = item.func_92059_d().func_190916_E();
                }
                hopper.soulsRetained -= stackSize;
                item.func_92059_d().func_190918_g(stackSize);
                EntityItem soul = new EntityItem(world, item.field_70142_S, item.field_70137_T, item.field_70136_U, new ItemStack(Blocks.field_150425_aM, stackSize));
                if (!InvUtils.insert((IItemHandler)hopper.inventory, soul.func_92059_d(), false).func_190926_b()) {
                    soul.func_174869_p();
                    world.func_72838_d((Entity)soul);
                }
                if (item.func_92059_d().func_190916_E() < 1) {
                    item.func_70106_y();
                }
            }
        });
    }

    private static boolean isItem(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            Block block = ((ItemBlock)item).func_179223_d();
            return block instanceof BlockRope || block instanceof BlockBush || block instanceof BlockTorch || block instanceof BlockSand || block instanceof BlockGravel || BWOreDictionary.isOre(stack, "treeSapling");
        }
        return true;
    }

    private static boolean isDust(ItemStack stack) {
        return BWOreDictionary.listContains(stack, (List<ItemStack>)OreDictionary.getOres((String)"sand")) || BWOreDictionary.listContains(stack, (List<ItemStack>)OreDictionary.getOres((String)"listAllseeds")) || BWOreDictionary.listContains(stack, (List<ItemStack>)OreDictionary.getOres((String)"foodFlour")) || BWOreDictionary.listContains(stack, BWOreDictionary.dustNames) || BWOreDictionary.listContains(stack, (List<ItemStack>)OreDictionary.getOres((String)"pile"));
    }

    private static boolean isFlat(ItemStack stack) {
        Item item = stack.func_77973_b();
        int meta = stack.func_77960_j();
        if (item == BWMItems.MATERIAL) {
            return meta == 1 || meta == 4 || meta > 5 && meta < 10 || meta > 31 && meta < 35;
        }
        return item == Item.func_150898_a((Block)Blocks.field_150325_L) || item == Item.func_150898_a((Block)Blocks.field_150404_cg) || item == Items.field_151116_aA || item == Items.field_151148_bJ || item == Items.field_151098_aY || BWOreDictionary.listContains(stack, (List<ItemStack>)OreDictionary.getOres((String)"string")) || BWOreDictionary.listContains(stack, (List<ItemStack>)OreDictionary.getOres((String)"paper"));
    }
}

