/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay;

import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.registry.OreStack;
import betterwithmods.module.Feature;
import betterwithmods.module.gameplay.CrucibleRecipes;
import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;

public class NuggetCompression
extends Feature {
    @Override
    public String getFeatureDescription() {
        return "Adds recipes to the Crucible to compact 9 Nuggets into it's corresponding Ingot.";
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        HashSet exclude = Sets.newHashSet((Object[])new String[]{"diamond", "soulforgedsteel"});
        for (ItemStack ingot : BWOreDictionary.ingotNames) {
            OreStack nugget;
            String suffix = BWOreDictionary.getSuffix(ingot, "ingot");
            if (suffix == null || exclude.contains(suffix.toLowerCase()) || (nugget = new OreStack("nugget" + suffix, 9)).isEmpty()) continue;
            CrucibleRecipes.addStokedCrucibleRecipe(ingot, new Object[]{nugget});
        }
    }
}

