/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.common.registry.blockmeta.managers.SawManager;
import betterwithmods.common.registry.blockmeta.recipe.SawRecipe;
import betterwithmods.module.Feature;
import betterwithmods.module.ModuleLoader;
import betterwithmods.module.hardcore.HCLumber;
import betterwithmods.util.InvUtils;
import com.google.common.collect.Lists;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;

public class SawRecipes
extends Feature {
    public SawRecipes() {
        this.canDisable = false;
    }

    public static void addSawRecipe(Block block, int meta, ItemStack output) {
        SawManager.INSTANCE.addRecipe(block, meta, output);
    }

    public static void addSawRecipe(Block block, int meta, ItemStack ... outputs) {
        SawManager.INSTANCE.addRecipe(block, meta, outputs);
    }

    public static void addSelfSawRecipe(Block block, int meta) {
        SawRecipes.addSawRecipe(new SawSelfDropRecipe(block, meta));
    }

    public static void addSawRecipe(SawRecipe recipe) {
        SawManager.INSTANCE.addRecipe(recipe);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        for (BlockPlanks.EnumType type : BlockPlanks.EnumType.values()) {
            SawRecipes.addSawRecipe(Blocks.field_150344_f, type.func_176839_a(), new ItemStack(BWMBlocks.WOOD_SIDING, 2, type.func_176839_a()));
            SawRecipes.addSawRecipe(BWMBlocks.WOOD_CORNER, type.func_176839_a(), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GEAR, 2));
            SawRecipes.addSawRecipe(BWMBlocks.WOOD_MOULDING, type.func_176839_a(), new ItemStack(BWMBlocks.WOOD_CORNER, 2, type.func_176839_a()));
            SawRecipes.addSawRecipe(BWMBlocks.WOOD_SIDING, type.func_176839_a(), new ItemStack(BWMBlocks.WOOD_MOULDING, 2, type.func_176839_a()));
            SawRecipes.addSawRecipe((Block)Blocks.field_150376_bx, type.func_176839_a(), new ItemStack(BWMBlocks.WOOD_MOULDING, 2, type.func_176839_a()));
        }
        SawRecipes.addSelfSawRecipe(Blocks.field_150423_aK, 0);
        SawRecipes.addSelfSawRecipe(Blocks.field_150395_bd, 0);
        for (int i = 0; i < 9; ++i) {
            SawRecipes.addSelfSawRecipe((Block)Blocks.field_150328_O, i);
        }
        SawRecipes.addSelfSawRecipe((Block)Blocks.field_150327_N, 0);
        SawRecipes.addSelfSawRecipe((Block)Blocks.field_150338_P, 0);
        SawRecipes.addSelfSawRecipe((Block)Blocks.field_150337_Q, 0);
        SawManager.INSTANCE.addRecipe(new SawRecipe(Blocks.field_150440_ba, 0, null){

            @Override
            public NonNullList<ItemStack> getOutputs() {
                Random random = new Random();
                return InvUtils.asNonnullList(new ItemStack(Items.field_151127_ba, 3 + random.nextInt(5)));
            }
        });
        int count = ModuleLoader.isFeatureEnabled(HCLumber.class) ? 4 : 6;
        for (BWOreDictionary.Wood wood : BWOreDictionary.woods) {
            SawRecipes.addSawRecipe(new SawRecipe(wood.getLog(1), Lists.newArrayList((Object[])new ItemStack[]{wood.getPlank(count), wood.getBark(1), wood.getSawdust(2)})));
        }
    }

    public static class SawSelfDropRecipe
    extends SawRecipe {
        public SawSelfDropRecipe(Block block, int meta) {
            super(block, meta, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(block, 1, meta)}));
        }
    }
}

