/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore;

import betterwithmods.module.Feature;
import betterwithmods.util.DispenserBehaviorFiniteWater;
import betterwithmods.util.player.PlayerHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.registry.RegistryDefaulted;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.DispenseFluidContainer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class HCBuckets
extends Feature {
    private static boolean hardcoreFluidContainer;
    private static boolean disableLavaBuckets;
    private static boolean riskyLavaBuckets;

    public static void editModdedFluidDispenseBehavior() {
        if (!hardcoreFluidContainer) {
            return;
        }
        RegistryDefaulted reg = BlockDispenser.field_149943_a;
        for (Item item : Item.field_150901_e) {
            if (!HCBuckets.isFluidContainer(new ItemStack(item)) || !(reg.func_82594_a((Object)item) instanceof DispenseFluidContainer)) continue;
            reg.func_82595_a((Object)item, (Object)new DispenserBehaviorFiniteWater());
        }
    }

    private static boolean isFluidContainer(ItemStack stack) {
        return !stack.func_190926_b() && (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) || stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null));
    }

    private static boolean isNonVanillaBucket(ItemStack stack) {
        return stack.func_77973_b() != Items.field_151133_ar && stack.func_77973_b() != Items.field_151131_as && stack.func_77973_b() != Items.field_151129_at && stack.func_77973_b() != Items.field_151117_aB && HCBuckets.isFluidContainer(stack);
    }

    @Override
    public String getFeatureDescription() {
        return "Makes it so water buckets cannot move an entire source block, making water a more valuable resource";
    }

    @Override
    public void setupConfig() {
        hardcoreFluidContainer = this.loadPropBool("Hardcore Fluid Container", "Hardcore Buckets Affects Modded Fluid Containers", true);
        disableLavaBuckets = this.loadPropBool("Hardcore Lava Buckets", "You can't put Lava in a metal bucket! Are you crazy!?", false);
        riskyLavaBuckets = this.loadPropBool("Risky Lava Buckets", "Makes Lava Buckets really hot, be careful. If only you could have some Resistance to Fire! ", true);
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public void init(FMLInitializationEvent event) {
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151131_as, (Object)new BehaviorDefaultDispenseItem(){

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                ItemStack outputStack = stack.func_77946_l();
                BlockPos pos = source.func_180699_d().func_177972_a((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
                if (source.func_82618_k().func_175623_d(pos) || source.func_82618_k().func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)source.func_82618_k(), pos)) {
                    source.func_82618_k().func_175656_a(pos, Blocks.field_150358_i.func_176203_a(2));
                    for (EnumFacing face : EnumFacing.field_176754_o) {
                        BlockPos off = pos.func_177972_a(face);
                        if (!source.func_82618_k().func_175623_d(off) && !source.func_82618_k().func_180495_p(off).func_177230_c().func_176200_f((IBlockAccess)source.func_82618_k(), off)) continue;
                        source.func_82618_k().func_175656_a(off, Blocks.field_150358_i.func_176203_a(5));
                    }
                    outputStack = new ItemStack(Items.field_151133_ar, 1);
                }
                return outputStack;
            }
        });
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        HCBuckets.editModdedFluidDispenseBehavior();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void fillFromFlowing(PlayerInteractEvent.RightClickBlock e) {
        FluidStack fluid;
        if (e.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        ItemStack stack = e.getItemStack();
        EntityPlayer player = e.getEntityPlayer();
        if (HCBuckets.isFluidContainer(stack) && ((fluid = FluidUtil.getFluidContained((ItemStack)stack)) == null || fluid.getFluid() == null) && !player.field_71075_bZ.field_75098_d) {
            if (stack.func_77973_b() == Items.field_151133_ar) {
                MinecraftForge.EVENT_BUS.post((Event)new FillBucketEvent(player, stack, e.getWorld(), new RayTraceResult(e.getHitVec(), e.getFace())));
                return;
            }
            e.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void fluidContainerUse(FillBucketEvent evt) {
        boolean dimValid;
        if (!hardcoreFluidContainer) {
            return;
        }
        if (evt.getEmptyBucket().func_190926_b()) {
            evt.setResult(Event.Result.DENY);
            return;
        }
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)evt.getEmptyBucket());
        RayTraceResult target = evt.getTarget();
        EntityPlayer player = evt.getEntityPlayer();
        boolean bl = dimValid = evt.getWorld().field_73011_w.func_186058_p() == DimensionType.OVERWORLD;
        if (dimValid && target != null && target.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = target.func_178782_a().func_177972_a(target.field_178784_b);
            IBlockState state = evt.getWorld().func_180495_p(pos);
            if (fluid == null || fluid.getFluid() == null) {
                if (this.isWater(state) && state.func_177230_c().func_176201_c(state) > 0 && !player.field_71075_bZ.field_75098_d) {
                    if (evt.getEmptyBucket().func_77973_b() == Items.field_151133_ar) {
                        evt.setFilledBucket(new ItemStack(Items.field_151131_as));
                    } else if (HCBuckets.isFluidContainer(evt.getEmptyBucket()) && hardcoreFluidContainer) {
                        ItemStack fill = evt.getEmptyBucket().func_77946_l();
                        ((IFluidHandler)fill.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).fill(new FluidStack(FluidRegistry.WATER, 1000), true);
                        evt.setFilledBucket(fill);
                    }
                    evt.setResult(Event.Result.ALLOW);
                    return;
                }
            } else if (fluid != null && fluid.getFluid() != null && fluid.getFluid() == FluidRegistry.WATER && (state.func_177230_c().isAir(state, (IBlockAccess)evt.getWorld(), pos) || state.func_177230_c().func_176200_f((IBlockAccess)evt.getWorld(), pos)) && !player.field_71075_bZ.field_75098_d && (evt.getEmptyBucket().func_77973_b() == Items.field_151131_as || HCBuckets.isNonVanillaBucket(evt.getEmptyBucket()) && hardcoreFluidContainer)) {
                this.bucketEmpty(evt, pos, evt.getEmptyBucket());
            }
        }
    }

    private void bucketEmpty(FillBucketEvent evt, BlockPos pos, ItemStack equip) {
        if (this.isWater(evt.getWorld().func_180495_p(pos))) {
            IBlockState state = evt.getWorld().func_180495_p(pos);
            if (state.func_177230_c().func_176201_c(state) > 0) {
                this.emptyBucket(evt, pos, equip);
            }
        } else {
            this.emptyBucket(evt, pos, equip);
        }
    }

    private void emptyBucket(FillBucketEvent evt, BlockPos pos, ItemStack equip) {
        Item item = equip.func_77973_b();
        evt.getWorld().func_175656_a(pos, Blocks.field_150358_i.func_176203_a(2));
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos p2 = pos.func_177972_a(facing);
            if (this.isWater(evt.getWorld().func_180495_p(p2)) || !evt.getWorld().func_180495_p(p2).func_177230_c().isAir(evt.getWorld().func_180495_p(p2), (IBlockAccess)evt.getWorld(), p2) && !evt.getWorld().func_180495_p(p2).func_177230_c().func_176200_f((IBlockAccess)evt.getWorld(), p2)) continue;
            evt.getWorld().func_175656_a(p2, Blocks.field_150358_i.func_176203_a(5));
        }
        evt.getWorld().func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
        evt.setFilledBucket(item.getContainerItem(equip).func_77946_l());
        evt.setResult(Event.Result.ALLOW);
    }

    private boolean isWater(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i;
    }

    @SubscribeEvent
    public void fluidContainerUse(PlayerInteractEvent.RightClickBlock evt) {
        if (!hardcoreFluidContainer) {
            return;
        }
        ItemStack toCheck = evt.getEntityPlayer().func_184586_b(evt.getHand());
        if (toCheck.func_190926_b() || toCheck.func_77973_b() == Items.field_151131_as || !HCBuckets.isNonVanillaBucket(toCheck)) {
            return;
        }
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)toCheck);
        if (fluid == null || fluid.getFluid() == null || fluid.getFluid() != FluidRegistry.WATER) {
            return;
        }
        if (!evt.getWorld().field_72995_K) {
            Item item;
            evt.setUseBlock(Event.Result.DENY);
            IBlockState state = evt.getWorld().func_180495_p(evt.getPos());
            Block block = state.func_177230_c();
            boolean replaceable = block.func_176200_f((IBlockAccess)evt.getWorld(), evt.getPos());
            BlockPos pos = replaceable ? evt.getPos() : evt.getPos().func_177972_a(evt.getFace());
            state = evt.getWorld().func_180495_p(pos);
            if (evt.getWorld().field_73011_w.func_186058_p() == DimensionType.OVERWORLD && !block.func_180639_a(evt.getWorld(), evt.getPos(), state, evt.getEntityPlayer(), evt.getHand(), evt.getFace(), 0.5f, 0.5f, 0.5f) && (state.func_177230_c().isAir(state, (IBlockAccess)evt.getWorld(), pos) || state.func_177230_c().func_176200_f((IBlockAccess)evt.getWorld(), pos)) && (item = toCheck.func_77973_b()).func_77661_b(toCheck) == EnumAction.NONE) {
                if (this.isWater(state)) {
                    if (state.func_177230_c().func_176201_c(state) > 0) {
                        this.placeContainerFluid(evt, pos, toCheck);
                    }
                } else {
                    this.placeContainerFluid(evt, pos, toCheck);
                }
            }
        }
    }

    private void placeContainerFluid(PlayerInteractEvent.RightClickBlock evt, BlockPos pos, ItemStack equip) {
        if (!evt.getEntityPlayer().field_71075_bZ.field_75098_d) {
            Item item = equip.func_77973_b();
            evt.getWorld().func_175656_a(pos, Blocks.field_150358_i.func_176203_a(2));
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                BlockPos p2 = pos.func_177972_a(facing);
                if (this.isWater(evt.getWorld().func_180495_p(p2)) || !evt.getWorld().func_180495_p(p2).func_177230_c().isAir(evt.getWorld().func_180495_p(p2), (IBlockAccess)evt.getWorld(), p2) && !evt.getWorld().func_180495_p(p2).func_177230_c().func_176200_f((IBlockAccess)evt.getWorld(), p2)) continue;
                evt.getWorld().func_175656_a(p2, Blocks.field_150358_i.func_176203_a(5));
            }
            if (equip.func_190916_E() == 1) {
                EnumHand hand = evt.getHand();
                evt.getEntityPlayer().func_184201_a(hand == EnumHand.OFF_HAND ? EntityEquipmentSlot.OFFHAND : EntityEquipmentSlot.MAINHAND, item.hasContainerItem(equip) ? item.getContainerItem(equip).func_77946_l() : null);
            } else if (equip.func_190916_E() > 1) {
                equip.func_190918_g(1);
                if (item.hasContainerItem(equip)) {
                    evt.getEntityPlayer().field_71071_by.func_70441_a(item.getContainerItem(equip).func_77946_l());
                }
                evt.setUseItem(Event.Result.DENY);
            }
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void checkPlayerInventory(TickEvent.PlayerTickEvent e) {
        World world = e.player.func_130014_f_();
        if (riskyLavaBuckets) {
            boolean isPlayerRisky;
            boolean bl = isPlayerRisky = e.player.func_70051_ag() || !e.player.field_70122_E;
            if (isPlayerRisky && world.func_82737_E() % 10L == 0L && !e.player.func_70644_a(MobEffects.field_76426_n) && !e.player.field_71075_bZ.field_75098_d) {
                IItemHandler inv = (IItemHandler)e.player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                BlockPos pos = e.player.func_180425_c();
                if (inv != null) {
                    for (int i = 0; i < inv.getSlots(); ++i) {
                        ItemStack stack = inv.getStackInSlot(i);
                        if (world.field_73012_v.nextInt(50) != 0 || stack.func_190926_b() || !stack.func_77969_a(new ItemStack(Items.field_151129_at))) continue;
                        IFluidHandler bucket = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                        if (bucket != null) {
                            bucket.drain(1000, true);
                            world.func_184133_a(e.player, pos, SoundEvents.field_187627_L, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            this.placeLavaBucket(world, pos.func_177972_a(e.player.func_174811_aO()), 0);
                            continue;
                        }
                        inv.extractItem(i, 1, false);
                        inv.insertItem(i, new ItemStack(Items.field_151133_ar), false);
                        world.func_184133_a(e.player, pos, SoundEvents.field_187627_L, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        this.placeLavaBucket(world, pos.func_177972_a(e.player.func_174811_aO()), 0);
                    }
                }
            }
        }
    }

    public void placeLavaBucket(World world, BlockPos pos, int depth) {
        if (depth >= 5) {
            return;
        }
        if (world.func_175623_d(pos)) {
            world.func_175656_a(pos, Blocks.field_150356_k.func_176223_P());
        } else {
            this.placeLavaBucket(world, pos.func_177972_a(EnumFacing.field_82609_l[world.field_73012_v.nextInt(6)]), depth++);
        }
    }

    @SubscribeEvent
    public void onFillBucket(FillBucketEvent e) {
        if (disableLavaBuckets && PlayerHelper.isSurvival(e.getEntityPlayer())) {
            Block block;
            if (e.getEntityPlayer().func_70644_a(MobEffects.field_76426_n)) {
                return;
            }
            if (e.getTarget() != null && e.getTarget().func_178782_a() != null && ((block = e.getWorld().func_180495_p(e.getTarget().func_178782_a()).func_177230_c()) == Blocks.field_150353_l || block == Blocks.field_150356_k)) {
                e.getEntityPlayer().func_70097_a(DamageSource.field_76371_c, 1.0f);
                e.getWorld().func_184133_a(null, e.getTarget().func_178782_a(), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.5f);
                e.setCanceled(true);
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

