/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore;

import betterwithmods.common.damagesource.BWDamageSource;
import betterwithmods.module.Feature;
import betterwithmods.util.player.GloomPenalty;
import betterwithmods.util.player.PlayerHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.ArrayUtils;

public class HCGloom
extends Feature {
    private static final DataParameter<Integer> GLOOM_TICK = EntityDataManager.func_187226_a(EntityPlayer.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final List<SoundEvent> sounds = Lists.newArrayList((Object[])new SoundEvent[]{SoundEvents.field_187754_de, SoundEvents.field_187534_aX, SoundEvents.field_187532_aV, SoundEvents.field_187793_eY, SoundEvents.field_187861_gG});
    private static Set<Integer> dimensionWhitelist;

    public static int getGloomTime(EntityPlayer player) {
        try {
            return (Integer)player.func_184212_Q().func_187225_a(GLOOM_TICK);
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public static void incrementGloomTime(EntityPlayer player) {
        HCGloom.setGloomTick(player, HCGloom.getGloomTime(player) + 1);
    }

    public static void setGloomTick(EntityPlayer player, int value) {
        player.func_184212_Q().func_187227_b(GLOOM_TICK, (Object)value);
    }

    @Override
    public void setupConfig() {
        dimensionWhitelist = Sets.newHashSet((Object[])ArrayUtils.toObject((int[])this.loadPropIntList("Gloom Dimension Whitelist", "Gloom is only available in these dimensions", new int[]{0})));
    }

    @SubscribeEvent
    public void onEntityInit(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof EntityPlayer) {
            event.getEntity().func_184212_Q().func_187214_a(GLOOM_TICK, (Object)0);
        }
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.PlayerRespawnEvent e) {
        HCGloom.setGloomTick(e.player, 0);
    }

    @SubscribeEvent
    public void inDarkness(TickEvent.PlayerTickEvent e) {
        GloomPenalty gloomPenalty;
        EntityPlayer player = e.player;
        World world = player.func_130014_f_();
        if (!PlayerHelper.isSurvival(player) || !dimensionWhitelist.contains(world.field_73011_w.getDimension())) {
            return;
        }
        if (!world.field_72995_K) {
            int light = world.func_175699_k(player.func_180425_c().func_177984_a());
            int tick = HCGloom.getGloomTime(player);
            if (light <= 0 && !player.func_70644_a(MobEffects.field_76439_r)) {
                HCGloom.incrementGloomTime(player);
            } else if (tick != 0) {
                HCGloom.setGloomTick(player, 0);
            }
        }
        if ((gloomPenalty = PlayerHelper.getGloomPenalty(player)) != GloomPenalty.NO_PENALTY) {
            this.playRandomSound(gloomPenalty, world, player);
            if (gloomPenalty == GloomPenalty.TERROR) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 100, 3));
                player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 100, 20));
                if (world.func_82737_E() % 40L == 0L && world.field_73012_v.nextInt(2) == 0) {
                    if (world.field_72995_K) {
                        player.func_184185_a(SoundEvents.field_187533_aW, 0.7f, 0.8f + world.field_73012_v.nextFloat() * 0.2f);
                    }
                    player.func_70097_a((DamageSource)BWDamageSource.gloom, 1.0f);
                }
            }
        }
    }

    public void playRandomSound(GloomPenalty gloom, World world, EntityPlayer player) {
        if (world.field_72995_K && world.field_73012_v.nextInt((int)(200.0f / gloom.getModifier())) == 0) {
            player.func_184185_a(SoundEvents.field_187674_a, 0.7f, 0.8f + world.field_73012_v.nextFloat() * 0.2f);
            if (gloom != GloomPenalty.GLOOM && world.field_73012_v.nextInt((int)(10.0f / gloom.getModifier())) == 0) {
                player.func_184185_a(sounds.get(world.field_73012_v.nextInt(sounds.size())), 0.7f, 0.8f + world.field_73012_v.nextFloat() * 0.2f);
            }
        }
    }

    @SubscribeEvent
    public void onFOVUpdate(FOVUpdateEvent event) {
        GloomPenalty penalty = PlayerHelper.getGloomPenalty(event.getEntity());
        if (penalty != GloomPenalty.NO_PENALTY) {
            float change = penalty != GloomPenalty.TERROR ? (float)HCGloom.getGloomTime(event.getEntity()) / 2400.0f : -((float)HCGloom.getGloomTime(event.getEntity()) / 100000.0f);
            event.setNewfov(event.getFov() + change);
        }
    }

    @Override
    public String getFeatureDescription() {
        return "Be afraid of the dark...";
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

