/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore;

import betterwithmods.common.items.ItemMaterial;
import betterwithmods.module.Feature;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HCGunpowder
extends Feature {
    public static List<Class> disableGunpowder = Lists.newArrayList();

    @Override
    public void setupConfig() {
        String[] array = this.loadPropStringList("Disable Gunpowder Drop", "List of entity classes which gunpowder will be replaced with niter", new String[]{"net.minecraft.entity.monster.EntityCreeper", "net.minecraft.entity.monster.EntityGhast", "net.minecraft.entity.monster.EntityWitch"});
        disableGunpowder = Arrays.stream(array).map(clazz -> {
            try {
                return Class.forName(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }).collect(Collectors.toList());
    }

    @Override
    public String getFeatureDescription() {
        return "Makes a raw resource drop that must be crafted to make useful gunpowder";
    }

    @SubscribeEvent
    public void mobDrops(LivingDropsEvent evt) {
        boolean contained = false;
        for (Class clazz : disableGunpowder) {
            if (!evt.getEntity().getClass().isAssignableFrom(clazz)) continue;
            contained = true;
            break;
        }
        if (contained) {
            for (EntityItem item : evt.getDrops()) {
                ItemStack stack = item.func_92059_d();
                if (stack.func_77973_b() != Items.field_151016_H) continue;
                item.func_92058_a(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.NITER, stack.func_190916_E()));
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

