/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore;

import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.registry.ChoppingRecipe;
import betterwithmods.module.Feature;
import betterwithmods.util.RecipeUtils;
import com.google.common.collect.Lists;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HCLumber
extends Feature {
    private int plankAmount;
    private int barkAmount;
    private int sawDustAmount;

    public static boolean hasAxe(BlockEvent.HarvestDropsEvent event) {
        EntityPlayer player;
        if (!event.getWorld().field_72995_K && !event.isSilkTouching() && (player = event.getHarvester()) != null) {
            ItemStack stack = player.func_184582_a(EntityEquipmentSlot.MAINHAND);
            return stack.func_77973_b().getHarvestLevel(player.func_184582_a(EntityEquipmentSlot.MAINHAND), "axe", player, event.getState()) >= 0 || stack.func_77973_b().getToolClasses(player.func_184582_a(EntityEquipmentSlot.MAINHAND)).contains("axe");
        }
        return false;
    }

    @Override
    public void setupConfig() {
        this.plankAmount = this.loadPropInt("Plank Amount", "Amount of Planks dropped when Punching Wood", 2);
        this.barkAmount = this.loadPropInt("Bark Amount", "Amount of Bark dropped when Punching Wood", 1);
        this.sawDustAmount = this.loadPropInt("Sawdust Amount", "Amount of Sawdust dropped when Punching Wood", 2);
    }

    @Override
    public String getFeatureDescription() {
        return "Makes Punching Wood return a single plank and secondary drops instead of a log, to get a log an axe must be used.";
    }

    @Override
    public void init(FMLInitializationEvent event) {
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        if (!Loader.isModLoaded((String)"primal")) {
            for (BWOreDictionary.Wood wood : BWOreDictionary.woods) {
                RecipeUtils.removeRecipes(wood.plank);
                RecipeUtils.addRecipe((IRecipe)new ChoppingRecipe(wood.getPlank(this.plankAmount), wood.getBark(this.barkAmount), wood.getSawdust(this.sawDustAmount), wood.log));
            }
        }
    }

    @Override
    public void disabledInit(FMLInitializationEvent event) {
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @SubscribeEvent
    public void harvestLog(BlockEvent.HarvestDropsEvent evt) {
        if (!evt.getWorld().field_72995_K) {
            if (HCLumber.hasAxe(evt) || Loader.isModLoaded((String)"primal")) {
                return;
            }
            ItemStack stack = RecipeUtils.getStackFromState(evt.getState());
            BWOreDictionary.Wood wood = BWOreDictionary.woods.stream().filter(w -> w.getLog(1).func_77969_a(stack)).findFirst().orElse(null);
            if (wood != null) {
                evt.getDrops().clear();
                evt.getDrops().addAll(Lists.newArrayList((Object[])new ItemStack[]{wood.getPlank(1), wood.getSawdust(2), wood.getBark(1)}));
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

