/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore;

import betterwithmods.common.BWOreDictionary;
import betterwithmods.module.Feature;
import betterwithmods.module.gameplay.CrucibleRecipes;
import betterwithmods.util.RecipeUtils;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class HCOres
extends Feature {
    private static boolean oreNuggetSmelting;
    private static boolean dustNuggetSmelting;
    private static boolean fixVanillaRecipes;
    private static Set<String> oreExclude;
    private static Set<String> dustExclude;
    private static int oreProductionCount;
    private static int dustProductionCount;

    @Override
    public void setupConfig() {
        oreNuggetSmelting = this.loadPropBool("Ore to Nugget Smelting", "Make Ores (oredict ore.* )smelt into nuggets instead of ingots", true);
        oreExclude = Arrays.stream(this.loadPropStringList("Ore Exclude", "Oredictionary entries to exclude from ore to nugget smelting. Remove the prefix of the oredictionary. example 'oreIron' would be just 'iron' ", new String[0])).map(String::toLowerCase).collect(Collectors.toSet());
        dustExclude = Arrays.stream(this.loadPropStringList("Dust Exclude", "Oredictionary entries to exclude from dust to nugget smelting  Remove the prefix of the oredictionary. example 'dustIron' would be just 'iron'", new String[0])).map(String::toLowerCase).collect(Collectors.toSet());
        dustNuggetSmelting = this.loadPropBool("Dust to Nugget Smelting", "Make Dusts ( oredict dust.* ) smelt into nuggets instead of ingots", true);
        fixVanillaRecipes = this.loadPropBool("Fix Vanilla Recipes", "Make certain recipes cheaper to be more reasonable with nugget smelting, including Compass, Clock, and Bucket", true);
        oreProductionCount = this.loadPropInt("Ore Production Count", "Number of Materials returned from Smelting an Ore", 1);
        dustProductionCount = this.loadPropInt("Dust Production Count", "Number of Materials returned from Smelting a Dust", 1);
    }

    @Override
    public String getFeatureDescription() {
        return "Makes Ores only smelt into a single nugget, making it much harder to create large amounts of metal";
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (fixVanillaRecipes) {
            RecipeUtils.removeRecipes(Items.field_151111_aL, 0);
            RecipeUtils.removeRecipes(Items.field_151113_aN, 0);
            RecipeUtils.removeRecipes(Items.field_151133_ar, 0);
            RecipeUtils.removeRecipes(Items.field_151033_d, 0);
            RecipeUtils.addOreRecipe(new ItemStack(Items.field_151111_aL), " N ", "NRN", " N ", Character.valueOf('N'), "nuggetIron", Character.valueOf('R'), "dustRedstone");
            RecipeUtils.addOreRecipe(new ItemStack(Items.field_151113_aN), " N ", "NQN", " N ", Character.valueOf('N'), "nuggetGold", Character.valueOf('Q'), "gemQuartz");
            RecipeUtils.addOreRecipe(new ItemStack(Items.field_151133_ar), "N N", " N ", Character.valueOf('N'), "nuggetIron");
            RecipeUtils.addShapelessOreRecipe(new ItemStack(Items.field_151033_d), Items.field_151145_ak, "nuggetIron");
        }
        CrucibleRecipes.addStokedCrucibleRecipe(new ItemStack(Items.field_191525_da, 3), new Object[]{new ItemStack(Items.field_151133_ar)});
        CrucibleRecipes.addStokedCrucibleRecipe(new ItemStack(Items.field_191525_da, 4), new Object[]{new ItemStack(Items.field_151111_aL)});
        CrucibleRecipes.addStokedCrucibleRecipe(new ItemStack(Items.field_151074_bl, 4), new Object[]{new ItemStack(Items.field_151113_aN)});
        CrucibleRecipes.addStokedCrucibleRecipe(new ItemStack(Items.field_191525_da), new Object[]{new ItemStack((Block)Blocks.field_150479_bC, 2, 0)});
        CrucibleRecipes.addStokedCrucibleRecipe(new ItemStack(Items.field_191525_da), new Object[]{new ItemStack(Items.field_151033_d)});
    }

    @Override
    public void disabledInit(FMLInitializationEvent event) {
        CrucibleRecipes.addStokedCrucibleRecipe(new ItemStack(Items.field_151042_j, 3), new Object[]{new ItemStack(Items.field_151133_ar)});
        CrucibleRecipes.addStokedCrucibleRecipe(new ItemStack(Items.field_151042_j), new Object[]{new ItemStack((Block)Blocks.field_150479_bC, 2, 0)});
        CrucibleRecipes.addStokedCrucibleRecipe(new ItemStack(Items.field_151042_j), new Object[]{new ItemStack(Items.field_151033_d, 1, Short.MAX_VALUE)});
        CrucibleRecipes.addStokedCrucibleRecipe(new ItemStack(Items.field_151042_j, 4), new Object[]{new ItemStack(Items.field_151111_aL)});
        CrucibleRecipes.addStokedCrucibleRecipe(new ItemStack(Items.field_151043_k, 4), new Object[]{new ItemStack(Items.field_151113_aN)});
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        Sets.SetView oreExcludes = Sets.union(oreExclude, (Set)Sets.newHashSet((Object[])new String[]{"diamond"}));
        if (oreNuggetSmelting) {
            List<Pair> oreSuffixes = BWOreDictionary.oreNames.stream().map(i -> Pair.of((Object)i, (Object)BWOreDictionary.getSuffix(i, "ore"))).filter(arg_0 -> HCOres.lambda$postInit$1((Set)oreExcludes, arg_0)).collect(Collectors.toList());
            oreSuffixes.forEach(pair -> OreDictionary.getOres((String)("nugget" + (String)pair.getValue())).stream().findFirst().ifPresent(nugget -> {
                ItemStack n = nugget.func_77946_l();
                n.func_190920_e(oreProductionCount);
                RecipeUtils.removeFurnaceRecipe((ItemStack)pair.getKey());
                FurnaceRecipes.func_77602_a().func_77599_b().put(pair.getKey(), n);
            }));
        }
        Sets.SetView dustExcludes = Sets.union(dustExclude, (Set)Sets.newHashSet((Object[])new String[]{"diamond"}));
        if (dustNuggetSmelting) {
            List<Pair> dustSuffixes = BWOreDictionary.dustNames.stream().map(i -> Pair.of((Object)i, (Object)BWOreDictionary.getSuffix(i, "dust"))).filter(arg_0 -> HCOres.lambda$postInit$5((Set)dustExcludes, arg_0)).collect(Collectors.toList());
            dustSuffixes.forEach(pair -> OreDictionary.getOres((String)("nugget" + (String)pair.getValue())).stream().findFirst().ifPresent(nugget -> {
                ItemStack n = nugget.func_77946_l();
                n.func_190920_e(dustProductionCount);
                RecipeUtils.removeFurnaceRecipe((ItemStack)pair.getKey());
                FurnaceRecipes.func_77602_a().func_77599_b().put(pair.getKey(), n);
            }));
        }
    }

    private static /* synthetic */ boolean lambda$postInit$5(Set dustExcludes, Pair p) {
        return !dustExcludes.contains(((String)p.getValue()).toLowerCase());
    }

    private static /* synthetic */ boolean lambda$postInit$1(Set oreExcludes, Pair p) {
        return !oreExcludes.contains(((String)p.getValue()).toLowerCase());
    }
}

