/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.module.Feature;
import betterwithmods.util.InvUtils;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HCSeeds
extends Feature {
    private static final Random RANDOM = new Random();
    public static Set<IBlockState> BLOCKS_TO_STOP = Sets.newHashSet();
    private static Predicate<IBlockState> STOP_SEEDS = state -> {
        Block block = state.func_177230_c();
        return BLOCKS_TO_STOP.contains(state) || block instanceof BlockTallGrass || block instanceof BlockDoublePlant && (state.func_177229_b((IProperty)BlockDoublePlant.field_176493_a) == BlockDoublePlant.EnumPlantType.GRASS || state.func_177229_b((IProperty)BlockDoublePlant.field_176493_a) == BlockDoublePlant.EnumPlantType.FERN);
    };

    @Override
    public String getFeatureDescription() {
        return "Requires Tilling the ground with a hoe to get seeds.";
    }

    @SubscribeEvent
    public void onHarvest(BlockEvent.HarvestDropsEvent event) {
        if (STOP_SEEDS.test(event.getState())) {
            event.getDrops().clear();
        }
    }

    public NonNullList<ItemStack> getDrops(int fortune) {
        if (RANDOM.nextInt(8) != 0) {
            return NonNullList.func_191196_a();
        }
        ItemStack seed = ForgeHooks.getGrassSeed((Random)RANDOM, (int)0);
        if (seed.func_77969_a(new ItemStack(Items.field_151014_N)) || seed.func_190926_b()) {
            return NonNullList.func_191196_a();
        }
        return NonNullList.func_191197_a((int)1, (Object)seed);
    }

    @SubscribeEvent
    public void onHoe(UseHoeEvent e) {
        IBlockState state;
        BlockPos pos;
        World world = e.getWorld();
        if (!world.field_72995_K && world.func_175623_d((pos = e.getPos()).func_177984_a()) && ((state = world.func_180495_p(pos)).func_177230_c() instanceof BlockGrass || state.func_177230_c() instanceof BlockDirt)) {
            InvUtils.ejectStackWithOffset(world, pos.func_177984_a(), this.getDrops(0));
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.addGrassSeed((ItemStack)new ItemStack(BWMBlocks.HEMP, 1), (int)5);
    }

    @Override
    public void disabledInit(FMLInitializationEvent event) {
        MinecraftForge.addGrassSeed((ItemStack)new ItemStack(BWMBlocks.HEMP, 1), (int)5);
    }

    @SubscribeEvent
    public void mobDrop(LivingDropsEvent e) {
        Iterator iter = e.getDrops().iterator();
        while (iter.hasNext()) {
            EntityItem item = (EntityItem)iter.next();
            ItemStack stack = item.func_92059_d();
            if (!BWOreDictionary.hasSuffix(stack, "crop")) continue;
            iter.remove();
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

