/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore;

import betterwithmods.BWMod;
import betterwithmods.module.Feature;
import betterwithmods.util.player.PlayerHelper;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.StatList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HCSpawn
extends Feature {
    public static final int HARDCORE_SPAWN_RADIUS = 2000;
    public static final int HARDCORE_SPAWN_COOLDOWN_RADIUS = 100;
    public static final int HARDCORE_SPAWN_COOLDOWN = 24000;
    public static final int HARDCORE_SPAWN_MAX_ATTEMPTS = 20;

    @Override
    public String getFeatureDescription() {
        return "Makes it so death is actual issues as you will spawn randomly within a 2000 block radius of your original spawn. Compasses still point to Original Spawn";
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @SubscribeEvent
    public void randomRespawn(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
        if (PlayerHelper.isSurvival((EntityPlayer)player)) {
            int timeSinceDeath = player.func_147099_x().func_77444_a(StatList.field_188098_h);
            boolean isNew = timeSinceDeath >= 24000;
            int spawnFuzz = isNew ? 2000 : 100;
            BlockPos newPos = this.getRespawnPoint((EntityPlayer)player, spawnFuzz);
            player.func_180473_a(newPos, true);
            if (isNew) {
                // empty if block
            }
        }
    }

    private BlockPos getRespawnPoint(EntityPlayer player, int spawnFuzz) {
        World world = player.func_130014_f_();
        BlockPos ret = world.func_175694_M();
        if (!world.field_73011_w.func_177495_o()) {
            boolean found = false;
            for (int tryCounter = 0; tryCounter < 20; ++tryCounter) {
                ret = world.func_175694_M();
                double fuzzVar = world.field_73012_v.nextDouble() * (double)spawnFuzz;
                double angle = world.field_73012_v.nextDouble();
                double customX = (double)(-MathHelper.func_76126_a((float)((float)(angle * 360.0)))) * fuzzVar;
                double customZ = (double)MathHelper.func_76134_b((float)((float)(angle * 360.0))) * fuzzVar;
                ret = ret.func_177963_a((double)MathHelper.func_76128_c((double)customX) + 0.5, 1.5, (double)MathHelper.func_76128_c((double)customZ) + 0.5);
                ret = world.func_175672_r(ret);
                int cmp = ret.func_177956_o() - world.field_73011_w.func_76557_i();
                Material check = world.func_180495_p(ret).func_185904_a();
                if (cmp < 0 || check != null && check.func_76224_d()) continue;
                found = true;
                break;
            }
            if (!found) {
                BWMod.logger.warn("New respawn point could not be found.");
            }
        }
        return ret;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

