/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore;

import betterwithmods.common.world.BWComponentScatteredFeaturePieces;
import betterwithmods.common.world.BWMapGenScatteredFeature;
import betterwithmods.module.Feature;
import betterwithmods.util.RecipeUtils;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.ComponentScatteredFeaturePieces;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HCStructures
extends Feature {
    private boolean disableRecipes;

    @Override
    public String getFeatureDescription() {
        return "Makes it so structures are looted within a radius of spawn and unlooted outside of that radius. \nEncourages exploration.\nAlso makes unlooted structures the only source of Enchanting Tables and Brewing Stands.";
    }

    @Override
    public void setupConfig() {
        this.disableRecipes = this.loadPropBool("Disable Recipes", "Disable Recipes for blocks that generate only in structures, including Enchanting Tables and Brewing Stands", true);
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (this.disableRecipes) {
            RecipeUtils.removeRecipes(Blocks.field_150381_bn);
            RecipeUtils.removeRecipes(Items.field_151067_bt, 0);
        }
        MapGenStructureIO.func_143034_b(BWMapGenScatteredFeature.Start.class, (String)"BWTemple");
        MapGenStructureIO.func_143031_a(BWComponentScatteredFeaturePieces.DesertPyramid.class, (String)"BWTeDP");
        MapGenStructureIO.func_143031_a(BWComponentScatteredFeaturePieces.JunglePyramid.class, (String)"BWTeJP");
        MapGenStructureIO.func_143031_a(BWComponentScatteredFeaturePieces.SwampHut.class, (String)"BWTeSH");
        MapGenStructureIO.func_143031_a(ComponentScatteredFeaturePieces.Igloo.class, (String)"BWIglu");
    }

    public static boolean isInRadius(World world, int x, int z) {
        BlockPos center = world.func_175694_M();
        return Math.sqrt(Math.pow(x - center.func_177958_n(), 2.0) + Math.pow(z - center.func_177952_p(), 2.0)) < 2000.0;
    }

    @SubscribeEvent
    public void overrideScatteredFeature(InitMapGenEvent event) {
        if (event.getType().equals((Object)InitMapGenEvent.EventType.SCATTERED_FEATURE)) {
            event.setNewGen((MapGenBase)new BWMapGenScatteredFeature());
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean hasTerrainSubscriptions() {
        return true;
    }
}

