/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore;

import betterwithmods.common.BWMItems;
import betterwithmods.common.blocks.BlockStump;
import betterwithmods.common.world.gen.feature.WorldGenBigTreeWithStump;
import betterwithmods.common.world.gen.feature.WorldGenBirchTreeWithStump;
import betterwithmods.common.world.gen.feature.WorldGenCanopyTreeWithStump;
import betterwithmods.common.world.gen.feature.WorldGenMegaJungleWithStump;
import betterwithmods.common.world.gen.feature.WorldGenMegaPineTreeWithStump;
import betterwithmods.common.world.gen.feature.WorldGenSavannaTreeWithStump;
import betterwithmods.common.world.gen.feature.WorldGenTaiga2WithStump;
import betterwithmods.common.world.gen.feature.WorldGenTreesWithStump;
import betterwithmods.module.Feature;
import betterwithmods.util.RecipeUtils;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HCStumping
extends Feature {
    private static boolean shouldBeSkipped(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150362_t || state.func_177230_c() == Blocks.field_150361_u || state.func_177230_c() == Blocks.field_150364_r || state.func_177230_c() == Blocks.field_150363_s || state.func_177230_c() == Blocks.field_150350_a;
    }

    private static boolean canSustainTree(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_150458_ak;
    }

    @Nullable
    public static BlockPlanks.EnumType getWoodType(IBlockState state) {
        if (state.func_177228_b().containsKey((Object)BlockPlanks.field_176383_a)) {
            return (BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockPlanks.field_176383_a);
        }
        if (state.func_177228_b().containsKey((Object)BlockOldLog.field_176301_b)) {
            return (BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockOldLog.field_176301_b);
        }
        if (state.func_177228_b().containsKey((Object)BlockNewLog.field_176300_b)) {
            return (BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockNewLog.field_176300_b);
        }
        return null;
    }

    private static boolean isTwoByTwoOfType(BlockSapling sapling, World worldIn, BlockPos pos, int p_181624_3_, int p_181624_4_, BlockPlanks.EnumType type) {
        return sapling.func_176477_a(worldIn, pos.func_177982_a(p_181624_3_, 0, p_181624_4_), type) && sapling.func_176477_a(worldIn, pos.func_177982_a(p_181624_3_ + 1, 0, p_181624_4_), type) && sapling.func_176477_a(worldIn, pos.func_177982_a(p_181624_3_, 0, p_181624_4_ + 1), type) && sapling.func_176477_a(worldIn, pos.func_177982_a(p_181624_3_ + 1, 0, p_181624_4_ + 1), type);
    }

    public static void generateTreeWithStump(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!(state.func_177230_c() instanceof BlockSapling)) {
            return;
        }
        BlockSapling sapling = (BlockSapling)state.func_177230_c();
        Object worldgenerator = rand.nextInt(10) == 0 ? new WorldGenBigTreeWithStump(true) : new WorldGenTreesWithStump(true);
        int i = 0;
        int j = 0;
        boolean flag = false;
        switch ((BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockSapling.field_176480_a)) {
            case SPRUCE: {
                block7: for (i = 0; i >= -1; --i) {
                    for (j = 0; j >= -1; --j) {
                        if (!HCStumping.isTwoByTwoOfType(sapling, worldIn, pos, i, j, BlockPlanks.EnumType.SPRUCE)) continue;
                        worldgenerator = new WorldGenMegaPineTreeWithStump(false, rand.nextBoolean());
                        flag = true;
                        break block7;
                    }
                }
                if (flag) break;
                i = 0;
                j = 0;
                worldgenerator = new WorldGenTaiga2WithStump(true);
                break;
            }
            case BIRCH: {
                worldgenerator = new WorldGenBirchTreeWithStump(true, false);
                break;
            }
            case JUNGLE: {
                IBlockState iblockstate = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
                IBlockState iblockstate1 = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.FALSE);
                block9: for (i = 0; i >= -1; --i) {
                    for (j = 0; j >= -1; --j) {
                        if (!HCStumping.isTwoByTwoOfType(sapling, worldIn, pos, i, j, BlockPlanks.EnumType.JUNGLE)) continue;
                        worldgenerator = new WorldGenMegaJungleWithStump(true, 10, 20, iblockstate, iblockstate1);
                        flag = true;
                        break block9;
                    }
                }
                if (flag) break;
                i = 0;
                j = 0;
                worldgenerator = new WorldGenTreesWithStump(true, 4 + rand.nextInt(7), iblockstate, iblockstate1, false);
                break;
            }
            case ACACIA: {
                worldgenerator = new WorldGenSavannaTreeWithStump(true);
                break;
            }
            case DARK_OAK: {
                block11: for (i = 0; i >= -1; --i) {
                    for (j = 0; j >= -1; --j) {
                        if (!HCStumping.isTwoByTwoOfType(sapling, worldIn, pos, i, j, BlockPlanks.EnumType.DARK_OAK)) continue;
                        worldgenerator = new WorldGenCanopyTreeWithStump(true);
                        flag = true;
                        break block11;
                    }
                }
                if (flag) break;
                return;
            }
        }
        IBlockState iblockstate2 = Blocks.field_150350_a.func_176223_P();
        if (flag) {
            worldIn.func_180501_a(pos.func_177982_a(i, 0, j), iblockstate2, 4);
            worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j), iblockstate2, 4);
            worldIn.func_180501_a(pos.func_177982_a(i, 0, j + 1), iblockstate2, 4);
            worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), iblockstate2, 4);
        } else {
            worldIn.func_180501_a(pos, iblockstate2, 4);
        }
        if (!worldgenerator.func_180709_b(worldIn, rand, pos.func_177982_a(i, 0, j))) {
            if (flag) {
                worldIn.func_180501_a(pos.func_177982_a(i, 0, j), state, 4);
                worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j), state, 4);
                worldIn.func_180501_a(pos.func_177982_a(i, 0, j + 1), state, 4);
                worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), state, 4);
            } else {
                worldIn.func_180501_a(pos, state, 4);
            }
        }
    }

    @Override
    public String getFeatureDescription() {
        return "Makes the bottom block of trees into stumps which cannot be removed by hand, making your mark on the world more obvious";
    }

    @Override
    public void init(FMLInitializationEvent event) {
        RecipeUtils.addShapelessOreRecipe(new ItemStack(BWMItems.STUMP_REMOVER, 2), new ItemStack(BWMItems.CREEPER_OYSTER), new ItemStack((Block)Blocks.field_150337_Q), new ItemStack(Items.field_151078_bh));
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @SubscribeEvent
    public void addStumpsToGeneratedTrees(DecorateBiomeEvent.Post event) {
        if (!event.getWorld().field_73011_w.func_76569_d()) {
            return;
        }
        for (int dx = 0; dx < 16; ++dx) {
            int x = event.getPos().func_177958_n() + dx;
            x += 8;
            for (int dz = 0; dz < 16; ++dz) {
                IBlockState stump;
                int z = event.getPos().func_177952_p() + dz;
                Chunk chunk = event.getWorld().func_175726_f(new BlockPos(x, 0, z += 8));
                int y = chunk.func_76611_b(x & 0xF, z & 0xF) - 1;
                BlockPos pos = new BlockPos(x, y, z);
                IBlockState state = event.getWorld().func_180495_p(pos);
                while (HCStumping.shouldBeSkipped(state)) {
                    pos = new BlockPos(x, --y, z);
                    state = event.getWorld().func_180495_p(pos);
                }
                if (!BlockStump.canPlaceStump(event.getWorld(), pos.func_177984_a()) || !HCStumping.canSustainTree(state) || (stump = BlockStump.getStump(event.getWorld().func_180495_p(pos.func_177984_a()))) == null) continue;
                event.getWorld().func_175656_a(pos.func_177984_a(), stump);
            }
        }
    }

    @SubscribeEvent
    public void addStumpToTree(SaplingGrowTreeEvent event) {
        IBlockState state = event.getWorld().func_180495_p(event.getPos());
        if (state.func_177230_c() != Blocks.field_150345_g) {
            return;
        }
        event.setResult(Event.Result.DENY);
        HCStumping.generateTreeWithStump(event.getWorld(), event.getPos(), state, event.getRand());
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

