/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore;

import betterwithmods.module.Feature;
import betterwithmods.util.RecipeUtils;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class HCTools
extends Feature {
    private static int woodDurability;
    private static int stoneDurability;
    private static int ironDurability;
    private static int diamondDurability;
    private static int goldDurability;
    public static boolean earlyPickaxesRebalance;
    public static boolean removeLowTools;
    private static final Set<Item> TOOLS;

    @Override
    public String getFeatureDescription() {
        return "Overhaul the durability of tools to be more rewarding when reaching the next level. Completely disables wooden tools (other than pick) by default.";
    }

    @Override
    public void setupConfig() {
        earlyPickaxesRebalance = this.loadPropBool("Early pickaxes rebalance", "Wooden Pickaxe will have 1 usage and Stone Pickaxe 6.", true);
        removeLowTools = this.loadPropBool("Remove cheapest tools", "The minimum level of the hoe and the sword is iron, and the axe needs at least stone.", true);
        woodDurability = this.loadPropInt("Hardcore Hardness Wood Durability", "Number of usages for wooden tools. Does not change Pickaxe if earlyPickaxesRebalanced is enabled", "", 1, 1, 60);
        stoneDurability = this.loadPropInt("Hardcore Hardness Stone Durability", "Number of usages for stone tools. Does not change Pickaxe if earlyPickaxesRebalanced is enabled", "", 50, 2, 132);
        ironDurability = this.loadPropInt("Hardcore Hardness Iron Durability", "Number of usages for iron tools.", "", 500, 2, 251);
        diamondDurability = this.loadPropInt("Hardcore Hardness Diamond Durability", "Number of usages for diamond tools.", "", 1561, 2, 1562);
        goldDurability = this.loadPropInt("Hardcore Hardness Gold Durability", "Number of usages for golden tools.", "", 32, 2, 33);
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (removeLowTools) {
            HCTools.removeLowTierToolRecipes();
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        HCTools.changeVanillaToolMaterials();
        if (earlyPickaxesRebalance) {
            Items.field_151039_o.func_77656_e(1);
            Items.field_151050_s.func_77656_e(5);
        }
    }

    private static void changeVanillaToolMaterials() {
        for (Item.ToolMaterial material : Item.ToolMaterial.values()) {
            ToolMaterialOverride newValues = ToolMaterialOverride.getOverride(material);
            if (newValues == null) continue;
            ReflectionHelper.setPrivateValue(Item.ToolMaterial.class, (Object)material, (Object)newValues.getMaxUses(), (String[])new String[]{"field_78002_g", "maxUses"});
            ReflectionHelper.setPrivateValue(Item.ToolMaterial.class, (Object)material, (Object)Float.valueOf(newValues.getEfficiencyOnProperMaterial()), (String[])new String[]{"field_78010_h", "efficiencyOnProperMaterial"});
            ReflectionHelper.setPrivateValue(Item.ToolMaterial.class, (Object)material, (Object)newValues.getEnchantability(), (String[])new String[]{"field_78008_j", "enchantability"});
        }
        for (Item item : TOOLS) {
            ItemTool tool;
            ToolMaterialOverride newValues;
            if (!(item instanceof ItemTool) || (newValues = ToolMaterialOverride.getOverride((tool = (ItemTool)item).func_150913_i())) == null) continue;
            tool.func_77656_e(newValues.getMaxUses());
            ReflectionHelper.setPrivateValue(ItemTool.class, (Object)tool, (Object)Float.valueOf(newValues.getEfficiencyOnProperMaterial()), (String[])new String[]{"field_77864_a", "efficiencyOnProperMaterial"});
        }
    }

    @SubscribeEvent
    public void onBreaking(BlockEvent.BreakEvent event) {
        if (!earlyPickaxesRebalance) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b() || stack.func_77973_b() == null) {
            return;
        }
        if (stack.func_77973_b() == Items.field_151039_o) {
            this.destroyItem(stack, (EntityLivingBase)player);
        }
    }

    private void destroyItem(ItemStack stack, EntityLivingBase entity) {
        int damage = stack.func_77958_k();
        stack.func_77972_a(damage, entity);
    }

    public static void removeLowTierToolRecipes() {
        RecipeUtils.removeRecipes(Items.field_151053_p, Short.MAX_VALUE);
        RecipeUtils.removeRecipes(Items.field_151017_I, Short.MAX_VALUE);
        RecipeUtils.removeRecipes(Items.field_151041_m, Short.MAX_VALUE);
        RecipeUtils.removeRecipes(Items.field_151018_J, Short.MAX_VALUE);
        RecipeUtils.removeRecipes(Items.field_151052_q, Short.MAX_VALUE);
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    static /* synthetic */ int access$000() {
        return woodDurability;
    }

    static /* synthetic */ int access$100() {
        return stoneDurability;
    }

    static /* synthetic */ int access$200() {
        return ironDurability;
    }

    static /* synthetic */ int access$300() {
        return diamondDurability;
    }

    static /* synthetic */ int access$400() {
        return goldDurability;
    }

    static {
        TOOLS = Sets.newHashSet((Object[])new Item[]{Items.field_151046_w, Items.field_151056_x, Items.field_151048_u, Items.field_151047_v, Items.field_151012_L, Items.field_151035_b, Items.field_151036_c, Items.field_151040_l, Items.field_151037_a, Items.field_151019_K, Items.field_151050_s, Items.field_151049_t, Items.field_151052_q, Items.field_151051_r, Items.field_151018_J, Items.field_151005_D, Items.field_151006_E, Items.field_151010_B, Items.field_151011_C, Items.field_151013_M, Items.field_151039_o, Items.field_151053_p, Items.field_151041_m, Items.field_151038_n, Items.field_151017_I});
    }

    private static enum ToolMaterialOverride {
        WOOD(HCTools.access$000(), 1.01f, 0),
        STONE(HCTools.access$100() - 1, 1.01f, 5),
        IRON(HCTools.access$200() - 1, 6.0f, 14),
        DIAMOND(HCTools.access$300() - 1, 8.0f, 14),
        GOLD(HCTools.access$400() - 1, 12.0f, 22);

        private final int maxUses;
        private final float efficiencyOnProperMaterial;
        private final int enchantability;

        private ToolMaterialOverride(int maxUses, float efficiency, int enchantability) {
            this.maxUses = maxUses;
            this.efficiencyOnProperMaterial = efficiency;
            this.enchantability = enchantability;
        }

        public static ToolMaterialOverride getOverride(Item.ToolMaterial material) {
            switch (material) {
                case WOOD: {
                    return WOOD;
                }
                case STONE: {
                    return STONE;
                }
                case IRON: {
                    return IRON;
                }
                case DIAMOND: {
                    return DIAMOND;
                }
                case GOLD: {
                    return GOLD;
                }
            }
            return null;
        }

        public int getMaxUses() {
            return this.maxUses;
        }

        public float getEfficiencyOnProperMaterial() {
            return this.efficiencyOnProperMaterial;
        }

        public int getEnchantability() {
            return this.enchantability;
        }
    }
}

