/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.world.BWMapGenVillage;
import betterwithmods.common.world.gen.village.Blacksmiths;
import betterwithmods.common.world.gen.village.Butchery;
import betterwithmods.common.world.gen.village.Church;
import betterwithmods.common.world.gen.village.House;
import betterwithmods.common.world.gen.village.Hut;
import betterwithmods.common.world.gen.village.Hut2;
import betterwithmods.common.world.gen.village.Library;
import betterwithmods.common.world.gen.village.Well;
import betterwithmods.common.world.gen.village.field.BWField1;
import betterwithmods.common.world.gen.village.field.BWField2;
import betterwithmods.module.Feature;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class HCVillages
extends Feature {
    public static AtomicInteger semiabandonedRadius = new AtomicInteger();
    public static AtomicInteger normalRadius = new AtomicInteger();
    public static boolean disableAllComplexBlocks;
    public static boolean disableVillagerSpawning;

    @Override
    public String getFeatureDescription() {
        return "Makes it so villages with in the reaches of the spawn zone are abandoned and gradually gain more resources the further out. What this means to be gained by the player.";
    }

    @Override
    public void setupConfig() {
        semiabandonedRadius.set(this.loadPropInt("Semi-Abandoned Village Radius", "Block radius from 0,0 at which villages are now semi-abandoned, all villages inside this radius are abandoned", 2000));
        normalRadius.set(this.loadPropInt("Normal Village Radius", "Block radius from 0,0 at which villages are now normal, all villages in between this and semi-abandoned are semi-abandoned", 3000));
        disableAllComplexBlocks = this.loadPropBool("Disable All Complex Blocks", "Removes any and all useful blocks from villages, including ladders, stairs, tables and more", false);
        disableVillagerSpawning = this.loadPropBool("Replace Villager Spawning with Nitwits", "Replaces all villager spawns with Nitwits, which have no trades", true);
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public void init(FMLInitializationEvent event) {
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new BWField1());
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new BWField2());
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new Butchery());
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new Blacksmiths());
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new Church());
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new House());
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new Hut());
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new Hut2());
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new Library());
        MapGenStructureIO.func_143034_b(BWMapGenVillage.AbandonedStart.class, (String)new ResourceLocation("betterwithmods", "BWAbandonedStart").toString());
        MapGenStructureIO.func_143031_a(BWField1.class, (String)new ResourceLocation("betterwithmods", "BWField1").toString());
        MapGenStructureIO.func_143031_a(BWField2.class, (String)new ResourceLocation("betterwithmods", "BWField2").toString());
        MapGenStructureIO.func_143031_a(Blacksmiths.class, (String)new ResourceLocation("betterwithmods", "Blacksmiths").toString());
        MapGenStructureIO.func_143031_a(Butchery.class, (String)new ResourceLocation("betterwithmods", "Butchery").toString());
        MapGenStructureIO.func_143031_a(Church.class, (String)new ResourceLocation("betterwithmods", "Church").toString());
        MapGenStructureIO.func_143031_a(House.class, (String)new ResourceLocation("betterwithmods", "House").toString());
        MapGenStructureIO.func_143031_a(Hut.class, (String)new ResourceLocation("betterwithmods", "Hut").toString());
        MapGenStructureIO.func_143031_a(Hut2.class, (String)new ResourceLocation("betterwithmods", "Hut2").toString());
        MapGenStructureIO.func_143031_a(Library.class, (String)new ResourceLocation("betterwithmods", "Library").toString());
        MapGenStructureIO.func_143031_a(Well.class, (String)new ResourceLocation("betterwithmods", "Well").toString());
    }

    @SubscribeEvent
    public void biomeSpecificVillage(BiomeEvent.GetVillageBlockID event) {
        if (event.getOriginal() == BWMBlocks.WOOD_TABLE.func_176223_P()) {
            event.setReplacement(event.getOriginal().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)this.plankFromBiome(event.getBiome())));
        }
        if (event.getOriginal() == Blocks.field_150346_d && BiomeDictionary.hasType((Biome)event.getBiome(), (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
            event.setReplacement(Blocks.field_150354_m.func_176223_P());
        }
    }

    public BlockPlanks.EnumType plankFromBiome(Biome biome) {
        if (biome == null) {
            return BlockPlanks.EnumType.OAK;
        }
        if (BiomeDictionary.areSimilar((Biome)biome, (Biome)Biomes.field_76768_g)) {
            return BlockPlanks.EnumType.SPRUCE;
        }
        if (BiomeDictionary.areSimilar((Biome)biome, (Biome)Biomes.field_76767_f)) {
            return BlockPlanks.EnumType.OAK;
        }
        if (BiomeDictionary.areSimilar((Biome)biome, (Biome)Biomes.field_150585_R)) {
            return BlockPlanks.EnumType.OAK;
        }
        if (BiomeDictionary.areSimilar((Biome)biome, (Biome)Biomes.field_76782_w)) {
            return BlockPlanks.EnumType.JUNGLE;
        }
        if (BiomeDictionary.areSimilar((Biome)biome, (Biome)Biomes.field_150583_P)) {
            return BlockPlanks.EnumType.BIRCH;
        }
        if (BiomeDictionary.areSimilar((Biome)biome, (Biome)Biomes.field_150588_X) || BiomeDictionary.areSimilar((Biome)biome, (Biome)Biomes.field_76769_d)) {
            return BlockPlanks.EnumType.ACACIA;
        }
        return BlockPlanks.EnumType.OAK;
    }

    @SubscribeEvent
    public void onGenerate(InitMapGenEvent event) {
        if (event.getType() == InitMapGenEvent.EventType.VILLAGE) {
            event.setNewGen((MapGenBase)new BWMapGenVillage());
        }
    }

    @Override
    public boolean hasTerrainSubscriptions() {
        return true;
    }
}

