/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.hchunger;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.BlockCake;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import squeek.applecore.api.food.FoodValues;

public class FoodHelper {
    private static final HashMap<ItemStack, FoodValues> FOOD_VALUES = Maps.newHashMap();

    public static HashMap<ItemStack, FoodValues> getFoodValues() {
        return FOOD_VALUES;
    }

    protected static boolean isDessert(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            return ((ItemBlock)stack.func_77973_b()).func_179223_d() instanceof BlockCake;
        }
        if (stack.func_77973_b() instanceof ItemFood) {
            ItemFood food = (ItemFood)stack.func_77973_b();
            return (Boolean)ReflectionHelper.getPrivateValue(ItemFood.class, (Object)food, (int)4);
        }
        return false;
    }

    protected static Optional<FoodValues> getFoodValue(ItemStack stack) {
        return FOOD_VALUES.entrySet().stream().filter(entry -> FoodHelper.match((ItemStack)entry.getKey(), stack)).map(Map.Entry::getValue).findFirst();
    }

    public static void registerFood(ItemStack item, int hunger) {
        FoodHelper.registerFood(item, hunger, 0);
    }

    public static void registerFood(ItemStack stack, int hunger, int saturation) {
        FoodHelper.registerFood(stack, hunger, saturation, false);
    }

    public static void registerFood(ItemStack stack, int hunger, int saturation, boolean alwaysEdible) {
        FoodHelper.registerFood(stack, new FoodValues(hunger, (float)saturation), alwaysEdible);
    }

    protected static void registerFood(ItemStack stack, FoodValues values) {
        FoodHelper.registerFood(stack, values, false);
    }

    public static void registerFood(ItemStack stack, FoodValues values, boolean alwaysEdible) {
        if (alwaysEdible) {
            FoodHelper.setAlwaysEdible(stack);
        }
        FOOD_VALUES.put(stack, values);
    }

    public static void setAlwaysEdible(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemFood) {
            ItemFood food = (ItemFood)stack.func_77973_b();
            food.func_77848_i();
        }
    }

    protected static boolean match(ItemStack a, ItemStack b) {
        return a.func_77973_b().equals(b.func_77973_b()) && (a.func_77960_j() == b.func_77960_j() || a.func_77960_j() == Short.MAX_VALUE || b.func_77960_j() == Short.MAX_VALUE);
    }
}

