/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.hchunger;

import betterwithmods.client.gui.GuiHunger;
import betterwithmods.common.BWMItems;
import betterwithmods.common.blocks.BlockRawPastry;
import betterwithmods.module.CompatFeature;
import betterwithmods.module.gameplay.CauldronRecipes;
import betterwithmods.module.gameplay.KilnRecipes;
import betterwithmods.module.hardcore.hchunger.FoodHelper;
import betterwithmods.network.MessageGuiShake;
import betterwithmods.network.NetworkHandler;
import betterwithmods.util.RecipeUtils;
import betterwithmods.util.player.FatPenalty;
import betterwithmods.util.player.HungerPenalty;
import betterwithmods.util.player.PlayerHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSoup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.FoodStats;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.api.food.FoodEvent;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.hunger.ExhaustionEvent;
import squeek.applecore.api.hunger.HealthRegenEvent;
import squeek.applecore.api.hunger.HungerEvent;

public class HCHunger
extends CompatFeature {
    public HCHunger() {
        super("applecore");
        this.configName = "HCHunger";
    }

    @Override
    public void init(FMLInitializationEvent event) {
        FoodHelper.registerFood(new ItemStack(Items.field_151147_al), 12);
        FoodHelper.registerFood(new ItemStack(Items.field_179558_bo), 12);
        FoodHelper.registerFood(new ItemStack(Items.field_151076_bf), 9);
        FoodHelper.registerFood(new ItemStack(Items.field_179561_bm), 9);
        FoodHelper.registerFood(new ItemStack(Items.field_151115_aP), 9);
        FoodHelper.registerFood(new ItemStack(Items.field_151083_be), 15);
        FoodHelper.registerFood(new ItemStack(Items.field_151157_am), 15);
        FoodHelper.registerFood(new ItemStack(Items.field_179559_bp), 15);
        FoodHelper.registerFood(new ItemStack(Items.field_151077_bg), 12);
        FoodHelper.registerFood(new ItemStack(Items.field_179557_bn), 12);
        FoodHelper.registerFood(new ItemStack(Items.field_179566_aV), 12);
        FoodHelper.registerFood(new ItemStack(Items.field_151070_bp), 6);
        FoodHelper.registerFood(new ItemStack(Items.field_151078_bh), 9);
        FoodHelper.registerFood(new ItemStack(Items.field_151009_A), 9);
        FoodHelper.registerFood(new ItemStack(Items.field_185165_cW), 9);
        FoodHelper.registerFood(new ItemStack(Items.field_179560_bq), 30);
        FoodHelper.registerFood(new ItemStack(Items.field_151127_ba), 2);
        FoodHelper.registerFood(new ItemStack(Items.field_151034_e), 3);
        FoodHelper.registerFood(new ItemStack(Items.field_151174_bG), 3);
        FoodHelper.registerFood(new ItemStack(Items.field_151172_bF), 3);
        FoodHelper.registerFood(new ItemStack(Items.field_185164_cV), 3);
        FoodHelper.registerFood(new ItemStack(Items.field_151168_bH), 6);
        FoodHelper.registerFood(new ItemStack(Items.field_151025_P), 12);
        FoodHelper.registerFood(new ItemStack(Items.field_151153_ao), 3);
        FoodHelper.registerFood(new ItemStack(Items.field_151150_bK), 3);
        FoodHelper.registerFood(new ItemStack(BWMItems.BEEF_DINNER), 24);
        FoodHelper.registerFood(new ItemStack(BWMItems.BEEF_POTATOES), 18);
        FoodHelper.registerFood(new ItemStack(BWMItems.RAW_KEBAB), 18);
        FoodHelper.registerFood(new ItemStack(BWMItems.COOKED_KEBAB), 24);
        FoodHelper.registerFood(new ItemStack(BWMItems.CHICKEN_SOUP), 24);
        FoodHelper.registerFood(new ItemStack(BWMItems.CHOWDER), 15);
        FoodHelper.registerFood(new ItemStack(BWMItems.HEARTY_STEW), 30);
        FoodHelper.registerFood(new ItemStack(BWMItems.PORK_DINNER), 24);
        FoodHelper.registerFood(new ItemStack(BWMItems.RAW_EGG), 6);
        FoodHelper.registerFood(new ItemStack(BWMItems.COOKED_EGG), 9);
        FoodHelper.registerFood(new ItemStack(BWMItems.RAW_SCRAMBLED_EGG), 12);
        FoodHelper.registerFood(new ItemStack(BWMItems.COOKED_SCRAMBLED_EGG), 15);
        FoodHelper.registerFood(new ItemStack(BWMItems.RAW_OMELET), 9);
        FoodHelper.registerFood(new ItemStack(BWMItems.COOKED_OMELET), 12);
        FoodHelper.registerFood(new ItemStack(BWMItems.HAM_AND_EGGS), 18);
        FoodHelper.registerFood(new ItemStack(BWMItems.TASTY_SANDWICH), 18);
        FoodHelper.registerFood(new ItemStack(BWMItems.CREEPER_OYSTER), 6);
        FoodHelper.registerFood(new ItemStack(BWMItems.KIBBLE), 9);
        FoodHelper.registerFood(new ItemStack(BWMItems.WOLF_CHOP), 12);
        FoodHelper.registerFood(new ItemStack(BWMItems.COOKED_WOLF_CHOP), 15);
        FoodHelper.registerFood(new ItemStack(BWMItems.MYSTERY_MEAT), 9);
        FoodHelper.registerFood(new ItemStack(BWMItems.COOKED_MYSTERY_MEAT), 12);
        FoodHelper.registerFood(new ItemStack(BWMItems.DONUT), 3, 3, true);
        FoodHelper.registerFood(new ItemStack(BWMItems.APPLE_PIE), 12, 15, true);
        FoodHelper.registerFood(new ItemStack(Items.field_151106_aX), 3, 1, true);
        FoodHelper.registerFood(new ItemStack(Items.field_151158_bO), 12, 15, true);
        FoodHelper.registerFood(new ItemStack(BWMItems.CHOCOLATE), 6, 3, true);
        RecipeUtils.removeRecipes(Items.field_151009_A, 0);
        RecipeUtils.removeRecipes(Items.field_151105_aU, 0);
        RecipeUtils.removeRecipes(Items.field_151106_aX, 0);
        RecipeUtils.removeRecipes(Items.field_151158_bO, 0);
        RecipeUtils.removeRecipes(Items.field_179560_bq, 0);
        RecipeUtils.removeRecipes(Items.field_185165_cW, 0);
        GameRegistry.addSmelting((ItemStack)BlockRawPastry.getStack(BlockRawPastry.EnumType.COOKIE), (ItemStack)new ItemStack(Items.field_151106_aX, 8), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)BlockRawPastry.getStack(BlockRawPastry.EnumType.PUMPKIN), (ItemStack)new ItemStack(Items.field_151158_bO, 1), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)BlockRawPastry.getStack(BlockRawPastry.EnumType.APPLE), (ItemStack)new ItemStack(BWMItems.APPLE_PIE, 1), (float)0.1f);
        KilnRecipes.addKilnRecipe(BlockRawPastry.getStack(BlockRawPastry.EnumType.COOKIE), new ItemStack(Items.field_151106_aX, 8));
        KilnRecipes.addKilnRecipe(BlockRawPastry.getStack(BlockRawPastry.EnumType.PUMPKIN), new ItemStack(Items.field_151158_bO, 1));
        KilnRecipes.addKilnRecipe(BlockRawPastry.getStack(BlockRawPastry.EnumType.APPLE), new ItemStack(BWMItems.APPLE_PIE, 1));
        CauldronRecipes.addCauldronRecipe(new ItemStack(Items.field_151009_A), new ItemStack(Items.field_151133_ar), new Object[]{new ItemStack((Block)Blocks.field_150338_P, 3), new ItemStack(Items.field_151117_aB), new ItemStack(Items.field_151054_z)});
        CauldronRecipes.addCauldronRecipe(new ItemStack(Items.field_185165_cW), new Object[]{new ItemStack(Items.field_185164_cV, 6), new ItemStack(Items.field_151054_z)});
        CauldronRecipes.addCauldronRecipe(new ItemStack(Items.field_179560_bq, 5), new Object[]{Items.field_179559_bp, Items.field_151172_bF, Items.field_151168_bH, new ItemStack(Items.field_151054_z, 5), new ItemStack((Block)Blocks.field_150337_Q, 3), "foodFlour"});
    }

    @Override
    public void disabledInit(FMLInitializationEvent event) {
        GameRegistry.addSmelting((ItemStack)BlockRawPastry.getStack(BlockRawPastry.EnumType.COOKIE), (ItemStack)new ItemStack(Items.field_151106_aX, 16), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)BlockRawPastry.getStack(BlockRawPastry.EnumType.PUMPKIN), (ItemStack)new ItemStack(Items.field_151158_bO, 2), (float)0.1f);
        KilnRecipes.addKilnRecipe(BlockRawPastry.getStack(BlockRawPastry.EnumType.COOKIE), new ItemStack(Items.field_151106_aX, 16));
        KilnRecipes.addKilnRecipe(BlockRawPastry.getStack(BlockRawPastry.EnumType.PUMPKIN), new ItemStack(Items.field_151158_bO, 2));
    }

    @Override
    public void preInitClient(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register(ClientSide.class);
        super.preInitClient(event);
    }

    @SubscribeEvent
    public void respawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.isEndConquered()) {
            return;
        }
        if (event.player != null) {
            AppleCoreAPI.mutator.setSaturation(event.player, 0.0f);
            AppleCoreAPI.mutator.setHunger(event.player, AppleCoreAPI.accessor.getMaxHunger(event.player));
        }
    }

    @SubscribeEvent
    public void modifyFoodValues(FoodEvent.GetFoodValues event) {
        FoodHelper.getFoodValue(event.food).ifPresent(v -> {
            event.foodValues = v;
        });
    }

    @SubscribeEvent
    public void onFood(LivingEntityUseItemEvent.Start event) {
        if (event.getItem().func_77973_b() instanceof ItemFood && event.getEntityLiving() instanceof EntityPlayer && PlayerHelper.isSurvival((EntityPlayer)event.getEntityLiving()) && event.getEntityLiving().func_70644_a(MobEffects.field_76438_s)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void getPlayerFoodValue(FoodEvent.GetPlayerFoodValues event) {
        FoodStats stats = event.player.func_71024_bL();
        int playerFoodLevel = stats.func_75116_a();
        int foodLevel = event.foodValues.hunger;
        float fat = foodLevel + playerFoodLevel - AppleCoreAPI.accessor.getMaxHunger(event.player);
        if (!FoodHelper.isDessert(event.food)) {
            event.foodValues = fat < 0.0f ? new FoodValues(foodLevel, 0.0f) : new FoodValues(foodLevel, fat / 60.0f);
        }
    }

    @SubscribeEvent
    public void exhaust(ExhaustionEvent.Exhausted event) {
        FoodStats stats = event.player.func_71024_bL();
        float saturation = stats.func_75115_e();
        int hunger = stats.func_75116_a();
        if ((float)hunger > saturation) {
            event.deltaSaturation = 0.0f;
            event.deltaHunger = -1;
        } else {
            event.deltaSaturation = -1.0f;
            event.deltaHunger = 0;
        }
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (!PlayerHelper.canJump(player)) {
                event.getEntityLiving().field_70159_w = 0.0;
                event.getEntityLiving().field_70181_x = 0.0;
                event.getEntityLiving().field_70179_y = 0.0;
            }
            player.func_71020_j(0.09f);
        }
    }

    @SubscribeEvent
    public void setMaxFood(HungerEvent.GetMaxHunger event) {
        event.maxHunger = 60;
    }

    @SubscribeEvent
    public void givePenalties(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            PlayerHelper.changeSpeed((EntityLivingBase)player, "Hunger Speed Modifier", PlayerHelper.getSpeedModifier(player));
        }
    }

    @SubscribeEvent
    public void allowHealthRegen(HealthRegenEvent.AllowRegen event) {
        event.setResult(PlayerHelper.getHungerPenalty(event.player) == HungerPenalty.NO_PENALTY ? Event.Result.ALLOW : Event.Result.DENY);
    }

    @SubscribeEvent
    public void healthRegenSpeed(HealthRegenEvent.GetRegenTickPeriod event) {
        event.regenTickPeriod = 600;
    }

    @SubscribeEvent
    public void denyFatRegen(HealthRegenEvent.AllowSaturatedRegen event) {
        event.setResult(Event.Result.DENY);
    }

    @SubscribeEvent
    public void onExhaust(ExhaustionEvent.ExhaustionAddition event) {
        if (event.player.field_70170_p.func_82737_E() % 20L == 0L && (double)event.deltaExhaustion > 0.05) {
            NetworkHandler.INSTANCE.sendTo((IMessage)new MessageGuiShake(), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void saveSoup(LivingEntityUseItemEvent.Finish event) {
        if (event.getItem() != null && event.getItem().func_77973_b() instanceof ItemSoup && event.getItem().func_190916_E() > 0) {
            ItemStack result = event.getResultStack();
            event.setResultStack(event.getItem());
            if (event.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                if (!player.field_71071_by.func_70441_a(result)) {
                    player.func_71019_a(result, false);
                }
            }
        }
    }

    @Override
    public String getFeatureDescription() {
        return "Completely revamps the hunger system of Minecraft. \nThe Saturation value is replaced with Fat. \nFat will accumulate if too much food is consumed then need to fill the bar.\nFat will only be burned once the entire hunger bar is emptied \nThe more fat the slower you will walk.\nFood Items values are also changed, while a ton of new foods are add.";
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClientSide {
        @SubscribeEvent
        public static void replaceHungerGui(RenderGameOverlayEvent.Pre event) {
            if (event.getType() == RenderGameOverlayEvent.ElementType.FOOD) {
                event.setCanceled(true);
                GuiHunger.INSTANCE.draw();
            }
        }

        private static RenderPlayer getRenderPlayer(AbstractClientPlayer player) {
            Minecraft mc = Minecraft.func_71410_x();
            RenderManager manager = mc.func_175598_ae();
            return (RenderPlayer)manager.getSkinMap().get(player.func_175154_l());
        }

        private static ModelBiped getPlayerModel(AbstractClientPlayer player) {
            return ClientSide.getRenderPlayer(player).func_177087_b();
        }

        public static void putFat(AbstractClientPlayer player, FatPenalty fat) {
            ModelBiped model = ClientSide.getPlayerModel(player);
            float scale = fat != FatPenalty.NO_PENALTY ? Math.max(0.0f, (float)fat.ordinal() / 4.0f) : 0.0f;
            model.field_78115_e = new ModelRenderer((ModelBase)model, 16, 16);
            model.field_78115_e.func_78790_a(-4.0f, 0.0f, -2.0f, 8, 12, 4, scale);
        }

        public static void doFat(String playerName) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            EntityPlayer player = world.func_72924_a(playerName);
            FatPenalty fat = PlayerHelper.getFatPenalty(player);
            if (player != null && player instanceof AbstractClientPlayer) {
                ClientSide.putFat((AbstractClientPlayer)player, fat);
            }
        }
    }
}

