/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.tweaks;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.blocks.BlockAesthetic;
import betterwithmods.module.Feature;
import betterwithmods.util.player.PlayerHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HeadDrops
extends Feature {
    private int sawHeadDropChance;
    private int battleAxeHeadDropChance;

    @Override
    public void setupConfig() {
        this.sawHeadDropChance = this.loadPropInt("Saw Drop Chance", "Chance for extra drops from Mobs dying on a Saw. 0 disables it entirely", 3);
        this.battleAxeHeadDropChance = this.loadPropInt("BattleAxe Drop Chance", "Chance for extra drops from Mobs dying from a BattleAxe. 0 disables it entirely", 3);
    }

    @Override
    public String getFeatureDescription() {
        return "Heads and Skulls can drop from death by Saw or BattleAxe";
    }

    @SubscribeEvent
    public void onLivingDrop(LivingDropsEvent evt) {
        BlockPos pos = evt.getEntityLiving().func_180425_c().func_177977_b();
        World world = evt.getEntityLiving().func_130014_f_();
        if (this.isChoppingBlock(world, pos)) {
            this.addHead(evt, this.sawHeadDropChance);
        }
        if (this.isBattleAxe(evt.getEntityLiving())) {
            this.addHead(evt, this.battleAxeHeadDropChance);
        }
    }

    private boolean isChoppingBlock(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() == BWMBlocks.AESTHETIC) {
            IBlockState state = world.func_180495_p(pos);
            return state.func_177229_b(BlockAesthetic.blockType) == BlockAesthetic.EnumType.CHOPBLOCK || state.func_177229_b(BlockAesthetic.blockType) == BlockAesthetic.EnumType.CHOPBLOCKBLOOD;
        }
        return false;
    }

    private boolean isBattleAxe(EntityLivingBase entity) {
        ItemStack held;
        Entity e;
        DamageSource source = entity.func_189748_bU();
        return source != null && source.func_76364_f() != null && (e = source.func_76364_f()) instanceof EntityLivingBase && !(held = ((EntityLivingBase)e).func_184614_ca()).func_190926_b() && held.func_77969_a(new ItemStack(BWMItems.STEEL_BATTLEAXE));
    }

    public void addDrop(LivingDropsEvent evt, ItemStack drop) {
        EntityItem item = new EntityItem(evt.getEntityLiving().func_130014_f_(), evt.getEntityLiving().field_70165_t, evt.getEntityLiving().field_70163_u, evt.getEntityLiving().field_70161_v, drop);
        item.func_174869_p();
        evt.getDrops().add(item);
    }

    public void addHead(LivingDropsEvent evt, int chance) {
        if (chance == 0 || evt.getEntity().func_130014_f_().field_73012_v.nextInt(chance) != 0) {
            return;
        }
        if (evt.getEntityLiving() instanceof EntitySkeleton) {
            this.addDrop(evt, new ItemStack(Items.field_151144_bL, 1, 0));
        } else if (evt.getEntityLiving() instanceof EntityWitherSkeleton) {
            this.addDrop(evt, new ItemStack(Items.field_151144_bL, 1, 1));
        } else if (evt.getEntityLiving() instanceof EntityZombie) {
            this.addDrop(evt, new ItemStack(Items.field_151144_bL, 1, 2));
        } else if (evt.getEntityLiving() instanceof EntityCreeper) {
            this.addDrop(evt, new ItemStack(Items.field_151144_bL, 1, 4));
        } else if (evt.getEntityLiving() instanceof EntityPlayer) {
            this.addDrop(evt, PlayerHelper.getPlayerHead((EntityPlayer)evt.getEntityLiving()));
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

