/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.tweaks;

import betterwithmods.module.Feature;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MobSpawning
extends Feature {
    private boolean slime;
    private boolean nether;

    @Override
    public void init(FMLInitializationEvent event) {
        if (this.nether) {
            NetherSpawnWhitelist.addBlock(Blocks.field_150424_aL);
            NetherSpawnWhitelist.addBlock(Blocks.field_150385_bj);
            NetherSpawnWhitelist.addBlock(Blocks.field_150425_aM);
            NetherSpawnWhitelist.addBlock(Blocks.field_150351_n);
            NetherSpawnWhitelist.addBlock(Blocks.field_150371_ca);
        }
    }

    @Override
    public String getFeatureDescription() {
        return "Nether Mobs can only spawn on nether blocks and Slimes can only spawn on natural blocks";
    }

    @Override
    public void setupConfig() {
        this.slime = this.loadPropBool("Limit Slime Spawning", "Slimes can only spawn on natural blocks", true);
        this.nether = this.loadPropBool("Limit Nether Spawning", "Nether Mobs can only spawn on nether blocks", true);
    }

    @SubscribeEvent
    public void denySlimeSpawns(LivingSpawnEvent.CheckSpawn evt) {
        if (evt.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (!this.slime) {
            return;
        }
        if (evt.getWorld() != null && evt.getWorld().field_73011_w.func_186058_p() == DimensionType.OVERWORLD && evt.getEntityLiving() instanceof EntitySlime) {
            BlockPos pos = new BlockPos(evt.getEntity().field_70165_t, evt.getEntity().field_70163_u - 1.0, evt.getEntity().field_70161_v);
            if (evt.getWorld().func_180495_p(pos).func_185904_a() != Material.field_151577_b && evt.getWorld().func_180495_p(pos).func_185904_a() != Material.field_151576_e && evt.getWorld().func_180495_p(pos).func_185904_a() != Material.field_151578_c) {
                evt.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void denyNetherSpawns(LivingSpawnEvent.CheckSpawn evt) {
        if (evt.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (!this.nether) {
            return;
        }
        if (evt.getWorld() != null && evt.getWorld().field_73011_w.getDimension() == -1 && evt.getEntityLiving().isCreatureType(EnumCreatureType.MONSTER, false)) {
            double monX = evt.getEntity().field_70165_t;
            double monY = evt.getEntity().field_70163_u;
            double monZ = evt.getEntity().field_70161_v;
            int x = MathHelper.func_76128_c((double)monX);
            int y = MathHelper.func_76128_c((double)monY);
            int z = MathHelper.func_76128_c((double)monZ);
            BlockPos pos = new BlockPos(x, y - 1, z);
            Block block = evt.getWorld().func_180495_p(pos).func_177230_c();
            int meta = evt.getWorld().func_180495_p(pos).func_177230_c().func_176201_c(evt.getWorld().func_180495_p(pos));
            if (!evt.getWorld().func_175623_d(pos) && !NetherSpawnWhitelist.contains(block, meta)) {
                evt.setResult(Event.Result.DENY);
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return super.hasSubscriptions();
    }

    public static class NetherSpawnWhitelist {
        private static final ArrayList<String> whitelist = new ArrayList();

        public static void addBlock(Block block) {
            for (int i = 0; i < 16; ++i) {
                whitelist.add(block + ":" + i);
            }
        }

        public static void addBlock(Block block, int meta) {
            whitelist.add(block + ":" + meta);
        }

        public static void addBlock(ItemStack stack) {
            if (stack.func_77973_b() instanceof ItemBlock) {
                NetherSpawnWhitelist.addBlock(((ItemBlock)stack.func_77973_b()).func_179223_d(), stack.func_77960_j());
            }
        }

        public static boolean contains(Block block, int meta) {
            return whitelist.contains(block + ":" + meta);
        }

        public static void remove(Block block, int meta) {
            if (whitelist.contains(block + ":" + meta)) {
                whitelist.remove(block + ":" + meta);
            }
        }
    }
}

