/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.network;

import betterwithmods.BWMod;
import betterwithmods.module.ModuleLoader;
import betterwithmods.module.hardcore.Hardcore;
import betterwithmods.network.MessageSyncModule;
import betterwithmods.network.NetworkHandler;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModuleSync {
    @SideOnly(value=Side.CLIENT)
    private static boolean requiresRestart;

    public static void syncConfig(List<ConfigCategory> categories) {
        requiresRestart = false;
        boolean changed = false;
        BWMod.logger.info("Syncing Config with Server");
        for (ConfigCategory serverCategory : categories) {
            if (serverCategory.getName().equals("cosmetic")) continue;
            ConfigCategory category = ModuleLoader.config.getCategory(serverCategory.getName());
            for (Map.Entry entry : serverCategory.entrySet()) {
                String name = (String)entry.getKey();
                Property serverProp = (Property)entry.getValue();
                Property prop = category.get(name);
                if (prop == null) {
                    category.put(name, serverProp);
                    continue;
                }
                if (prop.getString().equals(serverProp.getString())) continue;
                prop.setValue(serverProp.getString());
                requiresRestart |= prop.requiresMcRestart();
                changed = true;
                BWMod.logger.debug("Syncing %s - %s: %s", new Object[]{category.getName(), prop.getName(), prop.getString()});
            }
        }
        if (ModuleLoader.config.hasChanged()) {
            ModuleLoader.config.save();
        }
        if (changed) {
            MinecraftForge.EVENT_BUS.register((Object)new ModuleSync());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent evt) {
        if (evt.player == null || !(evt.player instanceof EntityPlayerMP) || FMLCommonHandler.instance().getSide().isClient()) {
            return;
        }
        MessageSyncModule pkt = new MessageSyncModule();
        pkt.categories.add(ModuleLoader.config.getCategory(Hardcore.class.getSimpleName().toLowerCase()));
        NetworkHandler.INSTANCE.sendTo((IMessage)pkt, (EntityPlayerMP)evt.player);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void playerJoinedWorld(TickEvent.ClientTickEvent evt) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (requiresRestart) {
            player.func_145747_a((ITextComponent)new TextComponentString("[Better With Mods] " + I18n.func_135052_a((String)"config.sync.restart", (Object[])new Object[0])));
        } else {
            player.func_145747_a((ITextComponent)new TextComponentString("[Better With Mods] " + I18n.func_135052_a((String)"config.sync.ok", (Object[])new Object[0])));
        }
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }
}

