/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.proxy;

import betterwithmods.client.BWStateMapper;
import betterwithmods.client.ClientEventHandler;
import betterwithmods.client.ColorHandlers;
import betterwithmods.client.model.ModelKiln;
import betterwithmods.client.model.TESRCookingPot;
import betterwithmods.client.model.TESRFilteredHopper;
import betterwithmods.client.model.TESRStake;
import betterwithmods.client.model.TESRTurntable;
import betterwithmods.client.model.TESRVerticalWindmill;
import betterwithmods.client.model.TESRWaterwheel;
import betterwithmods.client.model.TESRWindmill;
import betterwithmods.client.model.render.RenderUtils;
import betterwithmods.client.render.RenderBroadheadArrow;
import betterwithmods.client.render.RenderCowHarness;
import betterwithmods.client.render.RenderExtendingRope;
import betterwithmods.client.render.RenderMiningCharge;
import betterwithmods.client.render.RenderPigHarness;
import betterwithmods.client.render.RenderShearedCreeper;
import betterwithmods.client.render.RenderSheepHarness;
import betterwithmods.client.render.RenderUrn;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.blocks.tile.TileEntityCauldron;
import betterwithmods.common.blocks.tile.TileEntityCrucible;
import betterwithmods.common.blocks.tile.TileEntityFilteredHopper;
import betterwithmods.common.blocks.tile.TileEntityTurntable;
import betterwithmods.common.blocks.tile.TileStake;
import betterwithmods.common.blocks.tile.gen.TileEntityWaterwheel;
import betterwithmods.common.blocks.tile.gen.TileEntityWindmillHorizontal;
import betterwithmods.common.blocks.tile.gen.TileEntityWindmillVertical;
import betterwithmods.common.entity.EntityBroadheadArrow;
import betterwithmods.common.entity.EntityDynamite;
import betterwithmods.common.entity.EntityExtendingRope;
import betterwithmods.common.entity.EntityMiningCharge;
import betterwithmods.common.entity.EntityShearedCreeper;
import betterwithmods.common.entity.EntitySpiderWeb;
import betterwithmods.common.entity.EntityUrn;
import betterwithmods.module.ModuleLoader;
import betterwithmods.proxy.IProxy;
import javax.annotation.Nonnull;
import li.cil.manual.api.ManualAPI;
import li.cil.manual.api.prefab.manual.ResourceContentProvider;
import li.cil.manual.api.prefab.manual.TextureTabIconRenderer;
import li.cil.manual.client.manual.provider.BlockImageProvider;
import li.cil.manual.client.manual.provider.DefinitionPathProvider;
import li.cil.manual.client.manual.provider.ItemImageProvider;
import li.cil.manual.client.manual.provider.OreDictImageProvider;
import li.cil.manual.client.manual.provider.TextureImageProvider;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ClientProxy
implements IProxy {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        ModuleLoader.preInitClient(event);
        this.registerRenderInformation();
        this.initRenderers();
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        ModuleLoader.initClient(event);
        this.registerColors();
        ManualAPI.addProvider(new DefinitionPathProvider());
        ManualAPI.addProvider(new ResourceContentProvider("betterwithmods", "docs/"));
        ManualAPI.addProvider("", new TextureImageProvider());
        ManualAPI.addProvider("item", new ItemImageProvider());
        ManualAPI.addProvider("block", new BlockImageProvider());
        ManualAPI.addProvider("oredict", new OreDictImageProvider());
        ManualAPI.addTab(new TextureTabIconRenderer(new ResourceLocation("betterwithmods", "textures/gui/manual_home.png")), "bwm.manual.home", "%LANGUAGE%/index.md");
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        ModuleLoader.postInitClient(event);
    }

    private void registerRenderInformation() {
        BWMBlocks.linkBlockModels();
        BWMItems.linkItemModels();
        RenderUtils.registerFilters();
        ModelLoader.setCustomStateMapper((Block)BWMBlocks.STOKED_FLAME, (IStateMapper)new BWStateMapper(BWMBlocks.STOKED_FLAME.getRegistryName().toString()));
        ModelLoader.setCustomStateMapper((Block)BWMBlocks.WINDMILL_BLOCK, (IStateMapper)new BWStateMapper(BWMBlocks.WINDMILL_BLOCK.getRegistryName().toString()));
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelKiln.Loader());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWindmillHorizontal.class, (TileEntitySpecialRenderer)new TESRWindmill());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWindmillVertical.class, (TileEntitySpecialRenderer)new TESRVerticalWindmill());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWaterwheel.class, (TileEntitySpecialRenderer)new TESRWaterwheel());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFilteredHopper.class, (TileEntitySpecialRenderer)new TESRFilteredHopper());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTurntable.class, (TileEntitySpecialRenderer)new TESRTurntable());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCrucible.class, (TileEntitySpecialRenderer)new TESRCookingPot());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCauldron.class, (TileEntitySpecialRenderer)new TESRCookingPot());
        ClientRegistry.bindTileEntitySpecialRenderer(TileStake.class, (TileEntitySpecialRenderer)new TESRStake());
    }

    private void registerColors() {
        BlockColors col = Minecraft.func_71410_x().func_184125_al();
        col.func_186722_a(ColorHandlers.BlockPlanterColor, new Block[]{BWMBlocks.PLANTER});
        col.func_186722_a(ColorHandlers.BlockFoliageColor, new Block[]{BWMBlocks.VINE_TRAP});
        ItemColors itCol = Minecraft.func_71410_x().getItemColors();
        itCol.func_186731_a(ColorHandlers.ItemPlanterColor, new Block[]{BWMBlocks.PLANTER});
        itCol.func_186731_a(ColorHandlers.ItemFoliageColor, new Block[]{BWMBlocks.VINE_TRAP});
        col.func_186722_a((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0), new Block[]{BWMBlocks.DIRT_SLAB});
        itCol.func_186731_a((stack, tintIndex) -> {
            IBlockState iblockstate = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
            return col.func_186724_a(iblockstate, null, null, tintIndex);
        }, new Block[]{BWMBlocks.DIRT_SLAB});
    }

    private void initRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityDynamite.class, manager -> new RenderSnowball(manager, BWMItems.DYNAMITE, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityUrn.class, RenderUrn::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityMiningCharge.class, RenderMiningCharge::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityExtendingRope.class, RenderExtendingRope::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityShearedCreeper.class, RenderShearedCreeper::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityCow.class, RenderCowHarness::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityPig.class, RenderPigHarness::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySheep.class, RenderSheepHarness::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBroadheadArrow.class, RenderBroadheadArrow::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySpiderWeb.class, manager -> new RenderSnowball(manager, Item.func_150898_a((Block)Blocks.field_150321_G), Minecraft.func_71410_x().func_175599_af()));
    }

    public static class FluidStateMapper
    extends StateMapperBase
    implements ItemMeshDefinition {
        public final Fluid fluid;
        public final ModelResourceLocation location;

        public FluidStateMapper(Fluid fluid) {
            this.fluid = fluid;
            this.location = new ModelResourceLocation(new ResourceLocation("betterwithmods", "fluid_block"), fluid.getName());
        }

        @Nonnull
        protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
            return this.location;
        }

        @Nonnull
        public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
            return this.location;
        }
    }
}

