/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import betterwithmods.api.block.ITurnable;
import com.google.common.base.Predicate;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DirUtils {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    public static final PropertyDirection HORIZONTAL = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyDirection TILTING = PropertyDirection.func_177712_a((String)"facing", facing -> facing != EnumFacing.DOWN);
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool[] DIR_PROP_HORIZ = new PropertyBool[]{NORTH, SOUTH, WEST, EAST};

    public static void setEntityOrientationFacing(EntityLivingBase entity, EnumFacing side) {
        float pitch = 0.0f;
        float yaw = 0.0f;
        switch (side) {
            case UP: {
                pitch = 61.0f;
                break;
            }
            case DOWN: {
                pitch = -61.0f;
                break;
            }
            case NORTH: {
                yaw = 180.0f;
                break;
            }
            case WEST: {
                yaw = 90.0f;
                break;
            }
            case SOUTH: {
                yaw = 0.0f;
                break;
            }
            case EAST: {
                yaw = -90.0f;
            }
        }
        entity.field_70177_z = yaw;
        entity.field_70125_A = pitch;
    }

    public static EnumFacing convertEntityOrientationToFacing(EntityLivingBase entity, EnumFacing side) {
        if (entity == null) {
            return side;
        }
        float pitch = entity.field_70125_A;
        if (pitch > 60.0f) {
            return EnumFacing.UP;
        }
        if (pitch < -60.0f) {
            return EnumFacing.DOWN;
        }
        return DirUtils.convertEntityOrientationToFlatFacing(entity, side);
    }

    public static EnumFacing convertEntityOrientationToFlatFacing(EntityLivingBase entity, EnumFacing side) {
        if (entity == null) {
            return side;
        }
        return entity.func_174811_aO().func_176734_d();
    }

    public static EnumFacing convertEntityOrientationToFlatFacing(EntityLivingBase entity) {
        return entity.func_174811_aO().func_176734_d();
    }

    public static EnumFacing getOpposite(EnumFacing facing) {
        return facing.func_176734_d();
    }

    public static EnumFacing rotateFacingAroundY(EnumFacing facing, boolean reverse) {
        if (facing.ordinal() >= 2) {
            switch (facing) {
                case NORTH: {
                    facing = EnumFacing.EAST;
                    break;
                }
                case SOUTH: {
                    facing = EnumFacing.WEST;
                    break;
                }
                case WEST: {
                    facing = EnumFacing.NORTH;
                    break;
                }
                case EAST: {
                    facing = EnumFacing.SOUTH;
                    break;
                }
            }
            if (reverse) {
                facing = DirUtils.getOpposite(facing);
            }
        }
        return facing;
    }

    public static boolean rotateAroundY(ITurnable block, World world, BlockPos pos, boolean reverse) {
        IBlockState state = world.func_180495_p(pos);
        IBlockState newState = DirUtils.rotateStateAroundY(block, state, reverse);
        if (newState != state) {
            world.func_175656_a(pos, newState);
            world.func_175704_b(pos, pos);
            return true;
        }
        return false;
    }

    public static IBlockState rotateStateAroundY(ITurnable block, IBlockState state, boolean reverse) {
        EnumFacing facing = block.getFacingFromBlockState(state);
        EnumFacing newFacing = DirUtils.rotateFacingAroundY(facing, reverse);
        state = block.setFacingInBlock(state, newFacing);
        return state;
    }

    public static EnumFacing cycleFacing(EnumFacing facing, boolean reverse) {
        if (reverse) {
            switch (facing) {
                case DOWN: {
                    facing = EnumFacing.UP;
                    break;
                }
                case UP: {
                    facing = EnumFacing.NORTH;
                    break;
                }
                case NORTH: {
                    facing = EnumFacing.EAST;
                    break;
                }
                case SOUTH: {
                    facing = EnumFacing.WEST;
                    break;
                }
                case WEST: {
                    facing = EnumFacing.DOWN;
                    break;
                }
                case EAST: {
                    facing = EnumFacing.SOUTH;
                }
            }
        } else {
            switch (facing) {
                case DOWN: {
                    facing = EnumFacing.WEST;
                    break;
                }
                case UP: {
                    facing = EnumFacing.DOWN;
                    break;
                }
                case NORTH: {
                    facing = EnumFacing.UP;
                    break;
                }
                case SOUTH: {
                    facing = EnumFacing.EAST;
                    break;
                }
                case WEST: {
                    facing = EnumFacing.SOUTH;
                    break;
                }
                case EAST: {
                    facing = EnumFacing.NORTH;
                }
            }
        }
        return facing;
    }

    public static BlockPos movePos(BlockPos source, EnumFacing facing) {
        return source.func_177971_a(facing.func_176730_m());
    }

    public static EnumFacing.Axis getNextAxis(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return EnumFacing.Axis.Y;
            }
            case Y: {
                return EnumFacing.Axis.Z;
            }
        }
        return EnumFacing.Axis.X;
    }

    public static int getLegacyAxis(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return 2;
            }
            case Y: {
                return 0;
            }
        }
        return 1;
    }

    public static EnumFacing.Axis getAxisFromLegacy(int axis) {
        switch (axis) {
            case 0: {
                return EnumFacing.Axis.Y;
            }
            case 1: {
                return EnumFacing.Axis.Z;
            }
        }
        return EnumFacing.Axis.X;
    }
}

