/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class InvUtils {
    public static <T> NonNullList<T> asNonnullList(T ... array) {
        NonNullList nonNullList = NonNullList.func_191196_a();
        if (array != null) {
            nonNullList.addAll((Collection)Arrays.stream(array).filter(e -> e != null).collect(Collectors.toList()));
        }
        return nonNullList;
    }

    public static <T> NonNullList<T> asNonnullList(List<T> list) {
        NonNullList nonNullList = NonNullList.func_191196_a();
        if (list != null) {
            nonNullList.addAll((Collection)list.stream().filter(e -> e != null).collect(Collectors.toList()));
        }
        return nonNullList;
    }

    public static boolean usePlayerItemStrict(EntityPlayer player, EnumFacing inv, ItemStack stack, int amount) {
        IItemHandlerModifiable inventory = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, inv);
        if (inventory != null) {
            return InvUtils.consumeItemsInInventoryStrict(inventory, stack, amount, false);
        }
        return false;
    }

    public static boolean usePlayerItem(EntityPlayer player, EnumFacing inv, ItemStack stack, int amount) {
        IItemHandlerModifiable inventory = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, inv);
        if (inventory != null) {
            return InvUtils.consumeItemsInInventory((IItemHandler)inventory, stack, amount, false);
        }
        return false;
    }

    public static Optional<IItemHandler> getItemHandler(World world, BlockPos pos, EnumFacing facing) {
        if (!world.field_72995_K) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null) {
                return Optional.ofNullable(tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing));
            }
            List entities = world.func_175647_a(Entity.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)), entity -> entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing));
            Optional entity2 = entities.stream().findFirst();
            if (entity2.isPresent()) {
                return Optional.ofNullable(((Entity)entity2.get()).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing));
            }
        }
        return Optional.ofNullable(null);
    }

    public static void ejectInventoryContents(World world, BlockPos pos, IItemHandler inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            InvUtils.ejectStackWithOffset(world, pos, inv.getStackInSlot(i));
        }
    }

    public static void clearInventory(IItemHandlerModifiable inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            inv.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    public static void copyTags(ItemStack destStack, ItemStack sourceStack) {
        if (sourceStack.func_77942_o()) {
            destStack.func_77982_d(sourceStack.func_77978_p().func_74737_b());
        }
    }

    public static ItemStack decrStackSize(IItemHandlerModifiable inv, int slot, int amount) {
        if (!inv.getStackInSlot(slot).func_190926_b()) {
            if (inv.getStackInSlot(slot).func_190916_E() <= amount) {
                ItemStack splitStack = inv.getStackInSlot(slot);
                inv.setStackInSlot(slot, ItemStack.field_190927_a);
                return splitStack;
            }
            ItemStack splitStack = inv.getStackInSlot(slot).func_77979_a(amount);
            if (inv.getStackInSlot(slot).func_190916_E() < 1) {
                inv.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            return splitStack;
        }
        return null;
    }

    public static ItemStack insertSingle(IItemHandler inv, ItemStack stack, boolean simulate) {
        return InvUtils.insert(inv, stack, 1, simulate);
    }

    public static ItemStack insert(IItemHandler inv, ItemStack stack, int count, boolean simulate) {
        ItemStack copy = stack.func_77946_l();
        if (copy.func_190916_E() > count) {
            copy.func_190920_e(count);
        }
        return InvUtils.insert(inv, copy, simulate);
    }

    public static boolean canInsert(IItemHandler inv, ItemStack stack, int count) {
        ItemStack inserted;
        ItemStack copy = stack.func_77946_l();
        if (copy.func_190916_E() > count) {
            copy.func_190920_e(count);
        }
        return !(inserted = InvUtils.insert(inv, copy, true)).equals(copy);
    }

    public static void insert(IItemHandler inv, NonNullList<ItemStack> stacks, boolean simulate) {
        stacks.forEach(stack -> InvUtils.insert(inv, stack, 0, inv.getSlots(), simulate));
    }

    public static ItemStack insert(IItemHandler inv, ItemStack stack, boolean simulate) {
        return InvUtils.insert(inv, stack, 0, inv.getSlots(), simulate);
    }

    public static ItemStack insert(IItemHandler inv, ItemStack stack, int minSlot, int maxSlot, boolean simulate) {
        return InvUtils.attemptInsert(inv, stack, minSlot, maxSlot, simulate);
    }

    public static ItemStack attemptInsert(IItemHandler inv, ItemStack stack, int minSlot, int maxSlot, boolean simulate) {
        if (InvUtils.isFull(inv)) {
            return stack;
        }
        ItemStack leftover = ItemStack.field_190927_a;
        for (int slot = minSlot; slot < maxSlot && !(leftover = inv.insertItem(slot, stack, simulate)).func_190926_b(); ++slot) {
        }
        return leftover;
    }

    public static boolean insertFromWorld(IItemHandler inv, EntityItem entity, int minSlot, int maxSlot, boolean simulate) {
        ItemStack stack = entity.func_92059_d().func_77946_l();
        ItemStack leftover = InvUtils.attemptInsert(inv, stack, minSlot, maxSlot, simulate);
        if (leftover.func_190926_b()) {
            entity.func_70106_y();
            return true;
        }
        entity.func_92058_a(leftover);
        return false;
    }

    public static boolean isFull(IItemHandler inv) {
        boolean full = true;
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack.func_190916_E() == inv.getSlotLimit(slot)) continue;
            full = false;
            break;
        }
        return full;
    }

    public static int getFirstOccupiedStackInRange(IItemHandler inv, int minSlot, int maxSlot) {
        for (int slot = minSlot; slot <= maxSlot; ++slot) {
            if (inv.getStackInSlot(slot).func_190926_b()) continue;
            return slot;
        }
        return -1;
    }

    public static int getFirstEmptyStackInRange(IItemHandler inv, int minSlot, int maxSlot) {
        for (int slot = minSlot; slot <= maxSlot; ++slot) {
            if (!inv.getStackInSlot(slot).func_190926_b()) continue;
            return slot;
        }
        return -1;
    }

    public static int getOccupiedStacks(IItemHandler inv) {
        return InvUtils.getOccupiedStacks(inv, 0, inv.getSlots() - 1);
    }

    public static int getOccupiedStacks(IItemHandler inv, int min, int max) {
        int count = 0;
        for (int i = min; i <= max; ++i) {
            if (!inv.getStackInSlot(i).func_190926_b()) continue;
            ++count;
        }
        return count;
    }

    public static int countItemStacksInInventory(IItemHandler inv, ItemStack toCheck) {
        int itemCount = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b() || !ItemStack.func_179545_c((ItemStack)toCheck, (ItemStack)stack) && (toCheck.func_77973_b() != stack.func_77973_b() || toCheck.func_77952_i() != Short.MAX_VALUE)) continue;
            if (toCheck.func_77942_o()) {
                if (!ItemStack.func_77970_a((ItemStack)toCheck, (ItemStack)stack)) continue;
                itemCount += stack.func_190916_E();
                continue;
            }
            itemCount += stack.func_190916_E();
        }
        return itemCount;
    }

    public static int countItemsInInventory(IItemHandler inv, Item item) {
        return InvUtils.countItemsInInventory(inv, item, Short.MAX_VALUE);
    }

    public static int countItemsInInventory(IItemHandler inv, Item item, int meta) {
        int itemCount = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b() || stack.func_77973_b() != item || meta != Short.MAX_VALUE && stack.func_77952_i() != meta) continue;
            itemCount += inv.getStackInSlot(i).func_190916_E();
        }
        return itemCount;
    }

    public static int countOresInInventory(IItemHandler inv, List<ItemStack> list) {
        int ret = 0;
        if (list != null && !list.isEmpty() && list.size() > 0) {
            for (ItemStack oreStack : list) {
                ret += InvUtils.countItemStacksInInventory(inv, oreStack);
            }
        }
        return ret;
    }

    public static boolean consumeItemsInInventoryStrict(IItemHandlerModifiable inv, ItemStack toCheck, int sizeOfStack, boolean simulate) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b() || !toCheck.func_77969_a(stack) && (toCheck.func_77973_b() != stack.func_77973_b() || toCheck.func_77952_i() != Short.MAX_VALUE)) continue;
            if (toCheck.func_77942_o()) {
                if (!ItemStack.func_77970_a((ItemStack)toCheck, (ItemStack)stack)) continue;
                if (stack.func_190916_E() >= sizeOfStack) {
                    InvUtils.decrStackSize(inv, i, sizeOfStack);
                    return true;
                }
                return false;
            }
            if (stack.func_190916_E() >= sizeOfStack) {
                if (!simulate) {
                    InvUtils.decrStackSize(inv, i, sizeOfStack);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean consumeItemsInInventory(IItemHandler inv, ItemStack toCheck, int sizeOfStack, boolean simulate) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack inSlot = inv.getStackInSlot(i);
            if (!toCheck.func_77969_a(inSlot) && (toCheck.func_77973_b() != inSlot.func_77973_b() || toCheck.func_77952_i() != Short.MAX_VALUE)) continue;
            return inv.extractItem(i, sizeOfStack, simulate).func_190916_E() >= sizeOfStack;
        }
        return false;
    }

    public static boolean consumeItemsInInventory(IItemHandlerModifiable inv, Item item, int meta, int stackSize) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b() || stack.func_77973_b() != item || meta != Short.MAX_VALUE && stack.func_77952_i() != meta) continue;
            if (stack.func_190916_E() >= stackSize) {
                InvUtils.decrStackSize(inv, i, stackSize);
                return false;
            }
            stackSize -= stack.func_190916_E();
            inv.setStackInSlot(i, ItemStack.field_190927_a);
        }
        return false;
    }

    public static boolean consumeOresInInventory(IItemHandlerModifiable inv, List<?> list, int stackSize) {
        if (list.size() > 0) {
            for (Object aList : list) {
                ItemStack tempStack = (ItemStack)aList;
                Item item = tempStack.func_77973_b();
                int meta = tempStack.func_77952_i();
                for (int j = 0; j < inv.getSlots(); ++j) {
                    ItemStack stack = inv.getStackInSlot(j);
                    if (stack.func_190926_b() || stack.func_77973_b() != item || stack.func_77952_i() != meta && meta != Short.MAX_VALUE) continue;
                    if (tempStack.func_77942_o()) {
                        if (!ItemStack.func_77970_a((ItemStack)tempStack, (ItemStack)stack)) continue;
                        if (stack.func_190916_E() >= stackSize) {
                            InvUtils.decrStackSize(inv, j, stackSize);
                            return false;
                        }
                        stackSize -= stack.func_190916_E();
                        inv.setStackInSlot(j, ItemStack.field_190927_a);
                        continue;
                    }
                    if (stack.func_190916_E() >= stackSize) {
                        InvUtils.decrStackSize(inv, j, stackSize);
                        return false;
                    }
                    stackSize -= stack.func_190916_E();
                    inv.setStackInSlot(j, ItemStack.field_190927_a);
                }
            }
        }
        return false;
    }

    public static int getFirstOccupiedStackNotOfItem(IItemHandler inv, Item item) {
        return InvUtils.getFirstOccupiedStackNotOfItem(inv, item, Short.MAX_VALUE);
    }

    public static int getFirstOccupiedStackNotOfItem(IItemHandler inv, Item item, int meta) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i).func_190926_b()) continue;
            int tempMeta = inv.getStackInSlot(i).func_77952_i();
            if (inv.getStackInSlot(i).func_77973_b() == item || meta != Short.MAX_VALUE && tempMeta == meta) continue;
            return i;
        }
        return -1;
    }

    public static int getFirstOccupiedStackOfItem(IItemHandler inv, Item item) {
        return InvUtils.getFirstOccupiedStackOfItem(inv, item);
    }

    public static int getFirstOccupiedStackOfItem(IItemHandler inv, ItemStack stack) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i).func_190926_b() || !InvUtils.matches(inv.getStackInSlot(i), stack)) continue;
            return i;
        }
        return -1;
    }

    public static boolean spawnStack(World world, double x, double y, double z, ItemStack stack, int pickupDelay) {
        EntityItem item = new EntityItem(world, x, y, z, stack);
        item.field_70159_w = 0.0;
        item.field_70181_x = 0.0;
        item.field_70179_y = 0.0;
        item.func_174867_a(pickupDelay);
        return world.func_72838_d((Entity)item);
    }

    public static void spawnStack(World world, double x, double y, double z, int count, ItemStack stack) {
        ItemStack copy = stack.func_77946_l();
        if (copy.func_190916_E() > count) {
            copy.func_190920_e(count);
        }
        InvUtils.spawnStack(world, x, y, z, copy, 10);
    }

    public static void ejectStackWithOffset(World world, BlockPos pos, List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            InvUtils.ejectStackWithOffset(world, pos, stack.func_77946_l());
        }
    }

    public static void ejectStackWithOffset(World world, BlockPos pos, ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            InvUtils.ejectStackWithOffset(world, pos, stack.func_77946_l());
        }
    }

    public static void ejectStackWithOffset(World world, BlockPos pos, ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        float xOff = world.field_73012_v.nextFloat() * 0.7f + 0.15f;
        float yOff = world.field_73012_v.nextFloat() * 0.2f + 0.1f;
        float zOff = world.field_73012_v.nextFloat() * 0.7f + 0.15f;
        InvUtils.ejectStack(world, (float)pos.func_177958_n() + xOff, (float)pos.func_177956_o() + yOff, (float)pos.func_177952_p() + zOff, stack, 10);
    }

    public static void ejectStack(World world, double x, double y, double z, ItemStack stack, int pickupDelay) {
        if (world.field_72995_K) {
            return;
        }
        EntityItem item = new EntityItem(world, x, y, z, stack);
        float velocity = 0.05f;
        item.field_70159_w = (float)world.field_73012_v.nextGaussian() * velocity;
        item.field_70181_x = (float)world.field_73012_v.nextGaussian() * velocity + 0.2f;
        item.field_70179_y = (float)world.field_73012_v.nextGaussian() * velocity;
        item.func_174867_a(pickupDelay);
        world.func_72838_d((Entity)item);
    }

    public static void ejectStack(World world, double x, double y, double z, ItemStack stack) {
        InvUtils.ejectStack(world, x, y, z, stack, 10);
    }

    public static void ejectBrokenItems(World world, BlockPos pos, ResourceLocation lootLocation) {
        if (!world.field_72995_K) {
            LootContext.Builder build = new LootContext.Builder((WorldServer)world);
            List stacks = world.func_184146_ak().func_186521_a(lootLocation).func_186462_a(world.field_73012_v, build.func_186471_a());
            if (!stacks.isEmpty()) {
                InvUtils.ejectStackWithOffset(world, pos, stacks);
            }
        }
    }

    public static void writeToStack(IItemHandler inv, ItemStack stack) {
        NonNullList list = NonNullList.func_191197_a((int)inv.getSlots(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i).func_190926_b()) continue;
            list.set(i, (Object)inv.getStackInSlot(i).func_77946_l());
        }
        NBTTagCompound tag = ItemStackHelper.func_191282_a((NBTTagCompound)new NBTTagCompound(), (NonNullList)list);
        if (!tag.func_82582_d()) {
            stack.func_77982_d(tag);
        }
    }

    public static void readFromStack(IItemHandler inv, ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77942_o()) {
            NonNullList list = NonNullList.func_191197_a((int)inv.getSlots(), (Object)ItemStack.field_190927_a);
            NBTTagCompound tag = stack.func_77978_p();
            if (tag != null) {
                ItemStackHelper.func_191283_b((NBTTagCompound)tag, (NonNullList)list);
                for (int i = 0; i < inv.getSlots(); ++i) {
                    inv.insertItem(i, (ItemStack)list.get(i), false);
                }
            }
        }
    }

    public static int calculateComparatorLevel(@Nonnull IItemHandler inventory) {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < inventory.getSlots(); ++j) {
            ItemStack itemstack = inventory.getStackInSlot(j);
            if (itemstack.func_190926_b()) continue;
            f += (float)itemstack.func_190916_E() / (float)itemstack.func_77976_d();
            ++i;
        }
        return MathHelper.func_76141_d((float)((f /= (float)inventory.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public static ItemStack setCount(ItemStack input, int count) {
        ItemStack stack = input.func_77946_l();
        stack.func_190920_e(count);
        return stack;
    }

    public static boolean matches(ItemStack one, ItemStack two) {
        if (one.func_77969_a(two)) {
            return true;
        }
        return one.func_77973_b() == two.func_77973_b() && (one.func_77960_j() == Short.MAX_VALUE || two.func_77960_j() == Short.MAX_VALUE);
    }
}

