/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import betterwithmods.api.block.IAxle;
import betterwithmods.api.block.IMechanical;
import betterwithmods.api.block.IMechanicalBlock;
import betterwithmods.api.capabilities.MechanicalCapability;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockAxle;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MechanicalUtil {
    public static boolean isBlockPoweredOnSide(World world, BlockPos pos, EnumFacing dir) {
        Block block;
        boolean isPowered = MechanicalUtil.isBlockPoweredByAxleOnSide(world, pos, dir);
        if (!isPowered && (block = world.func_180495_p(pos.func_177972_a(dir)).func_177230_c()) instanceof IMechanicalBlock) {
            isPowered = ((IMechanicalBlock)block).isOutputtingMechPower(world, pos.func_177972_a(dir));
        }
        return isPowered;
    }

    public static int searchForAdvMechanical(World world, BlockPos pos, EnumFacing dir) {
        int power;
        int n = power = MechanicalUtil.isBlockPoweredOnSide(world, pos, dir) ? 1 : 0;
        if (power > 0) {
            for (int i = 2; i < 5; ++i) {
                TileEntity tile;
                BlockPos off = pos.func_177967_a(dir, i);
                Block block = world.func_180495_p(off).func_177230_c();
                if (!(block instanceof IMechanical) || !((IMechanical)block).isMechanicalJunction()) continue;
                if (world.func_175625_s(off) == null || !(tile = world.func_175625_s(off)).hasCapability(MechanicalCapability.MECHANICAL_POWER, dir.func_176734_d())) break;
                power = ((IMechanicalPower)tile.getCapability(MechanicalCapability.MECHANICAL_POWER, dir.func_176734_d())).getMechanicalOutput(dir.func_176734_d());
                break;
            }
        }
        return power;
    }

    public static boolean isBlockPoweredByAxleOnSide(World world, BlockPos pos, EnumFacing dir) {
        IAxle axle;
        BlockPos pos2 = pos.func_177972_a(dir);
        Block block = world.func_180495_p(pos2).func_177230_c();
        return MechanicalUtil.isAxle(block) && (axle = (IAxle)block).isAxleOrientedToFacing((IBlockAccess)world, pos2, dir) && axle.getPowerLevel((IBlockAccess)world, pos2) > 0;
    }

    public static boolean isAxle(Block block) {
        return block instanceof IAxle;
    }

    public static boolean isPoweredByCrank(World world, BlockPos pos) {
        for (int i = 1; i < 6; ++i) {
            if (!MechanicalUtil.isPoweredByCrankOnSide(world, pos, EnumFacing.func_82600_a((int)i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isPoweredByCrankOnSide(World world, BlockPos pos, EnumFacing dir) {
        IMechanicalBlock mech;
        BlockPos offset = pos.func_177972_a(dir);
        Block block = world.func_180495_p(offset).func_177230_c();
        return block == BWMBlocks.HAND_CRANK && (mech = (IMechanicalBlock)block).isOutputtingMechPower(world, offset);
    }

    public static boolean isBlockPoweredByAxle(World world, BlockPos pos, IMechanicalBlock block) {
        for (int i = 0; i < 6; ++i) {
            if (!block.canInputPowerToSide((IBlockAccess)world, pos, EnumFacing.func_82600_a((int)i)) || !MechanicalUtil.isBlockPoweredByAxleOnSide(world, pos, EnumFacing.func_82600_a((int)i))) continue;
            return true;
        }
        return false;
    }

    public static void destoryHorizontalAxles(World world, BlockPos pos) {
        for (int i = 2; i < 6; ++i) {
            BlockAxle axle;
            Block block = world.func_180495_p(pos).func_177230_c();
            if (!MechanicalUtil.isAxle(block) || !(axle = (BlockAxle)block).isAxleOrientedToFacing((IBlockAccess)world, pos, EnumFacing.func_82600_a((int)i))) continue;
            axle.breakAxle(world, pos);
        }
    }
}

