/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import betterwithmods.BWMod;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public final class RecipeUtils {
    private RecipeUtils() {
    }

    public static IRecipe addRecipe(IRecipe recipe) {
        GameRegistry.addRecipe((IRecipe)recipe);
        return recipe;
    }

    public static ShapedOreRecipe addOreRecipe(ItemStack output, Object ... inputs) {
        ShapedOreRecipe recipe = new ShapedOreRecipe(output, inputs);
        GameRegistry.addRecipe((IRecipe)recipe);
        return recipe;
    }

    public static ShapelessOreRecipe addShapelessOreRecipe(ItemStack output, Object ... inputs) {
        ShapelessOreRecipe recipe = new ShapelessOreRecipe(output, inputs);
        GameRegistry.addRecipe((IRecipe)recipe);
        return recipe;
    }

    public static void removeFurnaceRecipe(ItemStack input) {
        FurnaceRecipes.func_77602_a().func_77599_b().entrySet().removeIf(next -> ((ItemStack)next.getKey()).func_77969_a(input) || ((ItemStack)next.getKey()).func_77973_b() == input.func_77973_b() && ((ItemStack)next.getKey()).func_77960_j() == Short.MAX_VALUE);
    }

    public static IBlockState getStateFromStack(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemBlock) {
            return ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public static ItemStack getStackFromState(IBlockState state) {
        Block block = state.func_177230_c();
        int meta = block.func_180651_a(state);
        return new ItemStack(block, 1, meta);
    }

    public static int removeShaped(ItemStack output, ItemStack[][] ingredients) {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        int ingredientsWidth = 0;
        int ingredientsHeight = 0;
        if (ingredients != null) {
            ingredientsHeight = ingredients.length;
            for (int i = 0; i < ingredients.length; ++i) {
                ingredientsWidth = Math.max(ingredientsWidth, ingredients[i].length);
            }
        }
        ArrayList<IRecipe> toRemove = new ArrayList<IRecipe>();
        ArrayList<Integer> removeIndex = new ArrayList<Integer>();
        block1: for (int i = 0; i < recipes.size(); ++i) {
            IRecipe recipe = (IRecipe)recipes.get(i);
            if (recipe.func_77571_b().func_190926_b() || !output.func_77969_a(recipe.func_77571_b())) continue;
            if (ingredients != null) {
                if (recipe instanceof ShapedRecipes) {
                    ShapedRecipes srecipe = (ShapedRecipes)recipe;
                    if (ingredientsWidth != srecipe.field_77576_b || ingredientsHeight != srecipe.field_77577_c) continue;
                    for (int j = 0; j < ingredientsHeight; ++j) {
                        ItemStack[] row = ingredients[j];
                        for (int k = 0; k < ingredientsWidth; ++k) {
                            ItemStack recipeIngredient = srecipe.field_77574_d[j * srecipe.field_77576_b + k];
                            ItemStack ingredient = k > row.length ? null : row[k];
                            if (!recipeIngredient.func_77969_a(ingredient)) continue block1;
                        }
                    }
                }
            } else if (recipe instanceof ShapelessRecipes || recipe instanceof ShapelessOreRecipe) continue;
            toRemove.add(recipe);
            removeIndex.add(i);
        }
        Iterator iterator = removeIndex.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            recipes.remove(i);
        }
        return toRemove.size();
    }

    public static void removeRecipes(Item item) {
        RecipeUtils.removeRecipes(item, Short.MAX_VALUE);
    }

    public static void removeRecipes(Item item, int meta) {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        ListIterator li = recipes.listIterator();
        boolean found = false;
        while (li.hasNext()) {
            ItemStack output = ((IRecipe)li.next()).func_77571_b();
            if (output.func_190926_b() || output.func_77973_b() != item || meta != Short.MAX_VALUE && output.func_77960_j() != meta) continue;
            li.remove();
            found = true;
        }
        if (!found) {
            BWMod.logger.error("No matching recipe found.");
        }
    }

    public static void removeRecipes(Block block) {
        RecipeUtils.removeRecipes(new ItemStack(block));
    }

    public static void removeRecipes(ItemStack output) {
        List recipeList = CraftingManager.func_77594_a().func_77592_b();
        ListIterator li = recipeList.listIterator();
        boolean found = false;
        while (li.hasNext()) {
            ItemStack o = ((IRecipe)li.next()).func_77571_b();
            if (!OreDictionary.itemMatches((ItemStack)output, (ItemStack)o, (boolean)false)) continue;
            li.remove();
            found = true;
        }
        if (!found) {
            BWMod.logger.error("No matching recipe found.");
        }
    }

    public static void removeRecipe(ItemStack output, ItemStack input) {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        ArrayList<IRecipe> toRemove = new ArrayList<IRecipe>();
        for (IRecipe recipe : recipes) {
            ShapelessRecipes shapeless;
            ShapedRecipes shaped;
            if (recipe instanceof ShapedRecipes) {
                shaped = (ShapedRecipes)recipe;
                if (shaped.func_77570_a() != 1 || !shaped.field_77574_d[0].func_77969_a(input) || !output.func_77969_a(shaped.func_77571_b())) continue;
                toRemove.add(recipe);
                continue;
            }
            if (recipe instanceof ShapedOreRecipe) {
                ItemStack stack;
                shaped = (ShapedOreRecipe)recipe;
                if (shaped.func_77570_a() != 1 || !(shaped.getInput()[0] instanceof ItemStack) || !(stack = (ItemStack)shaped.getInput()[0]).func_77969_a(input) || !output.func_77969_a(shaped.func_77571_b())) continue;
                toRemove.add(recipe);
                continue;
            }
            if (recipe instanceof ShapelessRecipes) {
                shapeless = (ShapelessRecipes)recipe;
                if (shapeless.field_77579_b.size() != 1 || !((ItemStack)shapeless.field_77579_b.get(0)).func_77969_a(input) || !output.func_77969_a(shapeless.func_77571_b())) continue;
                toRemove.add(recipe);
                continue;
            }
            if (!(recipe instanceof ShapelessOreRecipe) || (shapeless = (ShapelessOreRecipe)recipe).func_77570_a() != 1 || !(shapeless.getInput().get(0) instanceof ItemStack) || !((ItemStack)shapeless.getInput().get(0)).func_77969_a(input) || !output.func_77969_a(shapeless.func_77571_b())) continue;
            toRemove.add(recipe);
        }
        for (IRecipe remove : toRemove) {
            CraftingManager.func_77594_a().func_77592_b().remove(remove);
        }
    }

    public static ItemStack getRecipeOutput(ItemStack input) {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe recipe : recipes) {
            ShapelessRecipes shapeless;
            ItemStack stack;
            ShapedRecipes shaped;
            if (recipe instanceof ShapedRecipes ? (shaped = (ShapedRecipes)recipe).func_77570_a() == 1 && shaped.field_77574_d[0].func_77969_a(input) : recipe instanceof ShapedOreRecipe && (shaped = (ShapedOreRecipe)recipe).func_77570_a() == 1 && shaped.getInput()[0] instanceof ItemStack && (stack = (ItemStack)shaped.getInput()[0]).func_77969_a(input)) {
                return shaped.func_77571_b();
            }
            if (recipe instanceof ShapelessRecipes) {
                shapeless = (ShapelessRecipes)recipe;
                if (shapeless.field_77579_b.size() != 1 || !((ItemStack)shapeless.field_77579_b.get(0)).func_77969_a(input)) continue;
                return shapeless.func_77571_b();
            }
            if (!(recipe instanceof ShapelessOreRecipe) || (shapeless = (ShapelessOreRecipe)recipe).func_77570_a() != 1 || !(shapeless.getInput().get(0) instanceof ItemStack) || !((ItemStack)shapeless.getInput().get(0)).func_77969_a(input)) continue;
            return shapeless.func_77571_b();
        }
        return ItemStack.field_190927_a;
    }
}

