/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public final class WorldUtils {
    private WorldUtils() {
    }

    public static int getNaturalLightFromNeighbors(World worldIn, BlockPos pos) {
        return WorldUtils.getNaturalLight(worldIn, pos, true, 0);
    }

    private static int getNaturalLight(World worldIn, BlockPos pos, boolean checkNeighbors, int amount) {
        if (pos.func_177958_n() >= -30000000 && pos.func_177952_p() >= -30000000 && pos.func_177958_n() < 30000000 && pos.func_177952_p() < 30000000) {
            if (checkNeighbors && worldIn.func_180495_p(pos).func_185916_f()) {
                int i1 = WorldUtils.getNaturalLight(worldIn, pos.func_177984_a(), false, 0);
                int i = WorldUtils.getNaturalLight(worldIn, pos.func_177974_f(), false, 0);
                int j = WorldUtils.getNaturalLight(worldIn, pos.func_177976_e(), false, 0);
                int k = WorldUtils.getNaturalLight(worldIn, pos.func_177968_d(), false, 0);
                int l = WorldUtils.getNaturalLight(worldIn, pos.func_177978_c(), false, 0);
                if (i > i1) {
                    i1 = i;
                }
                if (j > i1) {
                    i1 = j;
                }
                if (k > i1) {
                    i1 = k;
                }
                if (l > i1) {
                    i1 = l;
                }
                return i1;
            }
            if (pos.func_177956_o() < 0) {
                return 0;
            }
            if (pos.func_177956_o() >= 256) {
                pos = new BlockPos(pos.func_177958_n(), 255, pos.func_177952_p());
            }
            Chunk chunk = worldIn.func_175726_f(pos);
            return WorldUtils.getNaturalLightSubtracted(chunk, pos, amount);
        }
        return 15;
    }

    private static int getNaturalLightSubtracted(Chunk chunkIn, BlockPos pos, int amount) {
        int l;
        int i = pos.func_177958_n() & 0xF;
        int j = pos.func_177956_o();
        int k = pos.func_177952_p() & 0xF;
        ExtendedBlockStorage extendedblockstorage = chunkIn.func_76587_i()[j >> 4];
        if (extendedblockstorage == Chunk.field_186036_a) {
            return !chunkIn.func_177412_p().field_73011_w.func_177495_o() && amount < EnumSkyBlock.SKY.field_77198_c ? EnumSkyBlock.SKY.field_77198_c - amount : 0;
        }
        int n = l = chunkIn.func_177412_p().field_73011_w.func_177495_o() ? 0 : extendedblockstorage.func_76670_c(i, j & 0xF, k);
        if ((l -= amount) < 0) {
            l = 0;
        }
        return l;
    }

    public static int getDistance(BlockPos pos1, BlockPos pos2) {
        if (pos1 != null && pos2 != null) {
            return (int)pos1.func_185332_f(pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
        }
        return 0;
    }

    public static boolean spawnGhast(World world, BlockPos pos) {
        EntityGhast ghast = new EntityGhast(world);
        for (int i = 0; i < 200; ++i) {
            double xPos = (double)pos.func_177958_n() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * 10.0;
            double yPos = pos.func_177956_o() + world.field_73012_v.nextInt(21) - 10;
            double zPos = (double)pos.func_177952_p() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * 10.0;
            ghast.func_70012_b(xPos, yPos, zPos, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (!ghast.func_70601_bi()) continue;
            world.func_72838_d((Entity)ghast);
            return true;
        }
        return false;
    }
}

