/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util.item;

import betterwithmods.common.registry.OreStack;
import com.google.common.base.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class Stack {
    private Object data;
    private int meta;
    private Type type;

    public Stack(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            this.data = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            this.type = Type.BLOCK;
        } else {
            this.data = stack.func_77973_b();
            this.type = Type.ITEM;
        }
        this.meta = stack.func_77960_j();
    }

    public Stack(Item item, int meta) {
        this.data = item;
        this.meta = meta;
        this.type = Type.ITEM;
    }

    public Stack(Item item) {
        this(item, 0);
    }

    public Stack(Block block, int meta) {
        this.data = block;
        this.meta = meta;
        this.type = Type.BLOCK;
    }

    public Stack(String ore) {
        this.data = new OreStack(ore, 1);
        this.type = Type.ORE;
    }

    public Object getData() {
        return this.data;
    }

    public int getMeta() {
        return this.meta;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        boolean wild;
        if (!(o instanceof Stack)) {
            return false;
        }
        Stack stack = (Stack)o;
        if (stack.type != ((Stack)o).getType()) {
            return false;
        }
        boolean bl = wild = this.meta == Short.MAX_VALUE || stack.meta == Short.MAX_VALUE;
        return wild ? stack.data == this.data : stack.data == this.data && this.meta == stack.meta;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.data});
    }

    public String toString() {
        return String.format("%s->%s:%s:%s", new Object[]{this.getType(), this.getType() == Type.BLOCK ? ((Block)this.getData()).func_149739_a() : ((Item)this.getData()).func_77667_c(new ItemStack((Item)this.data, 0, this.meta)), this.getMeta(), this.hashCode()});
    }

    private static enum Type {
        BLOCK,
        ITEM,
        ORE;

    }
}

