/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util.player;

import betterwithmods.util.player.IPlayerPenalty;

public enum GloomPenalty implements IPlayerPenalty
{
    NO_PENALTY(1.0f, 0, 0, "", true),
    GLOOM(1.5f, 1, 1200, "Gloom", true),
    DREAD(2.0f, 1200, 2400, "Dread", true),
    TERROR(3.0f, 2400, 10000000, "Terror", false);

    private final float modifier;
    private final int timeLower;
    private final int timeUpper;
    private final String description;
    public static final GloomPenalty[] VALUES;
    private final boolean canJump;

    private GloomPenalty(float modifier, int timeLower, int timeUpper, String description, boolean canJump) {
        this.modifier = modifier;
        this.timeLower = timeLower;
        this.timeUpper = timeUpper;
        this.description = description;
        this.canJump = canJump;
    }

    public boolean isInRange(int time) {
        return time > this.timeLower && time <= this.timeUpper;
    }

    @Override
    public float getModifier() {
        return this.modifier;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean canJump() {
        return this.canJump;
    }

    static {
        VALUES = GloomPenalty.values();
    }
}

