/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util.player;

import betterwithmods.common.BWMBlocks;
import betterwithmods.module.ModuleLoader;
import betterwithmods.module.hardcore.HCArmor;
import betterwithmods.module.hardcore.HCGloom;
import betterwithmods.module.hardcore.HCInjury;
import betterwithmods.module.hardcore.hchunger.HCHunger;
import betterwithmods.util.player.FatPenalty;
import betterwithmods.util.player.GloomPenalty;
import betterwithmods.util.player.HealthPenalty;
import betterwithmods.util.player.HungerPenalty;
import betterwithmods.util.player.IPlayerPenalty;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public final class PlayerHelper {
    protected static final UUID penaltySpeedUUID = UUID.fromString("c5595a67-9410-4fb2-826a-bcaf432c6a6f");

    private PlayerHelper() {
    }

    public static boolean isSurvival(EntityPlayer player) {
        return !player.func_184812_l_() && !player.func_175149_v() && !player.func_175149_v();
    }

    public static float getSpeedModifier(EntityPlayer player) {
        return Math.min(PlayerHelper.getFatPenalty(player).getModifier(), PlayerHelper.getHungerPenalty(player).getModifier());
    }

    public static GloomPenalty getGloomPenalty(EntityPlayer player) {
        if (!ModuleLoader.isFeatureEnabled(HCGloom.class)) {
            return GloomPenalty.NO_PENALTY;
        }
        int gloom = HCGloom.getGloomTime(player);
        GloomPenalty penalty = GloomPenalty.NO_PENALTY;
        for (GloomPenalty p : GloomPenalty.VALUES) {
            if (!p.isInRange(gloom)) continue;
            penalty = p;
        }
        return penalty;
    }

    public static IPlayerPenalty getWorstPenalty(EntityPlayer player) {
        HungerPenalty hungerPenalty = PlayerHelper.getHungerPenalty(player);
        FatPenalty fatPenalty = PlayerHelper.getFatPenalty(player);
        int maximumOrdinal = Math.max(hungerPenalty.ordinal(), fatPenalty.ordinal());
        if (maximumOrdinal == hungerPenalty.ordinal()) {
            return hungerPenalty;
        }
        if (maximumOrdinal == fatPenalty.ordinal()) {
            return fatPenalty;
        }
        return hungerPenalty;
    }

    public static HungerPenalty getHungerPenalty(EntityPlayer player) {
        if (!ModuleLoader.isFeatureEnabled(HCHunger.class)) {
            return HungerPenalty.NO_PENALTY;
        }
        int level = player.func_71024_bL().func_75116_a();
        if (level > 24) {
            return HungerPenalty.NO_PENALTY;
        }
        if (level > 18) {
            return HungerPenalty.PECKISH;
        }
        if (level > 12) {
            return HungerPenalty.HUNGRY;
        }
        if (level > 6) {
            return HungerPenalty.FAMISHED;
        }
        if (level > 0 || player.func_71024_bL().func_75115_e() > 0.0f) {
            return HungerPenalty.STARVING;
        }
        return HungerPenalty.DYING;
    }

    public static FatPenalty getFatPenalty(EntityPlayer player) {
        if (!ModuleLoader.isFeatureEnabled(HCHunger.class)) {
            return FatPenalty.NO_PENALTY;
        }
        int level = (int)player.func_71024_bL().func_75115_e();
        if (level < 36) {
            return FatPenalty.NO_PENALTY;
        }
        if (level < 42) {
            return FatPenalty.PLUMP;
        }
        if (level < 48) {
            return FatPenalty.CHUBBY;
        }
        if (level < 52) {
            return FatPenalty.FAT;
        }
        return FatPenalty.OBESE;
    }

    public static HealthPenalty getHealthPenalty(EntityPlayer player) {
        if (!ModuleLoader.isFeatureEnabled(HCInjury.class)) {
            return HealthPenalty.NO_PENALTY;
        }
        int level = (int)player.func_110143_aJ();
        if (level > 10) {
            return HealthPenalty.NO_PENALTY;
        }
        if (level > 8) {
            return HealthPenalty.HURT;
        }
        if (level > 6) {
            return HealthPenalty.INJURED;
        }
        if (level > 4) {
            return HealthPenalty.WOUNDED;
        }
        if (level > 2) {
            return HealthPenalty.CRIPPLED;
        }
        return HealthPenalty.DYING;
    }

    public static boolean canJump(EntityPlayer player) {
        return PlayerHelper.getHungerPenalty(player).canJump() && PlayerHelper.getHealthPenalty(player).canJump() && PlayerHelper.getFatPenalty(player).canJump() && PlayerHelper.getGloomPenalty(player).canJump();
    }

    public static boolean canSwim(EntityPlayer player) {
        return !PlayerHelper.isWeighted(player) && player.func_110143_aJ() > 4.0f;
    }

    public static boolean isNearBottom(EntityPlayer player) {
        Block toCheck = player.func_130014_f_().func_180495_p(player.func_180425_c().func_177977_b()).func_177230_c();
        Block toCheck2 = player.func_130014_f_().func_180495_p(player.func_180425_c().func_177979_c(2)).func_177230_c();
        return !toCheck.func_176200_f((IBlockAccess)player.func_130014_f_(), player.func_180425_c().func_177977_b()) || !toCheck2.func_176200_f((IBlockAccess)player.func_130014_f_(), player.func_180425_c().func_177979_c(2));
    }

    public static void changeAttack(EntityLivingBase entity, UUID attackModifierUUID, String name, double multiplier) {
        AttributeModifier attackModifier = new AttributeModifier(attackModifierUUID, name, multiplier - 1.0, 2);
        IAttributeInstance iattributeinstance = entity.func_110148_a(SharedMonsterAttributes.field_111264_e);
        if (iattributeinstance.func_111127_a(attackModifierUUID) != null) {
            iattributeinstance.func_111124_b(attackModifier);
        }
        iattributeinstance.func_111121_a(attackModifier);
    }

    public static void changeSpeed(EntityLivingBase entity, String name, double modifier) {
        AttributeModifier speedModifier = new AttributeModifier(penaltySpeedUUID, name, modifier - 1.0, 2);
        IAttributeInstance iattributeinstance = entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (iattributeinstance.func_111127_a(penaltySpeedUUID) != null) {
            iattributeinstance.func_111124_b(speedModifier);
        }
        iattributeinstance.func_111121_a(speedModifier);
    }

    private static int getWornArmorWeight(EntityPlayer player) {
        int weight = 0;
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (stack == null) continue;
            weight = (int)((float)weight + HCArmor.getWeight(stack));
        }
        return weight;
    }

    private static boolean isWeighted(EntityPlayer player) {
        return PlayerHelper.getWornArmorWeight(player) >= 10 || PlayerHelper.hasHeadCrab(player);
    }

    private static boolean hasHeadCrab(EntityPlayer player) {
        return player.func_184218_aH() && player.func_184187_bx() instanceof EntitySquid;
    }

    public static float getGloomExhaustionModifier(EntityPlayer player) {
        if (!ModuleLoader.isFeatureEnabled(HCGloom.class)) {
            return 1.0f;
        }
        GloomPenalty gloom = PlayerHelper.getGloomPenalty(player);
        if (gloom != null) {
            return gloom.getModifier();
        }
        return 1.0f;
    }

    public static float getArmorExhaustionModifier(EntityPlayer player) {
        float modifier = 1.0f;
        int weight = PlayerHelper.getWornArmorWeight(player);
        if (weight > 0) {
            modifier += (float)weight / 44.0f;
        }
        return modifier;
    }

    public static boolean isCurrentToolEffectiveOnBlock(EntityPlayer player, BlockPos pos) {
        World world;
        IBlockState state;
        ItemStack stack = player.func_184614_ca();
        return PlayerHelper.isCurrentToolEffectiveOnBlock(stack, state = (world = player.func_130014_f_()).func_180495_p(pos).func_185899_b((IBlockAccess)world, pos)) && ForgeHooks.isToolEffective((IBlockAccess)player.func_130014_f_(), (BlockPos)pos, (ItemStack)stack);
    }

    public static boolean isCurrentToolEffectiveOnBlock(ItemStack stack, IBlockState state) {
        NBTTagCompound stats;
        if (stack == null) {
            return false;
        }
        if (state.func_177230_c() == BWMBlocks.STUMP) {
            return false;
        }
        if (stack.func_77942_o() && (stats = stack.func_179543_a("Stats")) != null) {
            return stats.func_74771_c("Broken") != 1;
        }
        for (String type : stack.func_77973_b().getToolClasses(stack)) {
            if (type == "mattock") {
                return state.func_177230_c().isToolEffective("shovel", state) || state.func_177230_c().isToolEffective("axe", state);
            }
            if (!state.func_177230_c().isToolEffective(type, state)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getPlayerHead(EntityPlayer player) {
        ItemStack head = new ItemStack(Items.field_151144_bL, 1, 3);
        NBTTagCompound name = new NBTTagCompound();
        name.func_74778_a("SkullOwner", player.getDisplayNameString());
        head.func_77982_d(name);
        return head;
    }
}

