/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.block.IWaterCurrent;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.mechanical.BlockWaterwheel;
import betterwithmods.common.blocks.mechanical.tile.TileAxleGenerator;
import betterwithmods.util.DirUtils;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityWaterwheel
extends TileAxleGenerator {
    public static HashMap<Block, IWaterCurrent> WATER_BLOCKS = new HashMap();

    public static void registerWater(Block block) {
        if (block instanceof BlockLiquid) {
            TileEntityWaterwheel.registerWater(block, IWaterCurrent.VANILLA_LIQUID);
        } else if (block instanceof BlockFluidBase) {
            TileEntityWaterwheel.registerWater(block, IWaterCurrent.FORGE_LIQUID);
        } else {
            TileEntityWaterwheel.registerWater(block, IWaterCurrent.NO_FLOW);
        }
    }

    public static void registerWater(Block block, IWaterCurrent handler) {
        WATER_BLOCKS.put(block, handler);
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    public static boolean isWater(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return TileEntityWaterwheel.isVanillaWater(state) || TileEntityWaterwheel.isForgeFluid(state.func_177230_c()) || WATER_BLOCKS.containsKey(state.func_177230_c());
    }

    public static boolean isWater(IBlockState state) {
        return TileEntityWaterwheel.isVanillaWater(state) || TileEntityWaterwheel.isForgeFluid(state.func_177230_c()) || WATER_BLOCKS.containsKey(state.func_177230_c());
    }

    public IWaterCurrent getCurrentHandler(IBlockState state) {
        if (TileEntityWaterwheel.isVanillaWater(state)) {
            return IWaterCurrent.VANILLA_LIQUID;
        }
        if (TileEntityWaterwheel.isForgeFluid(state.func_177230_c())) {
            return IWaterCurrent.FORGE_LIQUID;
        }
        return WATER_BLOCKS.get(state.func_177230_c());
    }

    private static boolean isVanillaWater(IBlockState state) {
        return state.func_177230_c() instanceof BlockLiquid && state.func_185904_a() == Material.field_151586_h;
    }

    private static boolean isForgeFluid(Block block) {
        return block instanceof BlockFluidBase && ((BlockFluidBase)block).getFluid() == FluidRegistry.WATER;
    }

    @Override
    public void verifyIntegrity() {
        boolean isAir = true;
        boolean hasWater = true;
        if (this.getBlockWorld().func_180495_p(this.field_174879_c).func_177230_c() == BWMBlocks.WATERWHEEL) {
            EnumFacing.Axis axis = (EnumFacing.Axis)this.getBlockWorld().func_180495_p(this.field_174879_c).func_177229_b(DirUtils.AXIS);
            for (int i = -2; i <= 2; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    int xPos = axis == EnumFacing.Axis.Z ? i : 0;
                    int zPos = axis == EnumFacing.Axis.X ? i : 0;
                    BlockPos offset = this.field_174879_c.func_177982_a(xPos, j, zPos);
                    if (j == -2) {
                        hasWater = TileEntityWaterwheel.isWater(this.field_145850_b, offset);
                    }
                    if (!hasWater && !(hasWater = this.sidesHaveWater())) break;
                    if (i == 0 && j == 0) continue;
                    if (j > -2) {
                        IBlockState state = this.field_145850_b.func_180495_p(offset);
                        boolean replaceable = state.func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, offset);
                        isAir = i == -2 || i == 2 ? replaceable || TileEntityWaterwheel.isWater(this.field_145850_b, offset) : replaceable;
                    }
                    if (!isAir) break;
                }
                if (!isAir || !hasWater) break;
            }
        }
        this.isValid = isAir && hasWater;
    }

    public boolean sidesHaveWater() {
        EnumFacing.Axis axis = (EnumFacing.Axis)this.getBlockWorld().func_180495_p(this.field_174879_c).func_177229_b(DirUtils.AXIS);
        int leftWater = 0;
        int rightWater = 0;
        boolean bottomIsUnobstructed = true;
        for (int i = -2; i <= 2; ++i) {
            int xLeft = axis == EnumFacing.Axis.Z ? -2 : 0;
            int xRight = axis == EnumFacing.Axis.Z ? 2 : 0;
            int zLeft = axis == EnumFacing.Axis.X ? -2 : 0;
            int zRight = axis == EnumFacing.Axis.X ? 2 : 0;
            BlockPos leftPos = this.field_174879_c.func_177982_a(xLeft, i, zLeft);
            BlockPos rightPos = this.field_174879_c.func_177982_a(xRight, i, zRight);
            if (TileEntityWaterwheel.isWater(this.field_145850_b, leftPos)) {
                ++leftWater;
            } else if (TileEntityWaterwheel.isWater(this.field_145850_b, rightPos)) {
                ++rightWater;
            }
            int xP = axis == EnumFacing.Axis.Z ? i : 0;
            int yP = -2;
            int zP = axis == EnumFacing.Axis.X ? i : 0;
            BlockPos bPos = this.field_174879_c.func_177982_a(xP, yP, zP);
            boolean bl = bottomIsUnobstructed = this.getBlockWorld().func_175623_d(bPos) || TileEntityWaterwheel.isWater(this.field_145850_b, bPos);
            if (!bottomIsUnobstructed) break;
        }
        return !(!bottomIsUnobstructed || leftWater == 0 && rightWater == 0 || leftWater >= rightWater && leftWater <= rightWater);
    }

    @Override
    public void calculatePower() {
        byte power = 0;
        if (this.isValid()) {
            int i;
            Vec3d overallFlow = Vec3d.field_186680_a;
            EnumFacing.Axis axis = (EnumFacing.Axis)this.getBlockWorld().func_180495_p(this.field_174879_c).func_177229_b(DirUtils.AXIS);
            int leftWater = 0;
            int rightWater = 0;
            for (i = 0; i < 3; ++i) {
                int metaPos = i - 1;
                int xP = axis == EnumFacing.Axis.Z ? metaPos : 0;
                int zP = axis == EnumFacing.Axis.X ? metaPos : 0;
                BlockPos lowPos = this.field_174879_c.func_177982_a(xP, -2, zP);
                IBlockState lowState = this.getBlockWorld().func_180495_p(lowPos);
                IWaterCurrent current = this.getCurrentHandler(lowState);
                if (current == null) continue;
                overallFlow = overallFlow.func_178787_e(current.getFlowDirection(this.getBlockWorld(), lowPos, lowState));
            }
            for (i = -1; i < 3; ++i) {
                int xLeft = axis == EnumFacing.Axis.Z ? -2 : 0;
                int xRight = axis == EnumFacing.Axis.Z ? 2 : 0;
                int zLeft = axis == EnumFacing.Axis.X ? -2 : 0;
                int zRight = axis == EnumFacing.Axis.X ? 2 : 0;
                BlockPos leftPos = this.field_174879_c.func_177982_a(xLeft, i, zLeft);
                BlockPos rightPos = this.field_174879_c.func_177982_a(xRight, i, zRight);
                if (TileEntityWaterwheel.isWater(this.field_145850_b, leftPos)) {
                    ++leftWater;
                }
                if (!TileEntityWaterwheel.isWater(this.field_145850_b, rightPos)) continue;
                ++rightWater;
            }
            int xFlow = Math.abs(overallFlow.field_72450_a) > 2.0 ? (int)Math.signum(overallFlow.field_72450_a) : 0;
            int zFlow = Math.abs(overallFlow.field_72449_c) > 2.0 ? (int)Math.signum(overallFlow.field_72449_c) : 0;
            int relevantFlow = 0;
            if (axis == EnumFacing.Axis.X) {
                relevantFlow = zFlow;
            }
            if (axis == EnumFacing.Axis.Z) {
                relevantFlow = xFlow;
            }
            this.waterMod = leftWater > rightWater || relevantFlow > 0 && leftWater >= rightWater ? -1.0f : (rightWater > leftWater || relevantFlow < 0 && rightWater >= leftWater ? 1.0f : 0.0f);
            if (this.waterMod != 0.0f) {
                power = 1;
            }
        }
        if (power != this.power) {
            this.setPower(power);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        IBlockState state = this.getBlockWorld().func_180495_p(this.field_174879_c);
        if (!(state.func_177230_c() instanceof BlockWaterwheel)) {
            return Block.field_185505_j;
        }
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(DirUtils.AXIS);
        EnumFacing facing = axis == EnumFacing.Axis.Z ? EnumFacing.SOUTH : EnumFacing.EAST;
        Vec3i vec = facing.func_176730_m();
        int xP = axis == EnumFacing.Axis.Z ? this.getRadius() : 0;
        int yP = this.getRadius();
        int zP = axis == EnumFacing.Axis.X ? this.getRadius() : 0;
        return new AxisAlignedBB((double)(-xP), (double)(-yP), (double)(-zP), (double)xP, (double)yP, (double)zP).func_72317_d(0.5, 0.5, 0.5).func_186670_a(this.field_174879_c).func_72321_a((double)vec.func_177958_n(), (double)vec.func_177956_o(), (double)vec.func_177952_p());
    }

    @Override
    public Block getBlock() {
        return this.func_145838_q();
    }

    @Override
    public int getRadius() {
        return 2;
    }
}

