/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.penalties.attribute;

import betterwithmods.common.penalties.attribute.Attribute;
import betterwithmods.common.penalties.attribute.AttributeInstance;
import betterwithmods.common.penalties.attribute.BooleanAttribute;
import betterwithmods.common.penalties.attribute.FloatAttribute;
import betterwithmods.common.penalties.attribute.IAttribute;
import betterwithmods.common.penalties.attribute.PotionAttribute;
import betterwithmods.common.penalties.attribute.PotionTemplate;
import betterwithmods.common.penalties.attribute.StringAttribute;
import betterwithmods.module.ConfigHelper;
import java.util.Arrays;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.Range;

public class BWMAttributes {
    public static Attribute<Boolean> JUMP;
    public static Attribute<Boolean> SWIM;
    public static Attribute<Boolean> HEAL;
    public static Attribute<Boolean> SPRINT;
    public static Attribute<Boolean> ATTACK;
    public static Attribute<Boolean> PAIN;
    public static Attribute<Boolean> GRUE;
    public static Attribute<Float> SPEED;
    public static Attribute<Float> SPOOKED;
    public static Attribute<Float> DAMAGE;
    public static Attribute<String> SOUND;
    public static Attribute<String> SOUND_SPOOKED;
    public static Attribute<PotionTemplate[]> POTION;

    public static void registerAttributes() {
        JUMP = new BooleanAttribute(new ResourceLocation("betterwithmods", "jump"), true).setDescription("Can the player jump with this penalty active?");
        SWIM = new BooleanAttribute(new ResourceLocation("betterwithmods", "swim"), true).setDescription("Can the player swim with this penalty active?");
        HEAL = new BooleanAttribute(new ResourceLocation("betterwithmods", "heal"), true).setDescription("Can the player heal with this penalty active?");
        SPRINT = new BooleanAttribute(new ResourceLocation("betterwithmods", "sprint"), true).setDescription("Can the player sprint with this penalty active?");
        ATTACK = new BooleanAttribute(new ResourceLocation("betterwithmods", "attack"), true).setDescription("Can the player attack with this penalty active?");
        PAIN = new BooleanAttribute(new ResourceLocation("betterwithmods", "pain"), false).setDescription("Is the player in pain? (Plays the OOF noise periodically)");
        GRUE = new BooleanAttribute(new ResourceLocation("betterwithmods", "grue"), false).setDescription("Can the player be eaten by the Grue when this is active?");
        SPEED = new FloatAttribute(new ResourceLocation("betterwithmods", "speed"), Float.valueOf(1.0f)).setDescription("Speed modifier when this penalty is active. (Multiplies the player's existing speed)");
        SPOOKED = new FloatAttribute(new ResourceLocation("betterwithmods", "spooked"), Float.valueOf(0.0f)).setDescription("Does the player start to go insane when this is active?");
        DAMAGE = new FloatAttribute(new ResourceLocation("betterwithmods", "damage"), Float.valueOf(0.0f)).setDescription("How much damage does the player take when this is active?");
        SOUND = new StringAttribute(new ResourceLocation("betterwithmods", "sound"), "").setDescription("Which sound event to play when this is active?");
        SOUND_SPOOKED = new StringAttribute(new ResourceLocation("betterwithmods", "sound_spooked"), "").setDescription("Which sound event to play when spooked?");
        POTION = new PotionAttribute(new ResourceLocation("betterwithmods", "potion"), new PotionTemplate[0]).setDescription("Which potions to apply when this is active?");
    }

    public static boolean isCustom(String category) {
        return ConfigHelper.loadPropBool("Customized", category, "Set this to true to allow more granular configs to generate and make the penalties work as you please. Requires the game to be started to generate more configs.", false);
    }

    public static AttributeInstance<Boolean> getBooleanAttribute(IAttribute<Boolean> parent, String category, String penalty, String desc, Boolean defaultValue) {
        boolean value = BWMAttributes.isCustom(category) ? ConfigHelper.loadPropBool(parent.getRegistryName().func_110623_a(), String.join((CharSequence)".", category, penalty), desc, defaultValue) : defaultValue;
        return new AttributeInstance<Boolean>(parent, value);
    }

    public static AttributeInstance<String> getStringAttribute(IAttribute<String> parent, String category, String penalty, String desc, String defaultValue) {
        String value = BWMAttributes.isCustom(category) ? ConfigHelper.loadPropString(parent.getRegistryName().func_110623_a(), String.join((CharSequence)".", category, penalty), desc, defaultValue) : defaultValue;
        return new AttributeInstance<String>(parent, value);
    }

    public static AttributeInstance<Float> getFloatAttribute(IAttribute<Float> parent, String category, String penalty, String desc, Float defaultValue) {
        float value = BWMAttributes.isCustom(category) ? (float)ConfigHelper.loadPropDouble(parent.getRegistryName().func_110623_a(), String.join((CharSequence)".", category, penalty), desc, defaultValue.floatValue()) : defaultValue.floatValue();
        return new AttributeInstance<Float>(parent, Float.valueOf(value));
    }

    public static AttributeInstance<PotionTemplate[]> getPotionAttribute(IAttribute<PotionTemplate[]> parent, String category, String penalty, String desc, PotionTemplate[] defaultValue) {
        PotionTemplate[] value = BWMAttributes.isCustom(category) ? BWMAttributes.loadPotionList(parent, category, penalty, desc, defaultValue) : defaultValue;
        return new AttributeInstance<PotionTemplate[]>(parent, value);
    }

    private static PotionTemplate[] loadPotionList(IAttribute<PotionTemplate[]> parent, String category, String penalty, String desc, PotionTemplate[] defaultValue) {
        String[] templateList = (String[])Arrays.stream(defaultValue).map(PotionTemplate::serialize).toArray(String[]::new);
        String[] stringList = ConfigHelper.loadPropStringList(parent.getRegistryName().func_110623_a(), String.join((CharSequence)".", category, penalty), desc, templateList);
        return (PotionTemplate[])Arrays.stream(stringList).map(PotionTemplate::deserialize).toArray(PotionTemplate[]::new);
    }

    public static <T extends Number> Range<T> getRange(String category, String penalty, String desc, Range<T> defaultValue) {
        if (BWMAttributes.isCustom(category)) {
            Number max = (Number)defaultValue.getMaximum();
            Number min = (Number)defaultValue.getMinimum();
            if (max instanceof Float) {
                Float upper = Float.valueOf((float)ConfigHelper.loadPropDouble("Upper Range", String.join((CharSequence)".", category, penalty), desc, max.doubleValue()));
                Float lower = Float.valueOf((float)ConfigHelper.loadPropDouble("Lower Range", String.join((CharSequence)".", category, penalty), desc, min.doubleValue()));
                return Range.between((Comparable)upper, (Comparable)lower);
            }
            if (max instanceof Integer) {
                Integer upper = ConfigHelper.loadPropInt("Upper Range", String.join((CharSequence)".", category, penalty), desc, max.intValue());
                Integer lower = ConfigHelper.loadPropInt("Lower Range", String.join((CharSequence)".", category, penalty), desc, min.intValue());
                return Range.between((Comparable)upper, (Comparable)lower);
            }
        } else {
            return defaultValue;
        }
        return null;
    }
}

